/*
 * Decompiled with CFR 0.152.
 */
package net.lightbody.bmp.proxy.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.util.Date;
import net.lightbody.bmp.proxy.http.RequestInfo;
import net.lightbody.bmp.proxy.util.Log;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.HttpInetSocketAddress;
import org.apache.http.conn.scheme.HostNameResolver;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.java_bandwidthlimiter.StreamManager;

public class SimulatedSocketFactory
implements SchemeSocketFactory {
    private static Log LOG = new Log();
    private HostNameResolver hostNameResolver;
    private StreamManager streamManager;
    private static Method getHostMethod;

    public SimulatedSocketFactory(HostNameResolver hostNameResolver, StreamManager streamManager) {
        assert (hostNameResolver != null);
        assert (streamManager != null);
        this.hostNameResolver = hostNameResolver;
        this.streamManager = streamManager;
    }

    public static <T extends Socket> void configure(T sock) {
        try {
            sock.setReuseAddress(true);
            sock.setSoLinger(true, 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Socket createSocket(HttpParams httpParams) {
        Socket newSocket = new Socket(){

            @Override
            public void connect(SocketAddress endpoint) throws IOException {
                Date start = new Date();
                super.connect(endpoint);
                Date end = new Date();
                RequestInfo.get().connect(start, end);
            }

            @Override
            public void connect(SocketAddress endpoint, int timeout) throws IOException {
                Date start = new Date();
                super.connect(endpoint, timeout);
                Date end = new Date();
                RequestInfo.get().connect(start, end);
            }

            @Override
            public InputStream getInputStream() throws IOException {
                return SimulatedSocketFactory.this.streamManager.registerStream(super.getInputStream());
            }

            @Override
            public OutputStream getOutputStream() throws IOException {
                return SimulatedSocketFactory.this.streamManager.registerStream(super.getOutputStream());
            }
        };
        SimulatedSocketFactory.configure(newSocket);
        return newSocket;
    }

    private String resolveHostName(InetSocketAddress remoteAddress) {
        String hostString = null;
        try {
            hostString = (String)getHostMethod.invoke((Object)remoteAddress, new Object[0]);
        }
        catch (InvocationTargetException ite) {
            throw new RuntimeException("Expecting InetSocketAddress to have a package scoped \"getHostString\" method which returns a String and takes no input");
        }
        catch (IllegalAccessException iae) {
            throw new RuntimeException("Expecting InetSocketAddress to have a package scoped \"getHostString\" method which returns a String and takes no input");
        }
        return hostString;
    }

    public Socket connectSocket(Socket sock, InetSocketAddress remoteAddress, InetSocketAddress localAddress, HttpParams params) throws IOException {
        if (remoteAddress == null) {
            throw new IllegalArgumentException("Target host may not be null.");
        }
        if (params == null) {
            throw new IllegalArgumentException("Parameters may not be null.");
        }
        if (sock == null) {
            sock = this.createSocket(null);
        }
        if (localAddress != null) {
            sock.bind(localAddress);
        }
        String hostName = remoteAddress instanceof HttpInetSocketAddress ? ((HttpInetSocketAddress)remoteAddress).getHttpHost().getHostName() : this.resolveHostName(remoteAddress);
        InetSocketAddress remoteAddr = remoteAddress;
        if (this.hostNameResolver != null) {
            remoteAddr = new InetSocketAddress(this.hostNameResolver.resolve(hostName), remoteAddress.getPort());
        }
        int timeout = HttpConnectionParams.getConnectionTimeout((HttpParams)params);
        try {
            sock.connect(remoteAddr, timeout);
        }
        catch (SocketTimeoutException ex) {
            throw new ConnectTimeoutException("Connect to " + remoteAddress + " timed out");
        }
        return sock;
    }

    public final boolean isSecure(Socket sock) throws IllegalArgumentException {
        if (sock == null) {
            throw new IllegalArgumentException("Socket may not be null.");
        }
        if (sock.isClosed()) {
            throw new IllegalArgumentException("Socket is closed.");
        }
        return false;
    }

    static {
        try {
            getHostMethod = InetSocketAddress.class.getDeclaredMethod("getHostString", new Class[0]);
            if (!Modifier.isPublic(getHostMethod.getModifiers())) {
                getHostMethod = null;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (getHostMethod == null) {
            try {
                getHostMethod = InetSocketAddress.class.getDeclaredMethod("getHostName", new Class[0]);
                LOG.warn("Using InetSocketAddress.getHostName() rather than InetSocketAddress.getHostString(). Consider upgrading to Java 7 for faster performance!", new Object[0]);
            }
            catch (NoSuchMethodException e) {
                String msg = "Something is wrong inside SimulatedSocketFactory and I don't know why!";
                LOG.severe(msg, e);
                throw new RuntimeException(msg, e);
            }
        }
        getHostMethod.setAccessible(true);
    }
}

