/*
 * Decompiled with CFR 0.152.
 */
package net.lightbody.bmp.proxy.http;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import net.lightbody.bmp.proxy.http.SimulatedSSLSocket;
import net.lightbody.bmp.proxy.http.SimulatedSocketFactory;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.scheme.HostNameResolver;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.params.HttpParams;
import org.java_bandwidthlimiter.StreamManager;

public class TrustingSSLSocketFactory
extends SSLSocketFactory {
    private static SSLContext sslContext;
    private StreamManager streamManager;

    public TrustingSSLSocketFactory(HostNameResolver nameResolver, StreamManager streamManager) {
        super(sslContext, nameResolver);
        assert (nameResolver != null);
        assert (streamManager != null);
        this.streamManager = streamManager;
    }

    private Socket createSimulatedSocket(SSLSocket socket) {
        SimulatedSocketFactory.configure(socket);
        socket.setEnabledProtocols(new String[]{SSLAlgorithm.SSLv3.name(), SSLAlgorithm.TLSv1.name()});
        return new SimulatedSSLSocket(socket, this.streamManager);
    }

    public Socket createSocket() throws IOException {
        SSLSocket sslSocket = (SSLSocket)super.createSocket();
        return this.createSimulatedSocket(sslSocket);
    }

    public Socket connectSocket(Socket socket, String host, int port, InetAddress localAddress, int localPort, HttpParams params) throws IOException, UnknownHostException, ConnectTimeoutException {
        SSLSocket sslSocket = (SSLSocket)super.connectSocket(socket, host, port, localAddress, localPort, params);
        if (sslSocket instanceof SimulatedSSLSocket) {
            return sslSocket;
        }
        return this.createSimulatedSocket(sslSocket);
    }

    public Socket createSocket(HttpParams params) throws IOException {
        SSLSocket sslSocket = (SSLSocket)super.createSocket(params);
        return this.createSimulatedSocket(sslSocket);
    }

    public Socket connectSocket(Socket socket, InetSocketAddress remoteAddress, InetSocketAddress localAddress, HttpParams params) throws IOException, ConnectTimeoutException {
        SSLSocket sslSocket = (SSLSocket)super.connectSocket(socket, remoteAddress, localAddress, params);
        if (sslSocket instanceof SimulatedSSLSocket) {
            return sslSocket;
        }
        return this.createSimulatedSocket(sslSocket);
    }

    static {
        try {
            sslContext = SSLContext.getInstance(SSLAlgorithm.SSLv3.name());
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("TLS algorithm not found! Critical SSL error!", e);
        }
        X509TrustManager easyTrustManager = new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        };
        try {
            sslContext.init(null, new TrustManager[]{easyTrustManager}, null);
        }
        catch (KeyManagementException e) {
            throw new RuntimeException("Unexpected key management error", e);
        }
    }

    public static enum SSLAlgorithm {
        SSLv3,
        TLSv1;

    }
}

