/*
 * Decompiled with CFR 0.152.
 */
package net.lightbody.bmp.proxy.jetty.jetty.jmx;

import java.io.IOException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import net.lightbody.bmp.proxy.jetty.http.jmx.HttpServerMBean;
import net.lightbody.bmp.proxy.jetty.jetty.Server;
import net.lightbody.bmp.proxy.jetty.log.LogFactory;
import org.apache.commons.logging.Log;

public class ServerMBean
extends HttpServerMBean {
    private static Log log = LogFactory.getLog(ServerMBean.class);
    private Server _jettyServer;
    private String _configuration;

    public ServerMBean(Server jettyServer) throws MBeanException, InstanceNotFoundException {
        super(jettyServer);
    }

    public ServerMBean() throws MBeanException, InstanceNotFoundException {
        this(new Server());
    }

    public ServerMBean(String configuration) throws IOException, MBeanException, InstanceNotFoundException {
        this(new Server());
        this._configuration = configuration;
    }

    @Override
    protected ObjectName newObjectName(MBeanServer server) {
        return this.uniqueObjectName(server, ServerMBean.getDefaultDomain() + ":Server=");
    }

    @Override
    protected void defineManagedResource() {
        super.defineManagedResource();
        this.defineAttribute("configuration");
        this.defineAttribute("rootWebApp");
        this.defineAttribute("webApplicationConfigurationClassNames");
        this.defineOperation("addWebApplication", new String[]{"java.lang.String", "java.lang.String"}, 1);
        this.defineOperation("addWebApplication", new String[]{"java.lang.String", "java.lang.String", "java.lang.String"}, 1);
        this.defineOperation("addWebApplications", new String[]{"java.lang.String", "java.lang.String"}, 1);
        this._jettyServer = (Server)this.getManagedResource();
    }

    @Override
    public void postRegister(Boolean ok) {
        super.postRegister(ok);
        if (ok.booleanValue() && this._configuration != null) {
            try {
                this._jettyServer.configure(this._configuration);
                this._jettyServer.start();
            }
            catch (Exception e) {
                log.warn((Object)"EXCEPTION ", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void postDeregister() {
        this._configuration = null;
        try {
            if (null != this._jettyServer) {
                this._jettyServer.stop();
            }
        }
        catch (Exception e) {
            log.warn((Object)e);
        }
        finally {
            super.postDeregister();
        }
    }
}

