/*
 * Decompiled with CFR 0.152.
 */
package net.lightbody.bmp.proxy.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Date;
import net.lightbody.bmp.proxy.util.BandwidthSimulator;

public class IOUtils {
    private static final int BUFFER = 4096;

    public static void copy(InputStream in, OutputStream out) throws IOException {
        int length;
        byte[] buffer = new byte[4096];
        while ((length = in.read(buffer)) != -1) {
            out.write(buffer, 0, length);
        }
        out.close();
        in.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Stats copyWithStats(InputStream is, OutputStream os, BandwidthSimulator simulator, boolean copyOutputForReadingLater) throws IOException {
        Date timeToFirstByte = null;
        byte[] buffer = new byte[4096];
        int bytes = 0;
        ByteArrayInputStream bais = null;
        try {
            int length;
            ByteArrayOutputStream baos = null;
            if (copyOutputForReadingLater) {
                baos = new ByteArrayOutputStream();
            }
            int maxBytes = Math.min(simulator.maximumBytes(bytes), buffer.length);
            int firstByte = is.read();
            os.write(firstByte);
            if (copyOutputForReadingLater) {
                baos.write(firstByte);
            }
            ++bytes;
            timeToFirstByte = new Date();
            do {
                if ((length = is.read(buffer, 0, maxBytes)) != -1) {
                    bytes += length;
                    os.write(buffer, 0, length);
                    if (copyOutputForReadingLater) {
                        baos.write(buffer, 0, length);
                    }
                }
                maxBytes = Math.min(simulator.maximumBytes(bytes), buffer.length);
            } while (length != -1);
            if (copyOutputForReadingLater) {
                bais = new ByteArrayInputStream(baos.toByteArray());
            }
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {}
            try {
                os.close();
            }
            catch (IOException e) {}
        }
        return new Stats(bytes, timeToFirstByte, bais);
    }

    public static String readFully(InputStream in) throws IOException {
        int length;
        StringBuilder sb = new StringBuilder();
        byte[] buffer = new byte[4096];
        while ((length = in.read(buffer)) != -1) {
            sb.append(new String(buffer, 0, length, "UTF-8"));
        }
        in.close();
        return sb.toString();
    }

    public static String readFully(InputStreamReader in) throws IOException {
        int length;
        StringBuilder sb = new StringBuilder();
        char[] buffer = new char[4096];
        while ((length = in.read(buffer)) != -1) {
            sb.append(new String(buffer, 0, length));
        }
        in.close();
        return sb.toString();
    }

    public static class Stats {
        private long bytesCopied;
        private Date timeToFirstByte;
        private InputStream copy;

        public Stats(long bytesCopied, Date timeToFirstByte, InputStream copy) {
            this.bytesCopied = bytesCopied;
            this.timeToFirstByte = timeToFirstByte;
            this.copy = copy;
        }

        public long getBytesCopied() {
            return this.bytesCopied;
        }

        public Date getTimeToFirstByte() {
            return this.timeToFirstByte;
        }

        public InputStream getCopy() {
            return this.copy;
        }
    }
}

