/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.basic.action;

import cn.hutool.crypto.SecureUtil;
import com.alibaba.fastjson.serializer.SerializeFilter;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.mingsoft.base.entity.BaseEntity;
import net.mingsoft.base.filter.DateValueFilter;
import net.mingsoft.base.filter.DoubleValueFilter;
import net.mingsoft.base.util.JSONArray;
import net.mingsoft.base.util.JSONObject;
import net.mingsoft.basic.action.BaseAction;
import net.mingsoft.basic.bean.EUListBean;
import net.mingsoft.basic.biz.IManagerBiz;
import net.mingsoft.basic.constant.e.SessionConstEnum;
import net.mingsoft.basic.entity.ManagerEntity;
import net.mingsoft.basic.entity.ManagerSessionEntity;
import net.mingsoft.basic.util.BasicUtil;
import net.mingsoft.basic.util.StringUtil;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import springfox.documentation.annotations.ApiIgnore;

@Api(value="\u7ba1\u7406\u5458\u7ba1\u7406\u63a5\u53e3")
@Controller
@RequestMapping(value={"/${ms.manager.path}/basic/manager"})
public class ManagerAction
extends BaseAction {
    @Autowired
    private IManagerBiz managerBiz;

    @GetMapping(value={"/index"})
    public String index(HttpServletResponse response, HttpServletRequest request) {
        return "/basic/manager/index";
    }

    @ApiOperation(value="\u67e5\u8be2\u7ba1\u7406\u5458\u5217\u8868")
    @GetMapping(value={"/list"})
    @ResponseBody
    public void list(@ModelAttribute @ApiIgnore ManagerEntity manager, HttpServletResponse response, HttpServletRequest request, @ApiIgnore ModelMap model) {
        ManagerSessionEntity managerSession = this.getManagerBySession(request);
        BasicUtil.startPage();
        List<ManagerEntity> managerList = this.managerBiz.queryAllChildManager(managerSession.getManagerId());
        this.outJson(response, JSONArray.toJSONString((Object)new EUListBean(managerList, (int)BasicUtil.endPage(managerList).getTotal()), (SerializeFilter[])new SerializeFilter[]{new DoubleValueFilter(), new DateValueFilter()}));
    }

    @ApiOperation(value="\u67e5\u8be2\u7ba1\u7406\u5458\u5217\u8868,\u53bb\u6389\u5f53\u524d\u7ba1\u7406\u5458id\uff0c\u786e\u4fdd\u4e0d\u80fd\u5220\u9664\u548c\u4fee\u6539\u81ea\u5df1")
    @GetMapping(value={"/query"})
    @ResponseBody
    public void query(HttpServletResponse response, HttpServletRequest request, @ApiIgnore ModelMap model) {
        ManagerSessionEntity managerSession = this.getManagerBySession(request);
        BasicUtil.startPage();
        List<ManagerEntity> managerList = this.managerBiz.queryAllChildManager(managerSession.getManagerId());
        for (ManagerEntity _manager : managerList) {
            if (_manager.getManagerId() != managerSession.getManagerId()) continue;
            _manager.setManagerId(0);
        }
        this.outJson(response, JSONArray.toJSONString((Object)new EUListBean(managerList, (int)BasicUtil.endPage(managerList).getTotal()), (SerializeFilter[])new SerializeFilter[]{new DoubleValueFilter(), new DateValueFilter()}));
    }

    @ApiOperation(value="\u83b7\u53d6\u7ba1\u7406\u5458\u63a5\u53e3")
    @GetMapping(value={"/get"})
    @ResponseBody
    public void get(@ModelAttribute @ApiIgnore ManagerEntity manager, HttpServletResponse response, HttpServletRequest request, @ApiIgnore ModelMap model) {
        ManagerEntity managerEntity = new ManagerEntity();
        if (manager.getManagerId() > 0) {
            managerEntity = (ManagerEntity)this.managerBiz.getEntity(manager.getManagerId());
        } else {
            ManagerEntity managerSession = (ManagerEntity)((Object)BasicUtil.getSession(SessionConstEnum.MANAGER_SESSION));
            managerEntity = (ManagerEntity)this.managerBiz.getEntity(managerSession.getManagerId());
        }
        managerEntity.setManagerPassword("");
        this.outJson(response, (BaseEntity)managerEntity);
    }

    @ApiOperation(value="\u4fdd\u5b58\u7ba1\u7406\u5458\u5b9e\u4f53")
    @ApiImplicitParams(value={@ApiImplicitParam(name="managerName", value="\u5e10\u53f7", required=true, paramType="query"), @ApiImplicitParam(name="managerNickName", value="\u6635\u79f0", required=true, paramType="query"), @ApiImplicitParam(name="managerPassword", value="\u5bc6\u7801", required=true, paramType="query"), @ApiImplicitParam(name="managerRoleID", value="\u89d2\u8272ID", required=false, paramType="query"), @ApiImplicitParam(name="managerPeopleID", value="\u7528\u6237ID", required=false, paramType="query")})
    @PostMapping(value={"/save"})
    @ResponseBody
    @RequiresPermissions(value={"manager:save"})
    public void save(@ModelAttribute @ApiIgnore ManagerEntity manager, HttpServletResponse response, HttpServletRequest request) {
        ManagerEntity newManager = new ManagerEntity();
        newManager.setManagerName(manager.getManagerName());
        if (this.managerBiz.getEntity((BaseEntity)newManager) != null) {
            this.outJson(response, null, false, this.getResString("err.exist", new String[]{this.getResString("manager.name")}));
            return;
        }
        if (StringUtil.isBlank(manager.getManagerName())) {
            this.outJson(response, null, false, this.getResString("err.empty", new String[]{this.getResString("manager.name")}));
            return;
        }
        if (!StringUtil.checkLength(manager.getManagerName() + "", 1, 15)) {
            this.outJson(response, null, false, this.getResString("err.length", new String[]{this.getResString("manager.name"), "1", "15"}));
            return;
        }
        if (StringUtil.isBlank(manager.getManagerNickName())) {
            this.outJson(response, null, false, this.getResString("err.empty", new String[]{this.getResString("manager.nickname")}));
            return;
        }
        if (!StringUtil.checkLength(manager.getManagerNickName() + "", 1, 15)) {
            this.outJson(response, null, false, this.getResString("err.length", new String[]{this.getResString("manager.nickname"), "1", "15"}));
            return;
        }
        if (StringUtil.isBlank(manager.getManagerPassword())) {
            this.outJson(response, null, false, this.getResString("err.empty", new String[]{this.getResString("manager.password")}));
            return;
        }
        if (!StringUtil.checkLength(manager.getManagerPassword() + "", 1, 45)) {
            this.outJson(response, null, false, this.getResString("err.length", new String[]{this.getResString("manager.password"), "1", "45"}));
            return;
        }
        manager.setManagerPassword(SecureUtil.md5((String)manager.getManagerPassword()));
        manager.setManagerTime(new Date());
        this.managerBiz.saveEntity((BaseEntity)manager);
        this.outJson(response, JSONObject.toJSONString((Object)((Object)manager)));
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u7ba1\u7406\u5458")
    @PostMapping(value={"/delete"})
    @ResponseBody
    @RequiresPermissions(value={"manager:del"})
    public void delete(@RequestBody List<ManagerEntity> managers, HttpServletResponse response, HttpServletRequest request) {
        int[] ids = new int[managers.size()];
        for (int i = 0; i < managers.size(); ++i) {
            ids[i] = managers.get(i).getManagerId();
        }
        this.managerBiz.delete(ids);
        this.outJson(response, true);
    }

    @ApiOperation(value="\u66f4\u65b0\u7ba1\u7406\u5458\u4fe1\u606f\u7ba1\u7406\u5458")
    @ApiImplicitParams(value={@ApiImplicitParam(name="managerName", value="\u5e10\u53f7", required=true, paramType="query"), @ApiImplicitParam(name="managerNickName", value="\u6635\u79f0", required=true, paramType="query"), @ApiImplicitParam(name="managerPassword", value="\u5bc6\u7801", required=true, paramType="query"), @ApiImplicitParam(name="managerRoleID", value="\u89d2\u8272ID", required=false, paramType="query"), @ApiImplicitParam(name="managerPeopleID", value="\u7528\u6237ID", required=false, paramType="query")})
    @PostMapping(value={"/update"})
    @ResponseBody
    @RequiresPermissions(value={"manager:update"})
    public void update(@ModelAttribute @ApiIgnore ManagerEntity manager, HttpServletResponse response, HttpServletRequest request) {
        ManagerEntity newManager = new ManagerEntity();
        newManager.setManagerName(manager.getManagerName());
        ManagerEntity _manager = (ManagerEntity)((Object)this.managerBiz.getEntity((BaseEntity)newManager));
        if (_manager != null && manager.getManagerId() != _manager.getManagerId()) {
            this.outJson(response, null, false, this.getResString("err.exist", new String[]{this.getResString("manager.name")}));
            return;
        }
        if (StringUtil.isBlank(manager.getManagerName())) {
            this.outJson(response, null, false, this.getResString("err.empty", new String[]{this.getResString("manager.name")}));
            return;
        }
        if (!StringUtil.checkLength(manager.getManagerName() + "", 1, 15)) {
            this.outJson(response, null, false, this.getResString("err.length", new String[]{this.getResString("manager.name"), "1", "15"}));
            return;
        }
        if (StringUtil.isBlank(manager.getManagerNickName())) {
            this.outJson(response, null, false, this.getResString("err.empty", new String[]{this.getResString("manager.nickname")}));
            return;
        }
        if (!StringUtil.checkLength(manager.getManagerNickName() + "", 1, 15)) {
            this.outJson(response, null, false, this.getResString("err.length", new String[]{this.getResString("manager.nickname"), "1", "15"}));
            return;
        }
        if (!StringUtil.isBlank(manager.getManagerPassword())) {
            if (!StringUtil.checkLength(manager.getManagerPassword() + "", 1, 45)) {
                this.outJson(response, null, false, this.getResString("err.length", new String[]{this.getResString("manager.password"), "1", "45"}));
                return;
            }
            manager.setManagerPassword(SecureUtil.md5((String)manager.getManagerPassword()));
        }
        this.managerBiz.updateEntity((BaseEntity)manager);
        this.outJson(response, JSONObject.toJSONString((Object)((Object)manager)));
    }
}

