/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.basic.biz.impl;

import java.io.File;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import net.mingsoft.base.dao.IBaseDao;
import net.mingsoft.basic.biz.IColumnBiz;
import net.mingsoft.basic.biz.impl.CategoryBizImpl;
import net.mingsoft.basic.dao.IColumnDao;
import net.mingsoft.basic.entity.ColumnEntity;
import net.mingsoft.basic.util.BasicUtil;
import net.mingsoft.basic.util.SpringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="columnBiz")
public class ColumnBizImpl
extends CategoryBizImpl
implements IColumnBiz {
    private IColumnDao columnDao;

    public IColumnDao getColumnDao() {
        return this.columnDao;
    }

    @Autowired
    public void setColumnDao(IColumnDao columnDao) {
        this.columnDao = columnDao;
    }

    @Override
    protected IBaseDao getDao() {
        return this.columnDao;
    }

    @Override
    public List<ColumnEntity> queryColumnListByWebsiteId(int columnWebsiteId) {
        return this.columnDao.queryColumnListByWebsiteId(columnWebsiteId);
    }

    @Override
    public List<ColumnEntity> queryChild(int categoryCategoryId, int columnWebsiteId, Integer modelId, Integer size) {
        return this.columnDao.queryColumnByCategoryIdAndWebsiteIdAndModelId(categoryCategoryId, columnWebsiteId, modelId, size);
    }

    @Override
    public List<ColumnEntity> queryAll(int appId, int modelId) {
        return this.columnDao.queryByAppIdAndModelId(appId, modelId);
    }

    @Override
    public List<ColumnEntity> queryAll(int modelId) {
        return this.columnDao.queryByAppIdAndModelId(BasicUtil.getAppId(), modelId);
    }

    private void queryExpansionColumnListByWebsiteId(int categoryCategoryId, List<ColumnEntity> list, int columnWebsiteId) {
        List<Object> queryChildList = new ArrayList();
        queryChildList = this.columnDao.queryColumnByCategoryIdAndWebsiteIdAndModelId(categoryCategoryId, columnWebsiteId, null, null);
        for (int i = 0; i < queryChildList.size(); ++i) {
            list.add((ColumnEntity)((Object)queryChildList.get(i)));
        }
        if (categoryCategoryId != 0) {
            ColumnEntity columnEntity = (ColumnEntity)this.columnDao.getEntity(categoryCategoryId);
            this.queryExpansionColumnListByWebsiteId(columnEntity.getCategoryCategoryId(), list, columnWebsiteId);
        }
    }

    @Override
    public List<ColumnEntity> querySibling(int columnId, Integer size) {
        ColumnEntity columnEntity = (ColumnEntity)this.columnDao.getEntity(columnId);
        List<ColumnEntity> list = new ArrayList<ColumnEntity>();
        if (columnEntity != null) {
            list = this.columnDao.queryColumnByCategoryIdAndWebsiteIdAndModelId(columnEntity.getCategoryCategoryId(), columnEntity.getAppId(), null, size);
        }
        return list;
    }

    @Override
    public List<ColumnEntity> queryTopSiblingListByColumnId(int columnId, Integer size) {
        ColumnEntity columnEntity = (ColumnEntity)this.columnDao.getEntity(columnId);
        List<ColumnEntity> list = null;
        if (columnEntity != null) {
            list = this.querySibling(columnEntity.getCategoryCategoryId(), size);
        }
        return list;
    }

    @Override
    public List<ColumnEntity> queryChildListByColumnId(int columnId, Integer size) {
        ColumnEntity columnEntity = (ColumnEntity)this.columnDao.getEntity(columnId);
        List<ColumnEntity> list = null;
        if (columnEntity != null) {
            list = this.columnDao.queryColumnByCategoryIdAndWebsiteIdAndModelId(columnEntity.getCategoryId(), columnEntity.getAppId(), null, size);
        }
        return list;
    }

    @Override
    public int[] queryChildIdsByColumnId(int categoryId, int appId) {
        List<Integer> ids = this.columnDao.queryColumnChildIdList(categoryId, appId);
        int[] ret = new int[ids.size()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = ids.get(i);
        }
        return ret;
    }

    private void queryColumnParent(ColumnEntity column, List<ColumnEntity> list) {
        if (column.getCategoryCategoryId() != 0) {
            ColumnEntity columnEntity = (ColumnEntity)this.columnDao.getEntity(column.getCategoryCategoryId());
            list.add(columnEntity);
            this.queryColumnParent(columnEntity, list);
        }
    }

    @Override
    public List<ColumnEntity> queryParentColumnByColumnId(int columnId) {
        ArrayList<ColumnEntity> list = null;
        ColumnEntity columnEntity = (ColumnEntity)this.columnDao.getEntity(columnId);
        if (columnEntity != null) {
            list = new ArrayList<ColumnEntity>();
            this.queryColumnParent(columnEntity, list);
        }
        return list;
    }

    @Override
    public int queryColumnChildListCountByWebsiteId(int categoryCategoryId, int columnWebsiteId) {
        return this.columnDao.queryColumnChildListCountByWebsiteId(categoryCategoryId, columnWebsiteId);
    }

    private void columnPath(ColumnEntity column) {
        IColumnBiz columnBiz = SpringUtil.getBean(IColumnBiz.class);
        String columnPath = "";
        String delFile = "";
        if ((column = (ColumnEntity)columnBiz.getEntity(column.getCategoryId())).getCategoryCategoryId() == 0) {
            column.setColumnPath(File.separator + column.getCategoryId());
        } else {
            List<ColumnEntity> list = columnBiz.queryParentColumnByColumnId(column.getCategoryId());
            if (list != null && list.size() > 0) {
                String temp = "";
                for (int i = list.size() - 1; i >= 0; --i) {
                    ColumnEntity entity = list.get(i);
                    columnPath = columnPath + File.separator + entity.getCategoryId();
                    temp = temp + File.separator + entity.getCategoryId();
                }
                column.setColumnPath(columnPath + File.separator + column.getCategoryId());
            }
        }
        columnBiz.updateEntity(column);
    }

    @Override
    public void save(ColumnEntity column, int modelCode, int CategoryManagerId) {
        column.setCategoryAppId(BasicUtil.getAppId());
        column.setAppId(BasicUtil.getAppId());
        column.setCategoryManagerId(CategoryManagerId);
        column.setCategoryDateTime(new Timestamp(System.currentTimeMillis()));
        column.setCategoryModelId(modelCode);
        if (column.getColumnType() == ColumnEntity.ColumnTypeEnum.COLUMN_TYPE_COVER.toInt()) {
            column.setColumnListUrl(null);
        }
        super.saveCategory(column);
        this.columnPath(column);
    }

    @Override
    public void delete(int[] columns) {
        for (int i = 0; i < columns.length; ++i) {
            if (this.getEntity(columns[i]) == null) continue;
            super.deleteCategory(columns[i]);
        }
    }

    @Override
    public void update(ColumnEntity column, int modelCode, int managerId) {
        int websiteId = BasicUtil.getAppId();
        if (column.getColumnType() == ColumnEntity.ColumnTypeEnum.COLUMN_TYPE_COVER.toInt()) {
            column.setColumnListUrl(null);
        }
        column.setCategoryManagerId(managerId);
        column.setAppId(websiteId);
        super.updateCategory(column);
        this.columnPath(column);
        List<ColumnEntity> childList = this.queryChild(column.getCategoryId(), websiteId, modelCode, null);
        if (childList != null && childList.size() > 0) {
            for (int i = 0; i < childList.size(); ++i) {
                childList.get(i).setCategoryCategoryId(column.getCategoryId());
                childList.get(i).setCategoryManagerId(managerId);
                childList.get(i).setAppId(websiteId);
                super.updateCategory(childList.get(i));
                this.columnPath(childList.get(i));
            }
        }
    }
}

