/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.basic.action;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.crypto.SecureUtil;
import io.swagger.annotations.Api;
import java.util.HashMap;
import java.util.List;
import java.util.MissingResourceException;
import javax.servlet.http.HttpServletRequest;
import net.mingsoft.basic.biz.IAppBiz;
import net.mingsoft.basic.constant.e.CookieConstEnum;
import net.mingsoft.basic.constant.e.SessionConstEnum;
import net.mingsoft.basic.entity.ManagerSessionEntity;
import net.mingsoft.basic.util.BasicUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

@Api(value="\u57fa\u7840\u5e94\u7528\u5c42\u7684\u7236\u7c7bbase")
public abstract class BaseAction
extends net.mingsoft.base.action.BaseAction {
    @Autowired
    private IAppBiz appBiz;
    @Value(value="${ms.manager.check-code:true}")
    private Boolean checkCode;

    protected ManagerSessionEntity getManagerBySession() {
        ManagerSessionEntity managerSession = (ManagerSessionEntity)((Object)BasicUtil.getSession(SessionConstEnum.MANAGER_SESSION));
        if (managerSession != null) {
            return managerSession;
        }
        return null;
    }

    protected boolean isSystemManager() {
        ManagerSessionEntity manager = this.getManagerBySession();
        return manager.getRoleId() == 1;
    }

    protected String getResString(String key) {
        String str = "";
        try {
            str = super.getResString(key);
        }
        catch (MissingResourceException e) {
            str = this.getLocaleString(key, "net.mingsoft.basic.resources.resources");
        }
        return str;
    }

    protected boolean checkRandCode() {
        return this.checkRandCode(SessionConstEnum.CODE_SESSION.toString());
    }

    protected String decryptByAES(HttpServletRequest request, String str) {
        String _str = SecureUtil.aes((byte[])SecureUtil.md5((String)(BasicUtil.getApp().getAppId() + "")).substring(16).getBytes()).decryptStr(str);
        return _str;
    }

    protected String encryptByAES(HttpServletRequest request, String str) {
        String _str = SecureUtil.aes((byte[])SecureUtil.md5((String)(BasicUtil.getApp().getAppId() + "")).substring(16).getBytes()).encryptHex(str);
        return _str;
    }

    protected String getRandCode() {
        return BasicUtil.getSession(SessionConstEnum.CODE_SESSION) + "";
    }

    protected String redirectBack(boolean flag) {
        if (flag) {
            return "redirect:" + BasicUtil.getCookie(CookieConstEnum.BACK_COOKIE);
        }
        return BasicUtil.getCookie(CookieConstEnum.BACK_COOKIE);
    }

    protected boolean checkRandCode(String param) {
        if (!this.checkCode.booleanValue()) {
            return true;
        }
        String sessionCode = this.getRandCode();
        String requestCode = BasicUtil.getString(param);
        this.LOG.debug("session_code:" + sessionCode + " requestCode:" + requestCode);
        return sessionCode.equalsIgnoreCase(requestCode);
    }

    @Deprecated
    protected void removeUrlParams(HttpServletRequest request, String[] fitlers) {
        request.setAttribute("params", (Object)BasicUtil.assemblyRequestUrlParams(fitlers));
    }

    protected boolean validated(String tableName, String fieldName, String fieldValue) {
        HashMap<String, String> where = new HashMap<String, String>(1);
        where.put(fieldName, fieldValue);
        List list = this.appBiz.queryBySQL(tableName, null, where);
        return ObjectUtil.isNotNull((Object)list) && !list.isEmpty();
    }

    protected boolean validated(String tableName, String fieldName, String fieldValue, String id, String idName) {
        HashMap<String, String> where = new HashMap<String, String>(1);
        where.put(fieldName, fieldValue);
        List list = this.appBiz.queryBySQL(tableName, null, where);
        if (ObjectUtil.isNotNull((Object)list) && !list.isEmpty()) {
            return list.size() != 1 || !id.equals(((HashMap)list.get(0)).get(idName).toString());
        }
        return false;
    }
}

