/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.basic.biz.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import net.mingsoft.base.biz.impl.BaseBizImpl;
import net.mingsoft.base.constant.e.BaseEnum;
import net.mingsoft.base.dao.IBaseDao;
import net.mingsoft.base.entity.BaseEntity;
import net.mingsoft.basic.biz.IModelBiz;
import net.mingsoft.basic.biz.IRoleModelBiz;
import net.mingsoft.basic.constant.e.ModelIsMenuEnum;
import net.mingsoft.basic.dao.IModelDao;
import net.mingsoft.basic.entity.ModelEntity;
import net.mingsoft.basic.entity.RoleModelEntity;
import net.mingsoft.basic.exception.BusinessException;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="modelBiz")
@Transactional
public class ModelBizImpl
extends BaseBizImpl<IModelDao, ModelEntity>
implements IModelBiz {
    private IModelDao modelDao;
    @Autowired
    private IRoleModelBiz roleModelBiz;

    @Override
    public ModelEntity getEntityByModelCode(BaseEnum modelCode) {
        return this.modelDao.getEntityByModelCode(modelCode.toString());
    }

    @Override
    public ModelEntity getEntityByModelCode(String modelCode) {
        return this.modelDao.getEntityByModelCode(modelCode);
    }

    public IModelDao getModelDao() {
        return this.modelDao;
    }

    @Autowired
    public void setModelDao(IModelDao modelDao) {
        this.modelDao = modelDao;
    }

    protected IBaseDao getDao() {
        return this.modelDao;
    }

    @Override
    public ModelEntity getModel(String modelType, int modelId) {
        return this.modelDao.getModel(modelType, modelId);
    }

    @Override
    public List<ModelEntity> queryModelByRoleId(int roleId) {
        return this.modelDao.queryModelByRoleId(roleId);
    }

    @Override
    @Deprecated
    @Transactional(rollbackFor={Exception.class, Error.class})
    public void reModel(ModelEntity modelParent, String parentIds, int mangerRoleId, List<RoleModelEntity> roleModels, Integer parentId) {
        modelParent.setModelIsMenu(ObjectUtil.isNotNull(modelParent.getModelChildList()) && modelParent.getModelChildList().size() > 0 ? Integer.valueOf(1) : Integer.valueOf(0));
        modelParent.setModelId(parentId);
        modelParent.setModelDatetime(new Timestamp(System.currentTimeMillis()));
        modelParent.setModelParentIds(parentIds);
        ModelEntity modelParentEntity = this.getEntityByModelCode(modelParent.getModelCode());
        if (modelParentEntity == null) {
            if (modelParent.getModelIsMenu().intValue() == ModelIsMenuEnum.MODEL_MEUN.toInt()) {
                ModelEntity modelEntity = new ModelEntity();
                modelEntity.setModelIsMenu(ModelIsMenuEnum.MODEL_MEUN.toInt());
                modelEntity.setModelTitle(modelParent.getModelTitle());
                modelEntity.setModelId(modelParent.getModelId());
                if (ObjectUtil.isNotEmpty((Object)this.getEntity(modelEntity))) {
                    throw new BusinessException("\u83dc\u5355\u6807\u9898\u91cd\u590d");
                }
            }
            this.saveEntity(modelParent);
            RoleModelEntity roleModel = new RoleModelEntity();
            roleModel.setRoleId(mangerRoleId);
            roleModel.setModelId(Integer.parseInt(modelParent.getId()));
            roleModels.add(roleModel);
        } else {
            modelParent.setId(modelParentEntity.getId());
            this.updateEntity(modelParent);
        }
        if (ObjectUtil.isNotNull(modelParent.getModelChildList()) && modelParent.getModelChildList().size() > 0) {
            for (ModelEntity modelEntity : modelParent.getModelChildList()) {
                this.reModel(modelEntity, StringUtils.isBlank((CharSequence)parentIds) ? modelParent.getId() : parentIds + "," + modelParent.getId(), mangerRoleId, roleModels, Integer.parseInt(modelParent.getId()));
            }
        }
    }

    @Override
    @Deprecated
    @Transactional(rollbackFor={Exception.class})
    public void jsonToModel(String menuStr, int mangerRoleId, int modelId) {
        ArrayList<RoleModelEntity> roleModels = new ArrayList<RoleModelEntity>();
        if (StringUtils.isNotBlank((CharSequence)menuStr)) {
            List list = JSONArray.parseArray((String)menuStr, ModelEntity.class);
            for (ModelEntity modelParent : list) {
                ModelEntity entity = (ModelEntity)((Object)this.getEntity(modelParent));
                if (entity != null && (entity.getModelId() == null || entity.getModelId() == 0)) {
                    this.deleteEntity(Integer.parseInt(entity.getId()));
                }
                this.reModel(modelParent, null, mangerRoleId, roleModels, modelId);
            }
            if (roleModels.size() > 0) {
                this.roleModelBiz.saveBatch(roleModels, roleModels.size());
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class, Error.class})
    public void importModel(ModelEntity modelEntity, int mangerRoleId, String parentIds, Integer modelId) {
        ArrayList<RoleModelEntity> roleModels = new ArrayList<RoleModelEntity>();
        modelEntity.setId("");
        modelEntity.setModelDatetime(new Timestamp(System.currentTimeMillis()));
        if (modelId != null && modelId != 0) {
            modelEntity.setModelId(modelId);
            modelEntity.setModelParentIds(parentIds);
        } else {
            modelEntity.setModelId(null);
            modelEntity.setModelParentIds(null);
        }
        this.modelDao.saveEntity(modelEntity);
        RoleModelEntity roleModel = new RoleModelEntity();
        roleModel.setRoleId(mangerRoleId);
        roleModel.setModelId(Integer.parseInt(modelEntity.getId()));
        roleModels.add(roleModel);
        if (roleModels.size() > 0) {
            this.roleModelBiz.saveBatch(roleModels, roleModels.size());
        }
        if (ObjectUtil.isNotNull(modelEntity.getModelChildList()) && modelEntity.getModelChildList().size() > 0) {
            for (ModelEntity curModelEntity : modelEntity.getModelChildList()) {
                parentIds = StringUtils.isBlank((CharSequence)parentIds) || modelId == null || modelId == 0 ? modelEntity.getId() : modelId + "," + modelEntity.getId();
                this.importModel(curModelEntity, mangerRoleId, parentIds, Integer.parseInt(modelEntity.getId()));
            }
        }
    }

    @Override
    public void updateEntity(ModelEntity model) {
        this.setParentId(model);
        this.modelDao.updateById((Object)model);
        this.setChildParentId(model);
        this.modelDao.updateCache();
    }

    @Override
    public void saveEntity(ModelEntity model) {
        this.setParentId(model);
        this.modelDao.insert((Object)model);
        this.modelDao.updateCache();
    }

    @Override
    public List<ModelEntity> queryChildList(ModelEntity modelEntity) {
        ModelEntity model = (ModelEntity)((Object)this.modelDao.selectOne((Wrapper)new QueryWrapper((Object)modelEntity)));
        if (model == null) {
            return null;
        }
        ModelEntity _model = new ModelEntity();
        _model.setModelId(model.getIntId());
        List list = this.modelDao.selectList((Wrapper)new QueryWrapper((Object)_model));
        return list;
    }

    private void setParentId(ModelEntity model) {
        if (model.getModelId() != null && model.getModelId() > 0) {
            ModelEntity _model = (ModelEntity)this.modelDao.getEntity(model.getModelId());
            if (StringUtils.isEmpty((CharSequence)_model.getModelParentIds())) {
                model.setModelParentIds(_model.getId());
            } else {
                model.setModelParentIds(_model.getModelParentIds() + "," + _model.getId());
            }
        } else {
            model.setModelParentIds(null);
            model.setModelId(null);
        }
    }

    private void setChildParentId(ModelEntity model) {
        ModelEntity _model = new ModelEntity();
        _model.setModelId(Integer.parseInt(model.getId()));
        List list = this.modelDao.query(_model);
        list.forEach(x -> {
            if (StringUtils.isEmpty((CharSequence)model.getModelParentIds())) {
                x.setModelParentIds(model.getId());
            } else {
                x.setModelParentIds(model.getModelParentIds() + "," + model.getId());
            }
            super.updateEntity((BaseEntity)x);
            this.setChildParentId((ModelEntity)((Object)x));
        });
    }
}

