/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.basic.action;

import cn.hutool.core.io.FileUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.mingsoft.base.entity.ResultData;
import net.mingsoft.basic.action.BaseFileAction;
import net.mingsoft.basic.annotation.LogAnn;
import net.mingsoft.basic.constant.e.BusinessTypeEnum;
import net.mingsoft.basic.util.BasicUtil;
import net.mingsoft.config.MSProperties;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(tags={"\u540e\u7aef-\u57fa\u7840\u63a5\u53e3"})
@Controller(value="ManageFileAction")
@RequestMapping(value={"${ms.manager.path}/file"})
public class ManageFileAction
extends BaseFileAction {
    @ApiOperation(value="\u5904\u7406post\u8bf7\u6c42\u4e0a\u4f20\u6587\u4ef6")
    @LogAnn(title="\u5904\u7406post\u8bf7\u6c42\u4e0a\u4f20\u6587\u4ef6", businessType=BusinessTypeEnum.OTHER)
    @PostMapping(value={"/upload"})
    @ResponseBody
    public ResultData upload(BaseFileAction.Bean bean, boolean uploadFloderPath, HttpServletRequest req, HttpServletResponse res) throws IOException {
        if (this.checkUploadPath(bean)) {
            return ResultData.build().error();
        }
        if (bean.isAppId()) {
            bean.setUploadPath(BasicUtil.getApp().getAppId() + File.separator + bean.getUploadPath());
        }
        BaseFileAction.Config config = new BaseFileAction.Config(bean.getUploadPath(), bean.getFile(), null, uploadFloderPath, bean.isRename());
        return this.upload(config);
    }

    @ApiOperation(value="\u5904\u7406post\u8bf7\u6c42\u4e0a\u4f20\u6a21\u677f\u6587\u4ef6")
    @PostMapping(value={"/uploadTemplate"})
    @ResponseBody
    public ResultData uploadTemplate(BaseFileAction.Bean bean, boolean uploadFloderPath, HttpServletResponse res) throws IOException {
        String uploadTemplatePath = MSProperties.upload.template;
        if (this.checkUploadPath(bean)) {
            return ResultData.build().error(this.getResString("err.error", new String[]{this.getResString("file.type")}));
        }
        if (StringUtils.isEmpty((CharSequence)bean.getUploadPath())) {
            bean.setUploadPath(uploadTemplatePath + File.separator + BasicUtil.getApp().getAppId());
        }
        BaseFileAction.Config config = new BaseFileAction.Config(bean.getUploadPath(), bean.getFile(), null, uploadFloderPath, bean.isRename());
        return this.uploadTemplate(config);
    }

    protected boolean checkUploadPath(BaseFileAction.Bean bean) {
        return bean.getUploadPath() != null && (bean.getUploadPath().contains("../") || bean.getUploadPath().contains("..\\"));
    }

    @ApiOperation(value="\u5904\u7406WEB-INF\u6587\u4ef6\u4e0b\u8f7d\u63a5\u53e3")
    @PostMapping(value={"/download"})
    public void download(String filePath, HttpServletResponse response) {
        if (StringUtils.isEmpty((CharSequence)filePath)) {
            return;
        }
        if (filePath.contains("../") || filePath.contains("..\\")) {
            return;
        }
        response.setHeader("content-type", "application/octet-stream");
        response.setContentType("application/octet-stream");
        String fileName = filePath.substring(filePath.lastIndexOf("/") + 1);
        try {
            fileName = new String(fileName.getBytes("UTF-8"), "ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        response.setHeader("Content-Disposition", "attachment;filename=" + fileName);
        try {
            FileUtil.writeToStream((String)BasicUtil.getRealPath("WEB-INF/" + filePath), (OutputStream)response.getOutputStream());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

