/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.basic.action;

import cn.hutool.crypto.SecureUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.mingsoft.base.entity.ResultData;
import net.mingsoft.basic.action.BaseAction;
import net.mingsoft.basic.annotation.LogAnn;
import net.mingsoft.basic.bean.EUListBean;
import net.mingsoft.basic.biz.IManagerBiz;
import net.mingsoft.basic.constant.e.BusinessTypeEnum;
import net.mingsoft.basic.entity.AppEntity;
import net.mingsoft.basic.entity.ManagerEntity;
import net.mingsoft.basic.util.BasicUtil;
import net.mingsoft.basic.util.StringUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import springfox.documentation.annotations.ApiIgnore;

@Api(tags={"\u540e\u7aef-\u57fa\u7840\u63a5\u53e3"})
@Controller
@RequestMapping(value={"/${ms.manager.path}/basic/manager"})
public class ManagerAction
extends BaseAction {
    @Autowired
    private IManagerBiz managerBiz;

    @ApiIgnore
    @GetMapping(value={"/index"})
    @RequiresPermissions(value={"manager:view"})
    public String index(HttpServletResponse response, HttpServletRequest request) {
        return "/basic/manager/index";
    }

    @ApiOperation(value="\u67e5\u8be2\u7ba1\u7406\u5458\u5217\u8868")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"manager:view"})
    @ResponseBody
    public ResultData list(@ModelAttribute @ApiIgnore ManagerEntity manager, HttpServletResponse response, HttpServletRequest request, @ApiIgnore ModelMap model) {
        List managerList;
        BasicUtil.startPage();
        AppEntity websiteApp = BasicUtil.getWebsiteApp();
        if (websiteApp != null) {
            int appId = websiteApp.getAppId();
            QueryWrapper wrapper = (QueryWrapper)new QueryWrapper().eq((Object)"APP_ID", (Object)appId);
            managerList = this.managerBiz.list((Wrapper)wrapper);
        } else {
            managerList = this.managerBiz.list();
        }
        List<ManagerEntity> allManager = this.managerBiz.queryAllManager(managerList);
        return ResultData.build().success((Object)new EUListBean(allManager, (int)BasicUtil.endPage(allManager).getTotal()));
    }

    @ApiOperation(value="\u67e5\u8be2\u7ba1\u7406\u5458\u5217\u8868,\u53bb\u6389\u5f53\u524d\u7ba1\u7406\u5458id\uff0c\u786e\u4fdd\u4e0d\u80fd\u5220\u9664\u548c\u4fee\u6539\u81ea\u5df1")
    @GetMapping(value={"/query"})
    @RequiresPermissions(value={"manager:view"})
    @ResponseBody
    public ResultData query(HttpServletResponse response, HttpServletRequest request, @ApiIgnore ModelMap model) {
        List managerList;
        ManagerEntity manager = BasicUtil.getManager();
        BasicUtil.startPage();
        AppEntity websiteApp = BasicUtil.getWebsiteApp();
        if (websiteApp != null) {
            int appId = websiteApp.getAppId();
            QueryWrapper wrapper = (QueryWrapper)new QueryWrapper().eq((Object)"APP_ID", (Object)appId);
            managerList = this.managerBiz.list((Wrapper)wrapper);
        } else {
            managerList = this.managerBiz.list();
        }
        List<ManagerEntity> allManager = this.managerBiz.queryAllManager(managerList);
        for (ManagerEntity _manager : allManager) {
            assert (manager != null);
            if (!_manager.getId().equals(manager.getId())) continue;
            _manager.setId("0");
        }
        return ResultData.build().success((Object)new EUListBean(allManager, (int)BasicUtil.endPage(allManager).getTotal()));
    }

    @ApiOperation(value="\u83b7\u53d6\u7ba1\u7406\u5458\u63a5\u53e3")
    @GetMapping(value={"/get"})
    @RequiresPermissions(value={"manager:view"})
    @ResponseBody
    public ResultData get(@ModelAttribute @ApiIgnore ManagerEntity manager, HttpServletResponse response, HttpServletRequest request, @ApiIgnore ModelMap model) {
        ManagerEntity managerEntity;
        if (StringUtils.isNotEmpty((CharSequence)manager.getId())) {
            managerEntity = (ManagerEntity)((Object)this.managerBiz.getById((Serializable)((Object)manager.getId())));
        } else {
            ManagerEntity managerSession = BasicUtil.getManager();
            if (managerSession == null) {
                return ResultData.build().error("\u7ba1\u7406\u5458\u5df2\u5931\u6548!");
            }
            managerEntity = (ManagerEntity)((Object)this.managerBiz.getById((Serializable)((Object)managerSession.getId())));
        }
        if (managerEntity != null) {
            managerEntity.setManagerPassword("");
        }
        return ResultData.build().success((Object)managerEntity);
    }

    @ApiOperation(value="\u83b7\u53d6\u5f53\u524d\u7ba1\u7406\u5458\u4fe1\u606f\u63a5\u53e3")
    @GetMapping(value={"/info"})
    @ResponseBody
    public ResultData info(HttpServletResponse response, HttpServletRequest request) {
        ManagerEntity manager = BasicUtil.getManager();
        if (manager == null) {
            return ResultData.build().error("\u7ba1\u7406\u5458\u5df2\u5931\u6548!");
        }
        ManagerEntity managerEntity = (ManagerEntity)((Object)this.managerBiz.getById((Serializable)((Object)manager.getId())));
        if (managerEntity != null) {
            managerEntity.setManagerPassword("");
        }
        return ResultData.build().success((Object)managerEntity);
    }

    @ApiOperation(value="\u4fdd\u5b58\u7ba1\u7406\u5458\u5b9e\u4f53")
    @ApiImplicitParams(value={@ApiImplicitParam(name="managerName", value="\u5e10\u53f7", required=true, paramType="query"), @ApiImplicitParam(name="managerNickName", value="\u6635\u79f0", required=true, paramType="query"), @ApiImplicitParam(name="managerPassword", value="\u5bc6\u7801", required=true, paramType="query"), @ApiImplicitParam(name="roleId", value="\u89d2\u8272ID", required=false, paramType="query"), @ApiImplicitParam(name="peopleId", value="\u7528\u6237ID", required=false, paramType="query")})
    @LogAnn(title="\u4fdd\u5b58\u7ba1\u7406\u5458\u5b9e\u4f53", businessType=BusinessTypeEnum.INSERT)
    @PostMapping(value={"/save"})
    @ResponseBody
    @RequiresPermissions(value={"manager:save"})
    public ResultData save(@ModelAttribute @ApiIgnore ManagerEntity manager, HttpServletResponse response, HttpServletRequest request) {
        if (this.managerBiz.getManagerByManagerName(manager.getManagerName()) != null) {
            return ResultData.build().error(this.getResString("err.exist", new String[]{this.getResString("manager.name")}));
        }
        if (StringUtils.isBlank((CharSequence)manager.getManagerName())) {
            return ResultData.build().error(this.getResString("err.empty", new String[]{this.getResString("manager.name")}));
        }
        if (!StringUtil.checkLength(manager.getManagerName() + "", 1, 15)) {
            return ResultData.build().error(this.getResString("err.length", new String[]{this.getResString("manager.name"), "1", "15"}));
        }
        if (StringUtils.isBlank((CharSequence)manager.getManagerNickName())) {
            return ResultData.build().error(this.getResString("err.empty", new String[]{this.getResString("manager.nickname")}));
        }
        if (!StringUtil.checkLength(manager.getManagerNickName() + "", 1, 15)) {
            return ResultData.build().error(this.getResString("err.length", new String[]{this.getResString("manager.nickname"), "1", "15"}));
        }
        if (StringUtils.isBlank((CharSequence)manager.getManagerPassword())) {
            return ResultData.build().error(this.getResString("err.empty", new String[]{this.getResString("manager.password")}));
        }
        if (!StringUtil.checkLength(manager.getManagerPassword() + "", 1, 45)) {
            return ResultData.build().error(this.getResString("err.length", new String[]{this.getResString("manager.password"), "1", "45"}));
        }
        manager.setManagerPassword(SecureUtil.md5((String)manager.getManagerPassword()));
        this.managerBiz.save((Object)manager);
        this.managerBiz.updateCache();
        return ResultData.build().success((Object)manager);
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u7ba1\u7406\u5458")
    @LogAnn(title="\u6279\u91cf\u5220\u9664\u7ba1\u7406\u5458", businessType=BusinessTypeEnum.DELETE)
    @PostMapping(value={"/delete"})
    @ResponseBody
    @RequiresPermissions(value={"manager:del"})
    public ResultData delete(@RequestBody List<ManagerEntity> managers, HttpServletResponse response, HttpServletRequest request) {
        int[] ids = new int[managers.size()];
        for (int i = 0; i < managers.size(); ++i) {
            ids[i] = Integer.parseInt(managers.get(i).getId());
        }
        this.managerBiz.delete(ids);
        this.managerBiz.updateCache();
        return ResultData.build().success();
    }

    @ApiOperation(value="\u66f4\u65b0\u7ba1\u7406\u5458\u4fe1\u606f\u7ba1\u7406\u5458")
    @ApiImplicitParams(value={@ApiImplicitParam(name="managerName", value="\u5e10\u53f7", required=true, paramType="query"), @ApiImplicitParam(name="managerNickName", value="\u6635\u79f0", required=true, paramType="query"), @ApiImplicitParam(name="managerPassword", value="\u5bc6\u7801", required=true, paramType="query"), @ApiImplicitParam(name="roleId", value="\u89d2\u8272ID", required=false, paramType="query"), @ApiImplicitParam(name="peopleId", value="\u7528\u6237ID", required=false, paramType="query")})
    @LogAnn(title="\u66f4\u65b0\u7ba1\u7406\u5458\u4fe1\u606f\u7ba1\u7406\u5458", businessType=BusinessTypeEnum.UPDATE)
    @PostMapping(value={"/update"})
    @ResponseBody
    @RequiresPermissions(value={"manager:update"})
    public ResultData update(@ModelAttribute @ApiIgnore ManagerEntity manager) {
        this.managerBiz.updateCache();
        ManagerEntity _manager = this.managerBiz.getManagerByManagerName(manager.getManagerName());
        if (_manager != null && !_manager.getId().equals(manager.getId())) {
            return ResultData.build().error(this.getResString("err.exist", new String[]{this.getResString("manager.name")}));
        }
        if (StringUtils.isBlank((CharSequence)manager.getManagerName())) {
            return ResultData.build().error(this.getResString("err.empty", new String[]{this.getResString("manager.name")}));
        }
        if (!StringUtil.checkLength(manager.getManagerName() + "", 1, 15)) {
            return ResultData.build().error(this.getResString("err.length", new String[]{this.getResString("manager.name"), "1", "15"}));
        }
        if (StringUtils.isBlank((CharSequence)manager.getManagerNickName())) {
            return ResultData.build().error(this.getResString("err.empty", new String[]{this.getResString("manager.nickname")}));
        }
        if (!StringUtil.checkLength(manager.getManagerNickName() + "", 1, 15)) {
            return ResultData.build().error(this.getResString("err.length", new String[]{this.getResString("manager.nickname"), "1", "15"}));
        }
        if (!StringUtils.isBlank((CharSequence)manager.getManagerPassword())) {
            if (!StringUtil.checkLength(manager.getManagerPassword() + "", 1, 45)) {
                return ResultData.build().error(this.getResString("err.length", new String[]{this.getResString("manager.password"), "1", "45"}));
            }
            manager.setManagerPassword(SecureUtil.md5((String)manager.getManagerPassword()));
        } else {
            manager.setManagerPassword(null);
        }
        this.managerBiz.updateById((Object)manager);
        return ResultData.build().success((Object)manager);
    }
}

