/*
 * Decompiled with CFR 0.152.
 */
package net.moznion.db.transaction.manager;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.moznion.db.transaction.manager.AlreadyRollbackedException;
import net.moznion.db.transaction.manager.StackTracer;
import net.moznion.db.transaction.manager.TransactionTraceInfo;

public class TransactionManager {
    private List<TransactionTraceInfo> activeTransactions;
    private int rollbackedInNestedTransaction = 0;
    private Boolean originalAutoCommitStatus = null;
    private final Connection connection;
    private final List<Runnable> endHooks;

    public TransactionManager(Connection connection) {
        if (connection == null) {
            throw new IllegalArgumentException("connection must not be null");
        }
        this.connection = connection;
        this.activeTransactions = new ArrayList<TransactionTraceInfo>();
        this.endHooks = new ArrayList<Runnable>();
    }

    public void txnBegin() throws SQLException {
        this.originalAutoCommitStatus = this.connection.getAutoCommit();
        this.txnBegin(this.originalAutoCommitStatus);
    }

    public void txnBegin(boolean originalAutoCommitStatus) throws SQLException {
        if (this.activeTransactions.size() == 0) {
            this.originalAutoCommitStatus = originalAutoCommitStatus;
            this.connection.setAutoCommit(false);
        }
        Optional<StackTraceElement> maybeStackTraceElement = StackTracer.getStackTraceElement(6);
        Thread currentThread = Thread.currentThread();
        TransactionTraceInfo.Builder ttiBuilder = TransactionTraceInfo.builder();
        ttiBuilder.threadId(currentThread.getId());
        if (maybeStackTraceElement.isPresent()) {
            StackTraceElement stackTraceElement = maybeStackTraceElement.get();
            ttiBuilder.className(stackTraceElement.getClassName()).fileName(stackTraceElement.getFileName()).methodName(stackTraceElement.getMethodName()).lineNumber(stackTraceElement.getLineNumber());
        }
        this.activeTransactions.add(ttiBuilder.build());
    }

    public void txnCommit() throws SQLException {
        if (this.activeTransactions.size() <= 0) {
            return;
        }
        if (this.rollbackedInNestedTransaction > 0) {
            throw new AlreadyRollbackedException("Tried to commit but it had already rollbacked in nested transaction");
        }
        this.activeTransactions.remove(this.activeTransactions.size() - 1);
        if (this.activeTransactions.size() == 0) {
            this.connection.commit();
            this.txnEnd();
            this.endHooks.forEach(Runnable::run);
        }
    }

    public void txnRollback() throws SQLException {
        if (this.activeTransactions.size() <= 0) {
            return;
        }
        this.activeTransactions.remove(this.activeTransactions.size() - 1);
        if (this.activeTransactions.size() > 0) {
            ++this.rollbackedInNestedTransaction;
        } else {
            this.connection.rollback();
            this.txnEnd();
        }
    }

    public void txnAddEndHook(Runnable r) {
        this.endHooks.add(r);
    }

    public List<TransactionTraceInfo> getActiveTransactions() {
        return this.activeTransactions;
    }

    public Optional<TransactionTraceInfo> getCurrentTransaction() {
        if (this.activeTransactions.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(this.activeTransactions.get(this.activeTransactions.size() - 1));
    }

    private void txnEnd() throws SQLException {
        this.connection.setAutoCommit(this.originalAutoCommitStatus);
        this.activeTransactions = new ArrayList<TransactionTraceInfo>();
        this.rollbackedInNestedTransaction = 0;
    }

    public Boolean getOriginalAutoCommitStatus() {
        return this.originalAutoCommitStatus;
    }

    public Connection getConnection() {
        return this.connection;
    }
}

