/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.core.webdriver.driverproviders;

import java.io.IOException;
import net.serenitybdd.core.webdriver.driverproviders.InstantiateDriver;
import net.serenitybdd.core.webdriver.driverproviders.ServicePoolError;
import net.serenitybdd.core.webdriver.servicepools.DriverServicePool;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.util.EnvironmentVariables;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProvideNewDriver {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProvideNewDriver.class);

    public static WebDriver withConfiguration(EnvironmentVariables environmentVariables, Capabilities capabilities, DriverServicePool pool, InstantiateDriver servicePoolStrategy, InstantiateDriver defaultStrategy) {
        if (ProvideNewDriver.useServicePoolIfConfigueredIn(environmentVariables)) {
            LOGGER.debug("Instantiating driver using a service pool");
            LOGGER.debug("Driver capabilities: {}", (Object)capabilities);
            try {
                pool.ensureServiceIsRunning();
                return servicePoolStrategy.newDriver(pool, capabilities);
            }
            catch (IOException | ServicePoolError couldNotStartService) {
                LOGGER.warn("Failed to start the driver service, using a native driver instead", (Object)couldNotStartService.getMessage());
                return defaultStrategy.newDriver(pool, capabilities);
            }
        }
        LOGGER.debug("Instantiating driver");
        LOGGER.debug("Driver capabilities: {}", (Object)capabilities);
        return defaultStrategy.newDriver(pool, capabilities);
    }

    private static boolean useServicePoolIfConfigueredIn(EnvironmentVariables environmentVariables) {
        return ThucydidesSystemProperty.WEBDRIVER_USE_DRIVER_SERVICE_POOL.booleanFrom(environmentVariables, Boolean.valueOf(false));
    }
}

