/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.steps.construction;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Set;
import java.util.function.Predicate;
import net.serenitybdd.core.collect.NewSet;
import net.thucydides.core.annotations.Fields;
import net.thucydides.core.pages.Pages;

public class StepLibraryType {
    private final Class<?> stepLibraryClass;

    public StepLibraryType(Class<?> stepLibraryClass) {
        this.stepLibraryClass = stepLibraryClass;
    }

    public static StepLibraryType ofClass(Class<?> stepLibraryClass) {
        return new StepLibraryType(stepLibraryClass);
    }

    public boolean hasAPagesConstructor() {
        Set constructors = NewSet.copyOf((Object[])this.stepLibraryClass.getDeclaredConstructors());
        return constructors.stream().anyMatch(this.withASinglePagesParameter());
    }

    public boolean hasAConstructorWithParameters() {
        Set constructors = NewSet.copyOf((Object[])this.stepLibraryClass.getDeclaredConstructors());
        return constructors.stream().anyMatch(this.withAnyParameters());
    }

    public boolean hasAPagesField() {
        Set fields = NewSet.copyOf((Collection)Fields.of(this.stepLibraryClass).allFields());
        return fields.stream().anyMatch(StepLibraryType.ofTypePages());
    }

    private Predicate<Constructor<?>> withAnyParameters() {
        return constructor -> constructor.getParameterTypes().length > 0;
    }

    private Predicate<Constructor<?>> withASinglePagesParameter() {
        return constructor -> constructor.getParameterTypes().length == 1 && constructor.getParameterTypes()[0] == Pages.class;
    }

    public static Predicate<Field> ofTypePages() {
        return field -> field.getType() == Pages.class;
    }
}

