/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.core.pages;

import com.google.common.base.Predicate;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Clock;
import java.time.Duration;
import java.time.temporal.TemporalUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Stream;
import net.serenitybdd.annotations.WhenPageOpens;
import net.serenitybdd.core.Serenity;
import net.serenitybdd.core.SystemTimeouts;
import net.serenitybdd.core.di.SerenityInfrastructure;
import net.serenitybdd.core.pages.DefaultTimeouts;
import net.serenitybdd.core.pages.FindAllWithRetry;
import net.serenitybdd.core.pages.JavascriptCompatibleVersion;
import net.serenitybdd.core.pages.ListOfWebElementFacades;
import net.serenitybdd.core.pages.MatchingPageExpressions;
import net.serenitybdd.core.pages.NoSuchPageException;
import net.serenitybdd.core.pages.NormalizeUrlForm;
import net.serenitybdd.core.pages.PageUrls;
import net.serenitybdd.core.pages.ParameterisedLocator;
import net.serenitybdd.core.pages.RenderedPageObjectView;
import net.serenitybdd.core.pages.ResolvableElement;
import net.serenitybdd.core.pages.SerenityActions;
import net.serenitybdd.core.pages.UnableToInvokeWhenPageOpensMethods;
import net.serenitybdd.core.pages.WaitForAngular;
import net.serenitybdd.core.pages.WebElementFacade;
import net.serenitybdd.core.pages.WebElementFacadeImpl;
import net.serenitybdd.core.pages.WebElementFacadeWait;
import net.serenitybdd.core.pages.WithByLocator;
import net.serenitybdd.core.pages.WithLocator;
import net.serenitybdd.core.selectors.Selectors;
import net.serenitybdd.model.collect.NewList;
import net.serenitybdd.model.environment.EnvironmentSpecificConfiguration;
import net.serenitybdd.model.time.SystemClock;
import net.thucydides.core.fluent.ThucydidesFluentAdapter;
import net.thucydides.core.pages.Pages;
import net.thucydides.core.pages.WrongPageError;
import net.thucydides.core.pages.components.Dropdown;
import net.thucydides.core.pages.components.FileToUpload;
import net.thucydides.core.pages.jquery.JQueryEnabledPage;
import net.thucydides.core.scheduling.FluentWaitWithRefresh;
import net.thucydides.core.scheduling.SerenityFluentWait;
import net.thucydides.core.scheduling.ThucydidesFluentWait;
import net.thucydides.core.steps.PageObjectStepDelayer;
import net.thucydides.core.steps.StepEventBus;
import net.thucydides.core.steps.WaitForBuilder;
import net.thucydides.core.webdriver.ConfigurableTimeouts;
import net.thucydides.core.webdriver.DefaultPageObjectInitialiser;
import net.thucydides.core.webdriver.SupportedWebDriver;
import net.thucydides.core.webdriver.TemporalUnitConverter;
import net.thucydides.core.webdriver.ThucydidesWebDriverSupport;
import net.thucydides.core.webdriver.WebDriverFacade;
import net.thucydides.core.webdriver.javascript.JavascriptExecutorFacade;
import net.thucydides.core.webdriver.javascript.JavascriptSupport;
import net.thucydides.core.webelements.Checkbox;
import net.thucydides.core.webelements.RadioButtonGroup;
import net.thucydides.model.ThucydidesSystemProperty;
import net.thucydides.model.environment.SystemEnvironmentVariables;
import net.thucydides.model.reflection.MethodFinder;
import net.thucydides.model.util.EnvironmentVariables;
import net.thucydides.model.util.Inflector;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.Alert;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.NoSuchFrameException;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.devtools.DevTools;
import org.openqa.selenium.devtools.HasDevTools;
import org.openqa.selenium.interactions.Actions;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.Sleeper;
import org.openqa.selenium.support.ui.WebDriverWait;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PageObject {
    private static final int WAIT_FOR_ELEMENT_PAUSE_LENGTH = 250;
    private static final Logger LOGGER = LoggerFactory.getLogger(PageObject.class);
    private WebDriver driver;
    private Pages pages;
    private MatchingPageExpressions matchingPageExpressions;
    private RenderedPageObjectView renderedView;
    private PageUrls pageUrls;
    private final SystemClock clock;
    private Duration waitForTimeout;
    private Duration waitForElementTimeout;
    private final Sleeper sleeper;
    private final Clock webdriverClock;
    private JavascriptExecutorFacade javascriptExecutorFacade;
    private EnvironmentVariables environmentVariables;
    private boolean enableJQuery = false;
    Inflector inflection = Inflector.getInstance();

    public static PageObject fromSearchContext(SearchContext searchContext) {
        return null;
    }

    public void setImplicitTimeout(int duration, TemporalUnit unit) {
        this.waitForElementTimeout = Duration.of(duration, unit);
        this.setDriverImplicitTimeout(this.waitForElementTimeout);
    }

    private void setDriverImplicitTimeout(Duration implicitTimeout) {
        if (this.driver instanceof ConfigurableTimeouts) {
            ((ConfigurableTimeouts)this.driver).setImplicitTimeout(implicitTimeout);
        } else {
            this.driver.manage().timeouts().implicitlyWait(Duration.ofMillis(this.waitForElementTimeout.toMillis()));
        }
    }

    public void resetImplicitTimeout() {
        if (this.driver instanceof ConfigurableTimeouts) {
            this.waitForElementTimeout = ((ConfigurableTimeouts)this.driver).resetTimeouts();
        } else {
            this.waitForElementTimeout = this.getDefaultImplicitTimeout();
            this.driver.manage().timeouts().implicitlyWait(Duration.ofMillis(this.waitForElementTimeout.toMillis()));
        }
    }

    private Duration getDefaultImplicitTimeout() {
        Long configuredTimeout = new SystemTimeouts(this.environmentVariables).getImplicitTimeout();
        return Duration.ofMillis(configuredTimeout);
    }

    protected PageObject() {
        this.webdriverClock = Clock.systemDefaultZone();
        this.clock = SerenityInfrastructure.getClock();
        this.environmentVariables = SystemEnvironmentVariables.currentEnvironmentVariables();
        this.sleeper = Sleeper.SYSTEM_SLEEPER;
    }

    protected PageObject(WebDriver driver, Predicate<? super PageObject> callback) {
        this();
        this.driver = driver;
        callback.apply((Object)this);
    }

    public PageObject(WebDriver webdriver, int ajaxTimeout) {
        this();
        this.setDriver(webdriver, ajaxTimeout);
    }

    public PageObject(WebDriver driver) {
        this();
        ThucydidesWebDriverSupport.useDriver(driver);
        this.setDriver(driver);
    }

    public PageObject(WebDriver driver, EnvironmentVariables environmentVariables) {
        this();
        this.environmentVariables = environmentVariables;
        this.setDriver(driver);
    }

    protected void setDriver(WebDriver webdriver, long timeout) {
        this.driver = webdriver;
        if (SerenityInfrastructure.getConfiguration().getBaseUrl() != null) {
            this.setDefaultBaseUrl(SerenityInfrastructure.getConfiguration().getBaseUrl());
        }
        new DefaultPageObjectInitialiser(this.getDriver(), timeout).apply(this);
    }

    public <T extends PageObject> T setDriver(WebDriver webdriver) {
        this.setDriver(webdriver, this.getImplicitWaitTimeout().toMillis());
        return (T)this;
    }

    public <T extends PageObject> T withDriver(WebDriver driver) {
        return this.setDriver(driver);
    }

    public Duration getWaitForTimeout() {
        if (this.waitForTimeout == null) {
            int configuredWaitForTimeoutInMilliseconds = this.fluentWaitTimeout();
            this.waitForTimeout = Duration.ofMillis(configuredWaitForTimeoutInMilliseconds);
        }
        return this.waitForTimeout;
    }

    private int fluentWaitTimeout() {
        return ThucydidesSystemProperty.WEBDRIVER_WAIT_FOR_TIMEOUT.integerFrom(this.environmentVariables, ThucydidesSystemProperty.WEBDRIVER_TIMEOUTS_FLUENTWAIT.integerFrom(this.environmentVariables, (int)DefaultTimeouts.DEFAULT_WAIT_FOR_TIMEOUT.toMillis()));
    }

    @Deprecated
    public Duration getWaitForElementTimeout() {
        return this.getImplicitWaitTimeout();
    }

    public Duration getImplicitWaitTimeout() {
        if (this.waitForElementTimeout == null) {
            long configuredWaitForTimeoutInMilliseconds = new SystemTimeouts(this.environmentVariables).getImplicitTimeout();
            this.waitForElementTimeout = Duration.ofMillis(configuredWaitForTimeoutInMilliseconds);
        }
        return this.waitForElementTimeout;
    }

    public void setPages(Pages pages) {
        this.pages = pages;
    }

    @Deprecated
    public <T extends PageObject> T switchToPage(Class<T> pageObjectClass) {
        if (this.pages.getDriver() == null) {
            this.pages.setDriver(this.driver);
        }
        return this.pages.getPage(pageObjectClass);
    }

    public FileToUpload upload(String filename) {
        return new FileToUpload(this.getDriver(), filename).useRemoteDriver(this.isDefinedRemoteUrl());
    }

    public FileToUpload uploadData(String data) throws IOException {
        Path datafile = Files.createTempFile("upload", "data", new FileAttribute[0]);
        Files.write(datafile, data.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        return new FileToUpload(this.getDriver(), datafile.toAbsolutePath().toString()).useRemoteDriver(this.isDefinedRemoteUrl());
    }

    public FileToUpload uploadData(byte[] data) throws IOException {
        Path datafile = Files.createTempFile("upload", "data", new FileAttribute[0]);
        Files.write(datafile, data, new OpenOption[0]);
        return new FileToUpload(this.getDriver(), datafile.toAbsolutePath().toString()).useRemoteDriver(this.isDefinedRemoteUrl());
    }

    private boolean isDefinedRemoteUrl() {
        boolean isRemoteUrl = ThucydidesSystemProperty.WEBDRIVER_REMOTE_URL.isDefinedIn(this.environmentVariables);
        boolean isBrowserStack = ThucydidesSystemProperty.BROWSERSTACK_URL.isDefinedIn(this.environmentVariables);
        return isRemoteUrl || isBrowserStack;
    }

    private PageUrls getPageUrls() {
        if (this.pageUrls == null) {
            this.pageUrls = new PageUrls((Object)this, this.environmentVariables);
        }
        return this.pageUrls;
    }

    public void setPageUrls(PageUrls pageUrls) {
        this.pageUrls = pageUrls;
    }

    public void setWaitForTimeout(long waitForTimeoutInMilliseconds) {
        this.waitForTimeout = Duration.ofMillis(waitForTimeoutInMilliseconds);
        this.getRenderedView().setWaitForTimeout(this.waitForTimeout);
    }

    public void setWaitForElementTimeout(long waitForTimeoutInMilliseconds) {
        this.waitForElementTimeout = Duration.ofMillis(waitForTimeoutInMilliseconds);
    }

    protected RenderedPageObjectView getRenderedView() {
        if (this.renderedView == null) {
            this.renderedView = new RenderedPageObjectView(this.getDriver(), this, this.getWaitForTimeout(), true);
        }
        return this.renderedView;
    }

    protected SystemClock getClock() {
        return this.clock;
    }

    private MatchingPageExpressions getMatchingPageExpressions() {
        if (this.matchingPageExpressions == null) {
            this.matchingPageExpressions = new MatchingPageExpressions(this);
        }
        return this.matchingPageExpressions;
    }

    public WebDriver getDriver() {
        if (this.driver == null) {
            this.driver = Serenity.getDriver();
        }
        return this.driver;
    }

    public boolean hasDevTools() {
        if (this.getDriver() instanceof WebDriverFacade) {
            return ((WebDriverFacade)this.getDriver()).getProxiedDriver() instanceof HasDevTools;
        }
        return this.getDriver() instanceof HasDevTools;
    }

    public Optional<DevTools> maybeGetDevTools() {
        return Optional.ofNullable(this.getDevTools());
    }

    public DevTools getDevTools() {
        if (!this.hasDevTools()) {
            return null;
        }
        if (this.getDriver() instanceof WebDriverFacade) {
            return ((HasDevTools)((WebDriverFacade)this.getDriver()).getProxiedDriver()).getDevTools();
        }
        return ((HasDevTools)this.getDriver()).getDevTools();
    }

    public String getTitle() {
        return this.driver.getTitle();
    }

    public boolean matchesAnyUrl() {
        return this.thereAreNoPatternsDefined();
    }

    public final boolean compatibleWithUrl(String currentUrl) {
        return this.thereAreNoPatternsDefined() || this.matchUrlAgainstEachPattern(currentUrl);
    }

    private boolean matchUrlAgainstEachPattern(String currentUrl) {
        return this.getMatchingPageExpressions().matchUrlAgainstEachPattern(currentUrl);
    }

    private boolean thereAreNoPatternsDefined() {
        return this.getMatchingPageExpressions().isEmpty();
    }

    public PageObject waitForRenderedElements(By byElementCriteria) {
        this.getRenderedView().waitFor(byElementCriteria);
        return this;
    }

    @Deprecated
    public RenderedPageObjectView withTimeoutOf(int timeout, TimeUnit units) {
        return this.withTimeoutOf(Duration.of(timeout, TemporalUnitConverter.fromTimeUnit(units)));
    }

    public RenderedPageObjectView withTimeoutOf(int timeout, TemporalUnit units) {
        return this.withTimeoutOf(Duration.of(timeout, units));
    }

    public RenderedPageObjectView withTimeoutOf(Duration timeout) {
        return new RenderedPageObjectView(this.getDriver(), this, timeout, false);
    }

    public RenderedPageObjectView waitingForNoLongerThan(int timeout, TimeUnit units) {
        return this.withTimeoutOf(Duration.of(timeout, TemporalUnitConverter.fromTimeUnit(units)));
    }

    public WaitingBuilder waitingForNoLongerThan(int timeout) {
        return new WaitingBuilder(timeout, this);
    }

    public PageObject waitFor(String xpathOrCssSelector, Object firstArgument, Object ... arguments) {
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(firstArgument);
        args.addAll(Arrays.asList(arguments));
        return this.waitForRenderedElements(Selectors.xpathOrCssSelector(ParameterisedLocator.withArguments(xpathOrCssSelector, args.toArray())));
    }

    public PageObject waitFor(String xpathOrCssSelector) {
        return this.waitForRenderedElements(Selectors.xpathOrCssSelector(xpathOrCssSelector));
    }

    public <T> T waitFor(ExpectedCondition<T> expectedCondition) {
        return this.getRenderedView().waitFor(expectedCondition);
    }

    public <T> T waitFor(String message, ExpectedCondition<T> expectedCondition) {
        return this.getRenderedView().waitFor(message, expectedCondition);
    }

    public PageObject waitForRenderedElementsToBePresent(By byElementCriteria) {
        this.getRenderedView().waitForPresenceOf(byElementCriteria);
        return this;
    }

    public PageObject waitForPresenceOf(String xpathOrCssSelector, Object ... arguments) {
        return this.waitForRenderedElementsToBePresent(Selectors.xpathOrCssSelector(ParameterisedLocator.withArguments(xpathOrCssSelector, arguments)));
    }

    public PageObject waitForRenderedElementsToDisappear(By byElementCriteria) {
        this.getRenderedView().waitForElementsToDisappear(byElementCriteria);
        return this;
    }

    public PageObject waitForAbsenceOf(String xpathOrCssSelector, Object ... arguments) {
        return this.waitForRenderedElementsToDisappear(Selectors.xpathOrCssSelector(ParameterisedLocator.withArguments(xpathOrCssSelector, arguments)));
    }

    public PageObject waitForAbsenceOf(By byLocator) {
        return this.waitForRenderedElementsToDisappear(byLocator);
    }

    public PageObject waitForTextToAppear(String expectedText) {
        this.getRenderedView().waitForText(expectedText);
        return this;
    }

    public PageObject waitForTitleToAppear(String expectedTitle) {
        this.waitOnPage().until((Function)ExpectedConditions.titleIs((String)expectedTitle));
        return this;
    }

    public WebDriverWait waitOnPage() {
        return new WebDriverWait(this.getDriver(), this.getWaitForTimeout());
    }

    public PageObject waitForTitleToDisappear(String expectedTitle) {
        this.getRenderedView().waitForTitleToDisappear(expectedTitle);
        return this;
    }

    public PageObject waitForTextToAppear(WebElement element, String expectedText) {
        this.getRenderedView().waitForText(element, expectedText);
        return this;
    }

    private boolean driverIsDisabled() {
        return StepEventBus.getParallelEventBus().webdriverCallsAreSuspended();
    }

    public PageObject waitForTextToDisappear(WebElement element, String expectedText) {
        if (!this.driverIsDisabled()) {
            this.waitForCondition().until((Function)this.elementDoesNotContain(element, expectedText));
        }
        return this;
    }

    private ExpectedCondition<Boolean> elementDoesNotContain(final WebElement element, final String expectedText) {
        return new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                return !element.getText().contains(expectedText);
            }
        };
    }

    public PageObject waitForTextToDisappear(String expectedText) {
        return this.waitForTextToDisappear(expectedText, this.getWaitForTimeout().toMillis());
    }

    public PageObject waitForTextToDisappear(String expectedText, long timeoutInMilliseconds) {
        this.getRenderedView().waitForTextToDisappear(expectedText, timeoutInMilliseconds);
        return this;
    }

    public PageObject waitForTextToAppear(String expectedText, long timeout) {
        this.getRenderedView().waitForTextToAppear(expectedText, timeout);
        return this;
    }

    public PageObject waitForAnyTextToAppear(String ... expectedText) {
        this.getRenderedView().waitForAnyTextToAppear(expectedText);
        return this;
    }

    public PageObject waitForAnyTextToAppear(WebElement element, String ... expectedText) {
        this.getRenderedView().waitForAnyTextToAppear(element, expectedText);
        return this;
    }

    public PageObject waitForAllTextToAppear(String ... expectedTexts) {
        this.getRenderedView().waitForAllTextToAppear(expectedTexts);
        return this;
    }

    public PageObject waitForAnyRenderedElementOf(By ... expectedElements) {
        this.getRenderedView().waitForAnyRenderedElementOf(expectedElements);
        return this;
    }

    protected void waitABit(long timeInMilliseconds) {
        this.getClock().pauseFor(timeInMilliseconds);
    }

    public WaitForBuilder<? extends PageObject> waitFor(int duration) {
        return new PageObjectStepDelayer<PageObject>(this.clock, this).waitFor(duration);
    }

    public List<WebElement> thenReturnElementList(By byListCriteria) {
        return this.driver.findElements(byListCriteria);
    }

    public void shouldContainText(String textValue) {
        if (!this.containsText(textValue)) {
            String errorMessage = String.format("The text '%s' was not found in the page", textValue);
            throw new NoSuchElementException(errorMessage);
        }
    }

    public void shouldContainAllText(String ... textValues) {
        if (!this.containsAllText(textValues)) {
            String errorMessage = String.format("One of the text elements in '%s' was not found in the page", textValues);
            throw new NoSuchElementException(errorMessage);
        }
    }

    @Deprecated
    public boolean containsTextInElement(WebElement webElement, String textValue) {
        return this.element(webElement).containsText(textValue);
    }

    @Deprecated
    public void shouldContainTextInElement(WebElement webElement, String textValue) {
        this.element(webElement).shouldContainText(textValue);
    }

    @Deprecated
    public void shouldNotContainTextInElement(WebElement webElement, String textValue) {
        this.element(webElement).shouldNotContainText(textValue);
    }

    public void typeInto(WebElement field, String value) {
        this.element(field).type(value);
    }

    public FieldEntry enter(CharSequence ... keysToSend) {
        return new FieldEntry(keysToSend);
    }

    public void selectFromDropdown(WebElement dropdown, String visibleLabel) {
        Dropdown.forWebElement(dropdown).select(visibleLabel);
        this.notifyScreenChange();
    }

    public void selectMultipleItemsFromDropdown(WebElement dropdown, String ... selectedLabels) {
        Dropdown.forWebElement(dropdown).selectMultipleItems(selectedLabels);
        this.notifyScreenChange();
    }

    public Set<String> getSelectedOptionLabelsFrom(WebElement dropdown) {
        return Dropdown.forWebElement(dropdown).getSelectedOptionLabels();
    }

    public Set<String> getSelectedOptionValuesFrom(WebElement dropdown) {
        return Dropdown.forWebElement(dropdown).getSelectedOptionValues();
    }

    public String getSelectedValueFrom(WebElement dropdown) {
        return Dropdown.forWebElement(dropdown).getSelectedValue();
    }

    public String getSelectedLabelFrom(WebElement dropdown) {
        return Dropdown.forWebElement(dropdown).getSelectedLabel();
    }

    public void setCheckbox(WebElement field, boolean value) {
        Checkbox checkbox = new Checkbox(field);
        checkbox.setChecked(value);
        this.notifyScreenChange();
    }

    public boolean containsText(String textValue) {
        return this.getRenderedView().containsText(textValue);
    }

    public boolean containsAllText(String ... textValues) {
        for (String textValue : textValues) {
            if (this.getRenderedView().containsText(textValue)) continue;
            return false;
        }
        return true;
    }

    public void shouldBeVisible(WebElement field) {
        this.element(field).shouldBeVisible();
    }

    public void shouldBeVisible(By byCriteria) {
        this.waitOnPage().until((Function)ExpectedConditions.visibilityOfElementLocated((By)byCriteria));
    }

    public void shouldNotBeVisible(WebElement field) {
        try {
            this.element(field).shouldNotBeVisible();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void shouldNotBeVisible(By byCriteria) {
        List matchingElements = this.getDriver().findElements(byCriteria);
        if (!matchingElements.isEmpty()) {
            this.waitOnPage().until((Function)ExpectedConditions.invisibilityOfElementLocated((By)byCriteria));
        }
    }

    public long waitForTimeoutInMilliseconds() {
        return this.getWaitForTimeout().toMillis();
    }

    public long implicitTimoutMilliseconds() {
        return this.getImplicitWaitTimeout().toMillis();
    }

    public String updateUrlWithBaseUrlIfDefined(String startingUrl) {
        String baseUrl;
        if (this.getPageUrls().getDeclaredDefaultUrl().isPresent()) {
            startingUrl = this.getPageUrls().addDefaultUrlTo(startingUrl);
        }
        if (this.isDefined(baseUrl = this.getPageUrls().getSystemBaseUrl())) {
            if (this.isFullUrl(startingUrl)) {
                return this.replaceHost(startingUrl, baseUrl);
            }
            if (this.isRelative(startingUrl)) {
                return this.getPageUrls().addBaseUrlTo(startingUrl);
            }
        }
        return startingUrl;
    }

    protected boolean isRelative(String startingUrl) {
        return !this.isFullUrl(startingUrl);
    }

    private boolean isDefined(String url) {
        return url != null && !StringUtils.isEmpty((CharSequence)url);
    }

    private boolean isFullUrl(String startingUrl) {
        try {
            new URL(startingUrl);
            return true;
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    private String replaceHost(String starting, String base) {
        String updatedUrl = starting;
        try {
            URL startingUrl = new URL(starting);
            URL baseUrl = new URL(base);
            String startingHostComponent = this.hostComponentFrom(startingUrl.getProtocol(), startingUrl.getHost(), startingUrl.getPort());
            String baseHostComponent = this.hostComponentFrom(baseUrl.getProtocol(), baseUrl.getHost(), baseUrl.getPort());
            updatedUrl = starting.replaceFirst(startingHostComponent, baseHostComponent);
        }
        catch (MalformedURLException e) {
            LOGGER.error("Failed to analyse default page URL: Starting URL: {}, Base URL: {}", (Object)starting, (Object)base);
            LOGGER.error("URL analysis failed with exception:", (Throwable)e);
        }
        return updatedUrl;
    }

    private String hostComponentFrom(String protocol, String host, int port) {
        StringBuilder hostComponent = new StringBuilder(protocol);
        hostComponent.append("://");
        hostComponent.append(host);
        if (port > 0) {
            hostComponent.append(":");
            hostComponent.append(port);
        }
        return hostComponent.toString();
    }

    public final void open(String[] parameterValues) {
        this.open(OpenMode.CHECK_URL_PATTERNS, parameterValues);
    }

    public final void openUnchecked(String ... parameterValues) {
        this.open(OpenMode.IGNORE_URL_PATTERNS, parameterValues);
    }

    private void open(OpenMode openMode, String ... parameterValues) {
        String startingUrl = this.getPageUrls().getStartingUrl(parameterValues);
        LOGGER.debug("Opening page at url {}", (Object)startingUrl);
        this.openPageAtUrl(startingUrl);
        this.checkUrlPatterns(openMode);
        this.initializePage();
        LOGGER.debug("Page opened");
    }

    public final OpenWithParams open(String urlTemplateName) {
        return new OpenWithParams(this, urlTemplateName);
    }

    public final void open(String urlTemplateName, String[] parameterValues) {
        this.open(OpenMode.CHECK_URL_PATTERNS, urlTemplateName, parameterValues);
    }

    public final void openUnchecked(String urlTemplateName, String[] parameterValues) {
        this.open(OpenMode.IGNORE_URL_PATTERNS, urlTemplateName, parameterValues);
    }

    private void open(OpenMode openMode, String urlTemplateName, String[] parameterValues) {
        String startingUrl = this.getPageUrls().getNamedUrl(urlTemplateName, parameterValues);
        LOGGER.debug("Opening page at url {}", (Object)startingUrl);
        this.openPageAtUrl(startingUrl);
        this.checkUrlPatterns(openMode);
        this.initializePage();
        LOGGER.debug("Page opened");
    }

    public final void open() {
        this.open(OpenMode.CHECK_URL_PATTERNS);
    }

    public final void openUnchecked() {
        this.open(OpenMode.IGNORE_URL_PATTERNS);
    }

    private void open(OpenMode openMode) {
        String startingUrl = this.updateUrlWithBaseUrlIfDefined(this.getPageUrls().getStartingUrl());
        this.openPageAtUrl(startingUrl);
        this.checkUrlPatterns(openMode);
        this.initializePage();
    }

    private void initializePage() {
        this.addJQuerySupportIfRequired();
        this.callWhenPageOpensMethods();
    }

    private void checkUrlPatterns(OpenMode openMode) {
        if (openMode == OpenMode.CHECK_URL_PATTERNS) {
            this.ensurePageIsOnAMatchingUrl();
        }
    }

    private void ensurePageIsOnAMatchingUrl() {
        String currentUrl;
        if (!this.matchesAnyUrl() && !this.compatibleWithUrl(currentUrl = this.getDriver().getCurrentUrl())) {
            this.thisIsNotThePageYourLookingFor();
        }
    }

    public void shouldBeDisplayed() {
        this.ensurePageIsOnAMatchingUrl();
    }

    private void thisIsNotThePageYourLookingFor() {
        String errorDetails = "This is not the page you're looking for: I was looking for a page compatible with " + String.valueOf(this.getClass()) + " but I was at the URL " + this.getDriver().getCurrentUrl();
        throw new WrongPageError(errorDetails);
    }

    public final void openAt(String relativeUrl) {
        this.openPageAtUrl(this.updateUrlWithBaseUrlIfDefined(relativeUrl));
        this.callWhenPageOpensMethods();
    }

    public final void openUrl(String absoluteUrl) {
        this.openPageAtUrl(absoluteUrl);
        this.callWhenPageOpensMethods();
    }

    public void callWhenPageOpensMethods() {
        if (StepEventBus.getParallelEventBus().currentTestIsSuspended()) {
            return;
        }
        for (Method annotatedMethod : this.methodsAnnotatedWithWhenPageOpens()) {
            try {
                annotatedMethod.setAccessible(true);
                annotatedMethod.invoke((Object)this, new Object[0]);
            }
            catch (Throwable e) {
                LOGGER.error("Could not execute @WhenPageOpens annotated method: " + e.getMessage());
                if (e instanceof InvocationTargetException) {
                    e = ((InvocationTargetException)e).getTargetException();
                }
                if (AssertionError.class.isAssignableFrom(e.getClass())) {
                    throw (AssertionError)((Object)e);
                }
                throw new UnableToInvokeWhenPageOpensMethods("Could not execute @WhenPageOpens annotated method: " + e.getMessage(), e);
            }
        }
    }

    private List<Method> methodsAnnotatedWithWhenPageOpens() {
        List methods = MethodFinder.inClass(this.getClass()).getAllMethods();
        ArrayList<Method> annotatedMethods = new ArrayList<Method>();
        for (Method method : methods) {
            if (method.getAnnotation(WhenPageOpens.class) == null) continue;
            if (method.getParameterTypes().length == 0) {
                annotatedMethods.add(method);
                continue;
            }
            throw new UnableToInvokeWhenPageOpensMethods("Could not execute @WhenPageOpens annotated method: WhenPageOpens method cannot have parameters: " + String.valueOf(method));
        }
        return annotatedMethods;
    }

    public static String[] withParameters(String ... parameterValues) {
        return parameterValues;
    }

    private void openPageAtUrl(String startingUrl) {
        String url = NormalizeUrlForm.ofUrl(startingUrl);
        this.getDriver().get(url);
        this.addJQuerySupportIfRequired();
    }

    public void openPageNamed(String pageName) {
        this.getDriver().get(this.environmentSpecificPageUrl(pageName));
    }

    public void navigateToPageNamed(String pageName) {
        this.getDriver().navigate().to(this.environmentSpecificPageUrl(pageName));
    }

    private String environmentSpecificPageUrl(String pageName) {
        return (String)EnvironmentSpecificConfiguration.from((EnvironmentVariables)this.environmentVariables).getOptionalProperty(new String[]{"pages." + pageName}).orElseThrow(() -> new NoSuchPageException("No page called " + pageName + " was specified in the serenity.conf file"));
    }

    public void clickOn(WebElement webElement) {
        this.element(webElement).click();
    }

    public Boolean isElementVisible(By byCriteria) {
        return this.getRenderedView().elementIsDisplayed(byCriteria);
    }

    public void setDefaultBaseUrl(String defaultBaseUrl) {
        this.getPageUrls().overrideDefaultBaseUrl(defaultBaseUrl);
    }

    public boolean hasFocus(WebElement webElement) {
        return this.element(webElement).hasFocus();
    }

    public void blurActiveElement() {
        this.getJavascriptExecutorFacade().executeScript("document.activeElement.blur();");
    }

    protected JavascriptExecutorFacade getJavascriptExecutorFacade() {
        if (this.javascriptExecutorFacade == null) {
            this.javascriptExecutorFacade = new JavascriptExecutorFacade(this.driver);
        }
        return this.javascriptExecutorFacade;
    }

    public <T extends WebElementFacade> T element(WebElement webElement) {
        return WebElementFacadeImpl.wrapWebElement(this.getDriver(), webElement, this.getImplicitWaitTimeout().toMillis(), this.getWaitForTimeout().toMillis(), this.nameOf(webElement));
    }

    private String nameOf(WebElement webElement) {
        try {
            return webElement.toString();
        }
        catch (Exception e) {
            return "Unknown web element";
        }
    }

    public <T extends WebElementFacade> T $(WithLocator locator) {
        return this.element(locator.getLocator(), new Object[0]);
    }

    public <T extends WebElementFacade> T $(WithByLocator locator) {
        return this.element(locator.getLocator());
    }

    public <T extends WebElementFacade> T $(WebElement webElement) {
        return this.element(webElement);
    }

    public <T extends WebElementFacade> T $(String xpathOrCssSelector, Object ... arguments) {
        return this.element(xpathOrCssSelector, arguments);
    }

    public <T extends WebElementFacade> T $(By bySelector) {
        return this.element(bySelector);
    }

    public WebElementFacade $(ResolvableElement selector) {
        return this.find(selector);
    }

    public ListOfWebElementFacades $$(ResolvableElement selector) {
        return this.findAll(selector);
    }

    public String textOf(WithLocator locator) {
        return this.$(locator).getText();
    }

    public String textOf(WithByLocator locator) {
        return this.$(locator).getText();
    }

    public String textOf(String xpathOrCssSelector, Object ... arguments) {
        return this.$(xpathOrCssSelector, arguments).getText();
    }

    public String textOf(By bySelector) {
        return this.$(bySelector).getText();
    }

    public String textContentOf(WithLocator locator) {
        return this.$(locator).getTextContent();
    }

    public String textContentOf(WithByLocator locator) {
        return this.$(locator).getTextContent();
    }

    public String textContentOf(String xpathOrCssSelector, Object ... arguments) {
        return this.$(xpathOrCssSelector, arguments).getTextContent();
    }

    public String textContentOf(By bySelector) {
        return this.$(bySelector).getTextContent();
    }

    public ListOfWebElementFacades $$(String xpathOrCssSelector, Object ... arguments) {
        return this.findAll(xpathOrCssSelector, arguments);
    }

    public ListOfWebElementFacades $$(By bySelector) {
        return this.findAll(bySelector);
    }

    public <T extends WebElementFacade> T element(By bySelector) {
        return WebElementFacadeImpl.wrapWebElement(this.getDriver(), bySelector, this.getImplicitWaitTimeout().toMillis(), this.getWaitForTimeout().toMillis(), bySelector.toString());
    }

    public <T extends WebElementFacade> T find(By selector) {
        return this.element(selector);
    }

    public WebElementFacade find(ResolvableElement selector) {
        return selector.resolveFor(this);
    }

    public ListOfWebElementFacades findAll(ResolvableElement selector) {
        return this.findAllWithRetry(page -> selector.resolveAllFor(this));
    }

    public <T extends WebElementFacade> T find(WithByLocator selector) {
        return this.element(selector.getLocator());
    }

    public <T extends WebElementFacade> T find(WithLocator selector) {
        return this.element(selector.getLocator(), new Object[0]);
    }

    public <T extends WebElementFacade> T find(List<By> selectors) {
        WebElementFacade element = null;
        for (By selector : selectors) {
            if (element == null) {
                element = this.element(selector);
                continue;
            }
            element = element.find(selector);
        }
        return (T)element;
    }

    public <T extends WebElementFacade> T findBy(List<String> selectors) {
        WebElementFacade element = null;
        for (String selector : selectors) {
            if (element == null) {
                element = this.element(selector, new Object[0]);
                continue;
            }
            element = element.findBy(selector);
        }
        return (T)element;
    }

    public <T extends WebElementFacade> T findNested(By ... selectors) {
        WebElementFacade element = null;
        for (By selector : selectors) {
            element = element == null ? this.element(selector) : element.findBy(selector);
        }
        return (T)element;
    }

    public <T extends WebElementFacade> T find(String selector) {
        return this.findBy(NewList.of((Object[])new String[]{selector}));
    }

    public <T extends WebElementFacade> T findNested(String ... selectors) {
        return this.findBy(NewList.of((Object[])selectors));
    }

    public Optional<WebElementFacade> findFirst(String xpathOrCSSSelector) {
        return this.findEach(xpathOrCSSSelector).findFirst();
    }

    public Optional<WebElementFacade> findFirst(By bySelector) {
        return this.findEach(bySelector).findFirst();
    }

    public Stream<WebElementFacade> findEach(By bySelector) {
        return this.findAll(bySelector).stream();
    }

    public Stream<WebElementFacade> findEach(WithByLocator bySelector) {
        return this.findAll(bySelector.getLocator()).stream();
    }

    public Stream<WebElementFacade> findEach(WithLocator bySelector) {
        return this.findAll(bySelector.getLocator(), new Object[0]).stream();
    }

    public Stream<WebElementFacade> findEach(By ... bySelectors) {
        if (bySelectors.length == 1) {
            return this.findEach(bySelectors[0]);
        }
        return this.find(this.allButLastIn(bySelectors)).thenFindAll(this.lastIn(bySelectors)).stream();
    }

    public Stream<WebElementFacade> findEach(String ... xpathOrCssSelectors) {
        if (xpathOrCssSelectors.length == 1) {
            return this.findEach(xpathOrCssSelectors[0]);
        }
        return this.findBy(this.allButLastIn(xpathOrCssSelectors)).thenFindAll(this.lastIn(xpathOrCssSelectors)).stream();
    }

    public ListOfWebElementFacades findNestedElements(String ... xpathOrCssSelectors) {
        if (xpathOrCssSelectors.length == 1) {
            return this.findAll(xpathOrCssSelectors[0], new Object[0]);
        }
        return this.findBy(this.allButLastIn(xpathOrCssSelectors)).thenFindAll(this.lastIn(xpathOrCssSelectors));
    }

    private <T> List<T> allButLastIn(T[] selectors) {
        ArrayList<T> subList = new ArrayList<T>();
        subList.addAll(Arrays.asList(selectors).subList(0, selectors.length - 1));
        return subList;
    }

    private <T> T lastIn(T[] selectors) {
        return selectors[selectors.length - 1];
    }

    public Stream<WebElementFacade> findEach(String xpathOrCSSSelector) {
        return this.findAll(xpathOrCSSSelector, new Object[0]).stream();
    }

    public ListOfWebElementFacades findAll(By bySelector) {
        return this.findAllWithRetry(page -> {
            ArrayList matchingWebElements = new ArrayList();
            for (WebElement webElement : this.driver.findElements(bySelector)) {
                Object element = this.element(webElement);
                matchingWebElements.add(element);
            }
            return new ListOfWebElementFacades(matchingWebElements);
        });
    }

    public ListOfWebElementFacades findAll(WithLocator bySelector) {
        return this.findAllWithRetry(page -> page.findAll(bySelector.getLocator(), new Object[0]));
    }

    public ListOfWebElementFacades findAll(WithByLocator bySelector) {
        return this.findAllWithRetry(page -> page.findAll(bySelector.getLocator()));
    }

    public <T extends WebElementFacade> T element(String xpathOrCssSelector, Object ... arguments) {
        return this.element(Selectors.xpathOrCssSelector(ParameterisedLocator.withArguments(xpathOrCssSelector, arguments)));
    }

    public <T extends WebElementFacade> T findBy(String xpathOrCssSelector, Object ... arguments) {
        return this.element(ParameterisedLocator.withArguments(xpathOrCssSelector, arguments), new Object[0]);
    }

    public Optional<WebElementFacade> findFirst(String xpathOrCssSelector, Object ... arguments) {
        return this.findAll(xpathOrCssSelector, arguments).stream().findFirst();
    }

    public ListOfWebElementFacades findAll(String xpathOrCssSelector, Object ... arguments) {
        return this.findAllWithRetry(page -> page.findAll(Selectors.xpathOrCssSelector(ParameterisedLocator.withArguments(xpathOrCssSelector, arguments))));
    }

    public boolean containsElements(By bySelector) {
        return !this.findAll(bySelector).isEmpty();
    }

    public boolean containsElements(String xpathOrCssSelector, Object ... arguments) {
        return !this.findAll(xpathOrCssSelector, arguments).isEmpty();
    }

    public Object evaluateJavascript(String script) {
        if (StepEventBus.getParallelEventBus().isDryRun()) {
            return "";
        }
        this.addJQuerySupportIfRequired();
        JavascriptExecutorFacade js = new JavascriptExecutorFacade(this.driver);
        return js.executeScript(script);
    }

    public Object evaluateAsyncJavascript(String script) {
        if (StepEventBus.getParallelEventBus().isDryRun()) {
            return "";
        }
        this.addJQuerySupportIfRequired();
        JavascriptExecutorFacade js = new JavascriptExecutorFacade(this.driver);
        return js.executeAsyncScript(script);
    }

    public Object evaluateJavascript(String script, Object ... params) {
        if (StepEventBus.getParallelEventBus().isDryRun()) {
            return "";
        }
        this.addJQuerySupportIfRequired();
        JavascriptExecutorFacade js = new JavascriptExecutorFacade(this.driver);
        return js.executeScript(script, params);
    }

    public Object evaluateAsyncJavascript(String script, Object ... params) {
        if (StepEventBus.getParallelEventBus().isDryRun()) {
            return "";
        }
        this.addJQuerySupportIfRequired();
        JavascriptExecutorFacade js = new JavascriptExecutorFacade(this.driver);
        return js.executeAsyncScript(script, params);
    }

    public void addJQuerySupportIfRequired() {
        if (JavascriptSupport.javascriptIsSupportedIn(this.getDriver()) && this.jqueryIntegrationIsActivated().booleanValue() && this.driverIsJQueryCompatible() && this.pageIsLoaded()) {
            JQueryEnabledPage jQueryEnabledPage = JQueryEnabledPage.withDriver(this.getDriver());
            jQueryEnabledPage.activateJQuery();
        }
    }

    protected boolean driverIsJQueryCompatible() {
        try {
            if (this.getDriver() instanceof WebDriverFacade) {
                return SupportedWebDriver.forClass(((WebDriverFacade)this.getDriver()).getDriverClass()).supportsJavascriptInjection();
            }
            return SupportedWebDriver.forClass(this.getDriver().getClass()).supportsJavascriptInjection();
        }
        catch (IllegalArgumentException probablyAMockedDriver) {
            return false;
        }
    }

    public void enableJQuery() {
        this.enableJQuery = true;
    }

    private Boolean jqueryIntegrationIsActivated() {
        return this.enableJQuery || ThucydidesSystemProperty.SERENITY_JQUERY_INTEGRATION.booleanFrom(this.environmentVariables, Boolean.valueOf(false)) != false;
    }

    public RadioButtonGroup inRadioButtonGroup(String name) {
        return new RadioButtonGroup(this.getDriver().findElements(By.name((String)name)));
    }

    private boolean pageIsLoaded() {
        try {
            return this.driverIsInstantiated() && this.getDriver().getCurrentUrl() != null;
        }
        catch (WebDriverException e) {
            return false;
        }
    }

    protected boolean driverIsInstantiated() {
        if (this.getDriver() instanceof WebDriverFacade) {
            return ((WebDriverFacade)this.getDriver()).isEnabled() && ((WebDriverFacade)this.getDriver()).isInstantiated();
        }
        return true;
    }

    public ThucydidesFluentWait<WebDriver> waitForWithRefresh() {
        return new FluentWaitWithRefresh<WebDriver>(this.getDriver(), this.webdriverClock, this.sleeper).withTimeout(this.getWaitForTimeout().toMillis(), TimeUnit.MILLISECONDS).pollingEvery(250L, TimeUnit.MILLISECONDS).ignoring(NoSuchElementException.class, NoSuchFrameException.class);
    }

    public SerenityFluentWait waitForCondition() {
        return (SerenityFluentWait)new SerenityFluentWait(this.getDriver(), this.webdriverClock, this.sleeper).withTimeout(this.getWaitForTimeout()).pollingEvery(Duration.ofMillis(250L)).ignoring(NoSuchElementException.class, NoSuchFrameException.class);
    }

    public WebElementFacade waitFor(WebElement webElement) {
        return this.getRenderedView().waitFor(webElement);
    }

    public WebElementFacade waitFor(WebElementFacade webElement) {
        return this.getRenderedView().waitFor(webElement);
    }

    public WebElementFacadeWait waitForElement() {
        return this.getRenderedView().waitForElement();
    }

    public Alert getAlert() {
        return this.getDriver().switchTo().alert();
    }

    public Actions withAction() {
        WebDriver proxiedDriver = this.getDriver() instanceof WebDriverFacade ? ((WebDriverFacade)this.getDriver()).getProxiedDriver() : this.getDriver();
        return new SerenityActions(proxiedDriver);
    }

    private void notifyScreenChange() {
        StepEventBus.getParallelEventBus().notifyScreenChange();
    }

    protected ThucydidesFluentAdapter fluent() {
        return new ThucydidesFluentAdapter(this.getDriver());
    }

    public <T extends WebElementFacade> T moveTo(String xpathOrCssSelector, Object ... arguments) {
        if (!this.driverIsDisabled()) {
            this.withAction().moveToElement(this.findBy(xpathOrCssSelector, arguments)).perform();
        }
        return this.findBy(xpathOrCssSelector, arguments);
    }

    public <T extends WebElementFacade> T moveTo(By locator) {
        if (!this.driverIsDisabled()) {
            this.withAction().moveToElement(this.find(locator)).perform();
        }
        return this.find(locator);
    }

    public void waitForAngularRequestsToFinish() {
        JavascriptCompatibleVersion.of(this.getDriver()).ifPresent(driver -> WaitForAngular.withDriver(driver).untilAngularRequestsHaveFinished());
    }

    public String toString() {
        return this.inflection.of(this.getClass().getSimpleName()).inHumanReadableForm().toString();
    }

    protected ListOfWebElementFacades findAllWithRetry(Function<PageObject, ListOfWebElementFacades> finder) {
        return new FindAllWithRetry(this.environmentVariables).find(finder, this);
    }

    public static class WaitingBuilder {
        private final int timeout;
        private final PageObject page;

        public WaitingBuilder(int timeout, PageObject page) {
            this.timeout = timeout;
            this.page = page;
        }

        public RenderedPageObjectView milliseconds() {
            return this.page.withTimeoutOf(Duration.ofMillis(this.timeout));
        }

        public RenderedPageObjectView seconds() {
            return this.page.withTimeoutOf(Duration.ofSeconds(this.timeout));
        }

        public RenderedPageObjectView minutes() {
            return this.page.withTimeoutOf(Duration.ofMinutes(this.timeout));
        }
    }

    public class FieldEntry {
        private final CharSequence[] keysToSend;

        public FieldEntry(CharSequence ... keysToSend) {
            this.keysToSend = keysToSend;
        }

        public void into(WebElement field) {
            PageObject.this.element(field).type(this.keysToSend);
        }

        public void into(WebElementFacade field) {
            field.type(this.keysToSend);
        }

        public void into(By bySelector) {
            WebElement field = PageObject.this.getDriver().findElement(bySelector);
            this.into(field);
        }

        public void into(String selector) {
            PageObject.this.$(selector, new Object[0]).type(this.keysToSend);
        }
    }

    private static enum OpenMode {
        CHECK_URL_PATTERNS,
        IGNORE_URL_PATTERNS;

    }

    public static class OpenWithParams {
        private PageObject pageObject;
        private final String urlTemplateName;

        public OpenWithParams(PageObject pageObject, String urlTemplateName) {
            this.pageObject = pageObject;
            this.urlTemplateName = urlTemplateName;
        }

        public void withParameters(String ... parameters) {
            this.pageObject.open(this.urlTemplateName, parameters);
        }
    }
}

