/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.steps;

import com.google.common.eventbus.Subscribe;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.thucydides.core.events.TestLifecycleEvents;
import net.thucydides.core.steps.StepEventBus;
import net.thucydides.model.domain.DataTable;

public class ExampleTables {
    private static final ThreadLocal<ExampleTables> currentExampleTable = new ThreadLocal();
    private final List<String> headers;
    private final String title;
    private DataTable table;

    public DataTable getTable() {
        if (this.table == null) {
            this.table = DataTable.withHeaders(this.headers).andTitle(this.title).build();
        }
        return this.table;
    }

    ExampleTables(String title, String[] headers) {
        this.title = title;
        this.headers = Arrays.asList(headers);
    }

    public List<String> getHeaders() {
        return new ArrayList<String>(this.headers);
    }

    public static WithHeaders useExampleTable() {
        return new ExampleTableBuilder();
    }

    public static boolean isUsingAnExampleTable() {
        return currentExampleTable.get() != null;
    }

    public static ExampleTables getCurrentExampleTable() {
        return currentExampleTable.get();
    }

    public static void clear() {
        if (currentExampleTable.get() != null) {
            currentExampleTable.get().clearTable();
        }
        currentExampleTable.remove();
    }

    private void clearTable() {
        this.table = null;
    }

    public void start() {
        DataTable table = DataTable.withHeaders(this.headers).andTitle(this.title).build();
        StepEventBus.getParallelEventBus().useExamplesFrom(table);
        StepEventBus.getParallelEventBus().enableSoftAsserts();
        TestLifecycleEvents.register(this);
    }

    @Subscribe
    public void testFinishes(TestLifecycleEvents.TestFinished testFinished) {
        TestLifecycleEvents.unregister(this);
        ExampleTables.clear();
    }

    static class ExampleTableBuilder
    implements WithHeaders,
    OptionalFields {
        private String[] headers;
        private String title;

        ExampleTableBuilder() {
        }

        @Override
        public OptionalFields withHeaders(String ... headers) {
            this.headers = headers;
            return this;
        }

        @Override
        public OptionalFields andTitle(String title) {
            this.title = title;
            return this;
        }

        @Override
        public void start() {
            ExampleTables exampleTables = new ExampleTables(this.title, this.headers);
            exampleTables.start();
            currentExampleTable.set(exampleTables);
        }
    }

    public static interface OptionalFields {
        public OptionalFields andTitle(String var1);

        public void start();
    }

    public static interface WithHeaders {
        public OptionalFields withHeaders(String ... var1);
    }
}

