/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.annotations;

import java.lang.reflect.Field;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.serenitybdd.annotations.ClearCookiesPolicy;
import net.serenitybdd.annotations.Fields;
import net.serenitybdd.annotations.Managed;
import net.thucydides.core.annotations.InvalidManagedWebDriverFieldException;
import net.thucydides.core.webdriver.WebDriverFacade;
import org.openqa.selenium.WebDriver;

public class ManagedWebDriverAnnotatedField {
    private static final String NO_ANNOTATED_FIELD_ERROR = "No WebDriver field annotated with @Managed was found in the test case.";
    private final Field field;

    static Optional<ManagedWebDriverAnnotatedField> findOptionalAnnotatedField(Class<?> testClass) {
        try {
            return ManagedWebDriverAnnotatedField.fieldsIn(testClass).stream().filter(ManagedWebDriverAnnotatedField::isFieldAnnotated).map(ManagedWebDriverAnnotatedField::new).findFirst();
        }
        catch (NoSuchElementException e) {
            return Optional.empty();
        }
    }

    public static ManagedWebDriverAnnotatedField findFirstAnnotatedField(Class<?> testClass) {
        Optional<ManagedWebDriverAnnotatedField> optionalField = ManagedWebDriverAnnotatedField.findOptionalAnnotatedField(testClass);
        if (optionalField.isPresent()) {
            return optionalField.get();
        }
        throw new InvalidManagedWebDriverFieldException(NO_ANNOTATED_FIELD_ERROR);
    }

    static List<ManagedWebDriverAnnotatedField> findAnnotatedFields(Class<?> testClass) {
        return Fields.of(testClass).allFields().stream().filter(ManagedWebDriverAnnotatedField::isFieldAnnotated).map(ManagedWebDriverAnnotatedField::new).collect(Collectors.toList());
    }

    public static boolean hasManagedWebdriverField(Class<?> testClass) {
        try {
            return ManagedWebDriverAnnotatedField.fieldsIn(testClass).stream().anyMatch(ManagedWebDriverAnnotatedField::isFieldAnnotated);
        }
        catch (NoSuchElementException e) {
            return false;
        }
    }

    private static boolean isFieldAnnotated(Field field) {
        return ManagedWebDriverAnnotatedField.fieldIsAnnotatedCorrectly(field) && ManagedWebDriverAnnotatedField.fieldIsRightType(field);
    }

    private static boolean fieldIsRightType(Field field) {
        return WebDriverFacade.class.isAssignableFrom(field.getType()) || field.getType().isAssignableFrom(WebDriver.class);
    }

    private static boolean fieldIsAnnotatedCorrectly(Field field) {
        return field.getAnnotation(Managed.class) != null;
    }

    private ManagedWebDriverAnnotatedField(Field field) {
        this.field = field;
    }

    public void setValue(Object testCase, WebDriver manageDriver) {
        try {
            this.field.setAccessible(true);
            this.field.set(testCase, manageDriver);
        }
        catch (IllegalAccessException e) {
            throw new InvalidManagedWebDriverFieldException("Could not access or set web driver field: " + String.valueOf(this.field) + " - is this field public?", e);
        }
    }

    private static Set<Field> fieldsIn(Class clazz) {
        return Fields.of((Class)clazz).allFields();
    }

    public boolean isUniqueSession() {
        return this.field.getAnnotation(Managed.class).uniqueSession();
    }

    ClearCookiesPolicy getClearCookiesPolicy() {
        return this.field.getAnnotation(Managed.class).clearCookies();
    }

    public String getDriver() {
        return this.field.getAnnotation(Managed.class).driver();
    }

    public String getOptions() {
        return this.field.getAnnotation(Managed.class).options();
    }

    public String getName() {
        return this.field.getName();
    }
}

