/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.core.pages;

import java.util.List;
import java.util.stream.Collectors;
import net.serenitybdd.core.pages.WebElementFacade;
import net.serenitybdd.core.pages.WebElementFacadeImpl;
import net.serenitybdd.core.pages.WithRetries;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.Select;

class DropdownSelector {
    private final WebElementFacadeImpl webElementFacade;

    public DropdownSelector(WebElementFacadeImpl webElementFacade) {
        this.webElementFacade = webElementFacade;
    }

    public WebElementFacade byVisibleText(String label) {
        if (this.webElementFacade.driverIsDisabled()) {
            return this.webElementFacade;
        }
        WithRetries.on(this.webElementFacade).perform(elementFacade -> {
            Select select = new Select(this.webElementFacade.getElement());
            select.selectByVisibleText(label);
        }, 12);
        this.webElementFacade.notifyScreenChange();
        return this.webElementFacade;
    }

    public String visibleTextValue() {
        Select select = new Select(this.webElementFacade.getElement());
        return select.getFirstSelectedOption().getText();
    }

    public List<String> visibleTextValues() {
        Select select = new Select(this.webElementFacade.getElement());
        return select.getAllSelectedOptions().stream().map(WebElement::getText).collect(Collectors.toList());
    }

    public WebElementFacade byValue(String value) {
        if (this.webElementFacade.driverIsDisabled()) {
            return this.webElementFacade;
        }
        WithRetries.on(this.webElementFacade).perform(elementFacade -> {
            Select select = new Select(this.webElementFacade.getElement());
            select.selectByValue(value);
        }, 12);
        this.webElementFacade.notifyScreenChange();
        return this.webElementFacade;
    }

    public String value() {
        Select select = new Select(this.webElementFacade.getElement());
        return select.getFirstSelectedOption().getAttribute("value");
    }

    public List<String> values() {
        Select select = new Select(this.webElementFacade.getElement());
        return select.getAllSelectedOptions().stream().map(option -> option.getAttribute("value")).collect(Collectors.toList());
    }

    public WebElementFacade byIndex(int indexValue) {
        if (this.webElementFacade.driverIsDisabled()) {
            return this.webElementFacade;
        }
        WithRetries.on(this.webElementFacade).perform(elementFacade -> {
            Select select = new Select(this.webElementFacade.getElement());
            select.selectByIndex(indexValue);
        }, 12);
        this.webElementFacade.notifyScreenChange();
        return this.webElementFacade;
    }
}

