/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.core.pages;

import java.time.Duration;
import java.util.function.Consumer;
import net.serenitybdd.core.pages.WebElementFacadeImpl;
import org.openqa.selenium.InvalidElementStateException;

public class WithRetries {
    private final WebElementFacadeImpl elementFacade;

    public static WithRetries on(WebElementFacadeImpl elementFacade) {
        return new WithRetries(elementFacade);
    }

    private WithRetries(WebElementFacadeImpl elementFacade) {
        this.elementFacade = elementFacade;
    }

    public void perform(Consumer<WebElementFacadeImpl> action, int remainingTries) {
        try {
            if (remainingTries > 0) {
                action.accept(this.elementFacade);
            }
        }
        catch (InvalidElementStateException couldNotInteractWithElement) {
            this.sleep(Duration.ofMillis(250L));
            if (remainingTries > 1) {
                this.perform(action, remainingTries - 1);
            }
            throw couldNotInteractWithElement;
        }
    }

    private void sleep(Duration duration) {
        try {
            Thread.sleep(duration.toMillis());
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

