/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.webdriver;

import java.util.List;
import net.serenitybdd.core.webdriver.configuration.RestartBrowserForEach;
import net.serenitybdd.model.collect.NewList;
import net.thucydides.core.annotations.TestCaseAnnotations;
import net.thucydides.core.webdriver.CloseBrowser;
import net.thucydides.core.webdriver.WebdriverCloseBrowser;
import net.thucydides.model.util.EnvironmentVariables;

public class TestSuiteCloseBrowser
extends WebdriverCloseBrowser
implements CloseBrowser {
    private final Class<?> testSuite;
    private static final List<RestartBrowserForEach> SCENARIO_EVENTS = NewList.of((Object[])new RestartBrowserForEach[]{RestartBrowserForEach.SCENARIO, RestartBrowserForEach.EXAMPLE});

    public TestSuiteCloseBrowser(EnvironmentVariables environmentVariables, Class<?> testSuite) {
        super(environmentVariables);
        this.testSuite = testSuite;
    }

    @Override
    public void closeIfConfiguredForANew(RestartBrowserForEach event) {
        if (SCENARIO_EVENTS.contains((Object)event) && this.useUniqueBrowserSessionForScenarios()) {
            return;
        }
        super.closeIfConfiguredForANew(event);
    }

    private boolean useUniqueBrowserSessionForScenarios() {
        return TestCaseAnnotations.isUniqueSession(this.testSuite);
    }
}

