/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.webdriver.capabilities;

public class CapabilityProperty {
    public static Object asObject(String propertyValue) {
        if (CapabilityProperty.isAQuoted(propertyValue)) {
            return propertyValue;
        }
        try {
            return Integer.parseInt(propertyValue);
        }
        catch (NumberFormatException numberFormatException) {
            if (propertyValue.equalsIgnoreCase("true") || propertyValue.equalsIgnoreCase("false")) {
                return Boolean.parseBoolean(propertyValue);
            }
            return propertyValue;
        }
    }

    private static boolean isAQuoted(String propertyValue) {
        return CapabilityProperty.surroundedBy("\"", propertyValue) || CapabilityProperty.surroundedBy("'", propertyValue);
    }

    private static boolean surroundedBy(String quote, String propertyValue) {
        return propertyValue.startsWith(quote) && propertyValue.endsWith(quote);
    }
}

