/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.junit.platform.engine;

import com.google.common.base.Strings;
import io.cucumber.junit.platform.engine.TestWeightCalculator;
import io.cucumber.tagexpressions.Expression;
import io.cucumber.tagexpressions.TagExpressionParser;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.support.descriptor.ClasspathResourceSource;

public class WeightedTest {
    private final TestDescriptor scenario;
    private final int weight;
    private final List<String> tags;

    WeightedTest(TestDescriptor scenario) {
        this(scenario, TestWeightCalculator.calculateWeight(scenario));
    }

    public WeightedTest(TestDescriptor scenario, int weight) {
        this.scenario = scenario;
        this.weight = weight;
        this.tags = this.parseTags(scenario);
    }

    List<String> getTags() {
        return this.tags;
    }

    String getSourceFile() {
        return this.scenario.getSource().map(ClasspathResourceSource.class::cast).map(ClasspathResourceSource::getClasspathResourceName).orElse(null);
    }

    String getDisplayName() {
        return this.scenario.getDisplayName();
    }

    int getWeight() {
        return this.weight;
    }

    void removeFromHierarchy() {
        Optional featureOpt = this.scenario.getParent();
        this.scenario.removeFromHierarchy();
        featureOpt.filter(feature -> feature.getChildren().isEmpty()).ifPresent(TestDescriptor::prune);
    }

    boolean isTagMatchingFilter(String tagFilter) {
        if (Strings.isNullOrEmpty((String)tagFilter)) {
            return true;
        }
        Expression expression = TagExpressionParser.parse((String)tagFilter);
        return expression.evaluate(this.tags);
    }

    private List<String> parseTags(TestDescriptor test) {
        if (test.isTest()) {
            return test.getTags().stream().map(tag -> "@" + String.valueOf(tag)).collect(Collectors.toList());
        }
        return test.getChildren().stream().map(this::parseTags).flatMap(Collection::stream).distinct().collect(Collectors.toList());
    }

    public String toString() {
        return String.format("%s:%s(%s - %d)", this.getSourceFile(), this.getDisplayName(), this.tags, this.weight);
    }
}

