/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.junit5;

import net.serenitybdd.junit5.PendingTestException;
import net.serenitybdd.junit5.SkippedTestException;
import net.thucydides.core.steps.StepEventBus;
import net.thucydides.model.domain.TestOutcome;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public class SerenityAfterEachCallback
implements AfterEachCallback {
    public void afterEach(ExtensionContext context) throws Exception {
        if (!StepEventBus.getParallelEventBus().isBaseStepListenerRegistered()) {
            System.out.println("NO BASE STEP LISTENER FOUND IN THREAD " + String.valueOf(Thread.currentThread()));
        }
        TestOutcome outcome = StepEventBus.getParallelEventBus().getBaseStepListener().getCurrentTestOutcome();
        String methodName = outcome.getQualifiedMethodName();
        context.getTestMethod().ifPresent(method -> {
            if (method.getName().equals(methodName)) {
                if (outcome.getTestFailureCause() != null) {
                    throw outcome.getTestFailureCause().asRuntimeException();
                }
                if (outcome.isPending().booleanValue()) {
                    throw new PendingTestException(context.getDisplayName());
                }
                if (outcome.isSkipped().booleanValue()) {
                    throw new SkippedTestException(context.getDisplayName());
                }
            }
        });
    }
}

