/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.requirements.reports.cucumber;

import io.cucumber.messages.Messages;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.model.TestResult;
import net.thucydides.core.model.TestResultList;
import net.thucydides.core.model.TestTag;
import net.thucydides.core.reports.TestOutcomes;
import net.thucydides.core.reports.html.CucumberTagConverter;
import net.thucydides.core.reports.html.ReportNameProvider;
import net.thucydides.core.requirements.model.Requirement;
import net.thucydides.core.requirements.model.cucumber.AnnotatedFeature;
import net.thucydides.core.requirements.model.cucumber.CucumberParser;
import net.thucydides.core.requirements.reports.ReportBadges;
import net.thucydides.core.requirements.reports.RequirementsOutcomes;
import net.thucydides.core.requirements.reports.ScenarioOutcome;
import net.thucydides.core.requirements.reports.ScenarioSummaryOutcome;
import net.thucydides.core.requirements.reports.cucumber.RenderCucumber;
import net.thucydides.core.tags.TagScanner;
import net.thucydides.core.util.EnvironmentVariables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeatureFileScenarioOutcomes {
    private static final Logger LOGGER = LoggerFactory.getLogger(FeatureFileScenarioOutcomes.class);
    private Requirement requirement;
    private EnvironmentVariables environmentVariables;
    private TagScanner tagScanner;

    public FeatureFileScenarioOutcomes(Requirement requirement, EnvironmentVariables environmentVariables) {
        this.requirement = requirement;
        this.environmentVariables = environmentVariables;
        this.tagScanner = new TagScanner(environmentVariables);
    }

    public FeatureFileScenarioOutcomes(Requirement requirement) {
        this(requirement, (EnvironmentVariables)Injectors.getInjector().getInstance(EnvironmentVariables.class));
    }

    public static FeatureFileScenarioOutcomes from(Requirement requirement) {
        return new FeatureFileScenarioOutcomes(requirement);
    }

    public List<ScenarioOutcome> forOutcomesIn(RequirementsOutcomes requirementsOutcomes) {
        CucumberParser parser = new CucumberParser();
        Optional<AnnotatedFeature> feature = parser.loadFeature(this.pathFromResourceOnClasspath(this.requirement.getPath()));
        if (!feature.isPresent()) {
            return Collections.emptyList();
        }
        ArrayList<ScenarioOutcome> scenarioOutcomes = new ArrayList<ScenarioOutcome>();
        Messages.GherkinDocument.Feature currentFeature = feature.get().getFeature();
        for (Messages.GherkinDocument.Feature.FeatureChild currentChild : currentFeature.getChildrenList()) {
            if (currentChild.hasRule()) {
                Messages.GherkinDocument.Feature.FeatureChild.Rule currentRule = currentChild.getRule();
                currentRule.getChildrenList().forEach(ruleChildren -> scenarioOutcomes.add(this.scenarioOutcomeFrom(currentFeature, ruleChildren.getScenario(), requirementsOutcomes.getTestOutcomes(), currentRule.getName())));
                continue;
            }
            scenarioOutcomes.add(this.scenarioOutcomeFrom(currentFeature, currentChild.getScenario(), requirementsOutcomes.getTestOutcomes()));
        }
        return scenarioOutcomes;
    }

    private ScenarioOutcome scenarioOutcomeFrom(Messages.GherkinDocument.Feature feature, Messages.GherkinDocument.Feature.Scenario scenario, TestOutcomes testOutcomes) {
        return this.scenarioOutcomeFrom(feature, scenario, testOutcomes, "RULE_NOT_SET");
    }

    private ScenarioOutcome scenarioOutcomeFrom(Messages.GherkinDocument.Feature feature, Messages.GherkinDocument.Feature.Scenario scenario, TestOutcomes testOutcomes, String rule) {
        List<TestOutcome> outcomes = testOutcomes.testOutcomesWithName(scenario.getName());
        String scenarioTitle = scenario.getName();
        TestResult result = outcomes.isEmpty() ? TestResult.UNDEFINED : TestResultList.overallResultFrom(outcomes.stream().map(TestOutcome::getResult).collect(Collectors.toList()));
        List<String> reportBadges = ReportBadges.from(outcomes, scenario.getName());
        String featureReport = new ReportNameProvider().forRequirement(feature.getName(), "feature");
        Optional<String> scenarioReport = outcomes.isEmpty() ? Optional.empty() : Optional.of(outcomes.get(0).getHtmlReport());
        List<String> renderedSteps = scenario.getStepsList().stream().map(RenderCucumber::step).collect(Collectors.toList());
        ArrayList<Messages.GherkinDocument.Feature.Scenario.Examples> filteredExamples = new ArrayList<Messages.GherkinDocument.Feature.Scenario.Examples>();
        HashMap<String, Collection<TestTag>> exampleTags = new HashMap<String, Collection<TestTag>>();
        if (this.scenarioContainsExamples(scenario)) {
            List examples2 = scenario.getExamplesList();
            examples2.stream().filter(example -> example.getTagsList().isEmpty() || this.tagScanner.shouldRunForTags(CucumberTagConverter.fromGherkinTags(example.getTagsList()))).forEach(filteredExamples::add);
            Set<TestTag> scenarioOutlineTags = this.scenarioOutlineTagsIn(scenario);
            examples2.stream().forEach(example -> {
                Collection<TestTag> testTags = CucumberTagConverter.toSerenityTags(example.getTagsList());
                testTags.addAll(scenarioOutlineTags);
                exampleTags.put(example.getName() + ":" + example.getLocation(), testTags);
            });
        }
        ArrayList<Messages.GherkinDocument.Feature.Scenario.Examples> examplesList = filteredExamples;
        List<String> renderedExamples = this.scenarioContainsExamples(scenario) ? RenderCucumber.examples(examplesList, feature.getName(), scenario.getName()) : Collections.EMPTY_LIST;
        int exampleCount = this.scenarioContainsExamples(scenario) ? examplesList.stream().mapToInt(examples -> examples.getTableBodyList().size()).sum() : 0;
        Boolean isManual = outcomes.size() == 1 ? outcomes.get(0).isManual() : this.hasManualTag(feature.getTagsList()).booleanValue();
        Set<TestTag> scenarioTags = outcomes.stream().flatMap(outcome -> outcome.getTags().stream()).collect(Collectors.toSet());
        scenarioTags.addAll(this.scenarioTagsDefinedIn(scenario));
        return new ScenarioSummaryOutcome(scenarioTitle, scenario.getKeyword(), result, reportBadges, scenarioReport.orElse(""), scenario.getDescription(), renderedSteps, renderedExamples, exampleCount, isManual, feature.getName(), featureReport, scenarioTags, exampleTags, rule);
    }

    private Set<TestTag> scenarioTagsDefinedIn(Messages.GherkinDocument.Feature.Scenario scenario) {
        if (this.scenarioContainsExamples(scenario)) {
            return this.scenarioOutlineTagsIncludingExamplesIn(scenario);
        }
        return this.scenarioTagsIn(scenario);
    }

    private boolean scenarioContainsExamples(Messages.GherkinDocument.Feature.Scenario scenario) {
        return scenario.getExamplesCount() > 0;
    }

    private Set<TestTag> scenarioOutlineTagsIn(Messages.GherkinDocument.Feature.Scenario scenarioOutline) {
        Set<TestTag> testTags = scenarioOutline.getTagsList().stream().map(tag -> TestTag.withValue(tag.getName())).collect(Collectors.toSet());
        return testTags;
    }

    private Set<TestTag> scenarioOutlineTagsIncludingExamplesIn(Messages.GherkinDocument.Feature.Scenario scenarioOutline) {
        Set<TestTag> testTags = this.scenarioOutlineTagsIn(scenarioOutline);
        Set exampleTags = scenarioOutline.getExamplesList().stream().flatMap(examples -> examples.getTagsList().stream()).map(tag -> TestTag.withValue(tag.getName())).collect(Collectors.toSet());
        testTags.addAll(exampleTags);
        return testTags;
    }

    private Set<TestTag> scenarioTagsIn(Messages.GherkinDocument.Feature.Scenario scenario) {
        return scenario.getTagsList().stream().map(tag -> TestTag.withValue(tag.getName())).collect(Collectors.toSet());
    }

    private Boolean hasManualTag(List<Messages.GherkinDocument.Feature.Tag> tags) {
        return tags.stream().anyMatch(tag -> tag.getName().toLowerCase().startsWith("@manual"));
    }

    private File pathFromResourceOnClasspath(String path) {
        URL featureFileURL = this.getClass().getClassLoader().getResource(this.featuresDirectory() + "/" + path);
        String featureFilePath = featureFileURL != null ? featureFileURL.getFile() : new File("src/test/resources/" + this.featuresDirectory() + "/" + path).getAbsolutePath();
        return featureFilePath == null ? null : new File(featureFilePath);
    }

    private String featuresDirectory() {
        return ThucydidesSystemProperty.SERENITY_FEATURES_DIRECTORY.from(this.environmentVariables, "features");
    }
}

