/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.model;

import com.google.common.base.Preconditions;
import java.util.Optional;
import net.serenitybdd.core.strings.Joiner;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class TestTag
implements Comparable<TestTag> {
    public static final TestTag EMPTY_TAG = new TestTag("", "");
    public static final String DEFAULT_TAG_TYPE = "tag";
    private final String name;
    private final String type;
    private final String displayName;
    private transient String normalisedName;
    private transient String normalisedType;

    private TestTag(String name, String type) {
        this(name, type, name);
    }

    private TestTag(String name, String type, String displayName) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)type);
        Preconditions.checkNotNull((Object)displayName);
        this.name = name;
        this.type = type;
        this.displayName = displayName;
    }

    public boolean isIssueTag() {
        return this.type.equalsIgnoreCase("issue");
    }

    public String normalisedName() {
        if (this.normalisedName == null) {
            this.normalisedName = this.normalised(this.name);
        }
        return this.normalisedName;
    }

    private String normalised(String name) {
        return name.replaceAll("[\\s_-]", " ").toLowerCase();
    }

    public String normalisedType() {
        if (this.normalisedType == null) {
            this.normalisedType = this.normalised(this.type);
        }
        return this.normalisedType;
    }

    public String getCompleteName() {
        if (StringUtils.isEmpty((CharSequence)this.name) && StringUtils.isEmpty((CharSequence)this.type)) {
            return "";
        }
        return Joiner.on("_").join(this.normalisedType(), this.normalisedName());
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return Optional.ofNullable(this.displayName).orElse(this.name);
    }

    public String getType() {
        return this.type;
    }

    public String getShortName() {
        return this.name.contains("/") ? this.name.substring(this.name.indexOf("/") + 1) : this.name;
    }

    public static TestTagBuilder withName(String tagName) {
        return new TestTagBuilder(tagName);
    }

    public static TestTag withValue(String value) {
        if ((value = TestTag.stripLeadingAtSymbol(value)).contains(":")) {
            return TestTag.getTestTag(value, value.indexOf(":"));
        }
        if (value.contains("=")) {
            return TestTag.getTestTag(value, value.indexOf("="));
        }
        return TestTag.withName(value.trim()).andType(DEFAULT_TAG_TYPE);
    }

    private static String stripLeadingAtSymbol(String value) {
        return value.startsWith("@") ? value.substring(1) : value;
    }

    public TestTag withDisplayName(String displayName) {
        return new TestTag(this.name, this.type, displayName);
    }

    private static TestTag getTestTag(String value, int separatorPosition) {
        String type = value.substring(0, separatorPosition).trim();
        String name = value.substring(separatorPosition + 1).trim();
        return TestTag.withName(name).andType(type);
    }

    @Override
    public int compareTo(TestTag otherTag) {
        int typeComparison = ObjectUtils.compare((Comparable)((Object)this.getType()), (Comparable)((Object)otherTag.getType()));
        if (typeComparison != 0) {
            return typeComparison;
        }
        return this.getName().compareToIgnoreCase(otherTag.getName());
    }

    public boolean isAsOrMoreSpecificThan(TestTag testTag) {
        if (this.equals(testTag)) {
            return true;
        }
        if (this.getType().equals(testTag.getType()) && testTag.normalisedName().replaceFirst(".*?([^.]+)$", "$1").equals(this.normalisedName())) {
            return true;
        }
        return this.normalisedName().endsWith("/" + testTag.normalisedName()) && this.getType().equals(testTag.getType());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TestTag testTag = (TestTag)o;
        if (!this.normalisedName().equals(testTag.normalisedName())) {
            return false;
        }
        return this.normalisedType().equals(testTag.normalisedType());
    }

    public boolean equalsIgnoreCase(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TestTag testTag = (TestTag)o;
        if (!this.normalisedName().equalsIgnoreCase(testTag.normalisedName())) {
            return false;
        }
        return this.normalisedType().equalsIgnoreCase(testTag.normalisedType());
    }

    public int hashCode() {
        int result = this.normalisedName().hashCode();
        result = 31 * result + this.normalisedType().hashCode();
        return result;
    }

    public String toString() {
        if (this.type.isEmpty()) {
            return this.name;
        }
        return this.type + ":" + this.name;
    }

    public static class TestTagBuilder {
        private final String name;

        public TestTagBuilder(String name) {
            this.name = name;
        }

        public TestTag andType(String type) {
            return new TestTag(this.name, this.withoutTagSymbol(type));
        }

        private String withoutTagSymbol(String type) {
            return type.startsWith("@") ? type.substring(1) : type;
        }
    }
}

