/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.model;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.requirements.reports.ScenarioOutcome;
import org.apache.commons.lang3.StringUtils;

public class ContextIcon {
    private static final Map<String, String> ICON_CLASSES_FOR_COMMON_CONTEXTS = new HashMap<String, String>();
    private static final Map<String, String> CONTEXT_TITLES;

    public static String forOutcome(ScenarioOutcome scenarioOutcome) {
        return ContextIcon.forContext(scenarioOutcome.getContext());
    }

    public static String labelForOutcome(ScenarioOutcome scenarioOutcome) {
        return ContextIcon.labelsFrom(scenarioOutcome.getContext());
    }

    public static String labelForOutcome(TestOutcome outcome) {
        return ContextIcon.labelsFrom(outcome.getContext());
    }

    public static String forContext(String context) {
        if (context == null) {
            return "";
        }
        return String.format("<span class='context-icon'>%s</span>", Arrays.stream(context.split(",")).map(String::trim).map(ContextIcon::iconFor).collect(Collectors.joining(" ")));
    }

    private static String labelsFrom(String context) {
        if (context == null) {
            return "";
        }
        return Arrays.stream(context.split(",")).map(String::trim).map(item -> CONTEXT_TITLES.getOrDefault(item, (String)item)).collect(Collectors.joining(","));
    }

    public static String forOutcome(TestOutcome testOutcome) {
        return ContextIcon.forContext(testOutcome.getContext());
    }

    private static String iconFor(String contextName) {
        return ICON_CLASSES_FOR_COMMON_CONTEXTS.entrySet().stream().filter(entry -> contextName.toLowerCase().startsWith(((String)entry.getKey()).toLowerCase())).map(entry -> String.format("<i class='bi bi-%s' title='%s'></i>", entry.getValue(), CONTEXT_TITLES.getOrDefault(entry.getKey(), StringUtils.capitalize((String)((String)entry.getKey()))))).findFirst().orElse(ContextIcon.labelor(contextName));
    }

    private static String labelor(String contextName) {
        return CONTEXT_TITLES.containsKey(contextName) ? String.format("<i class='bi bi-%s' title='%s'></i>", ICON_CLASSES_FOR_COMMON_CONTEXTS.get(contextName), CONTEXT_TITLES.getOrDefault(contextName, contextName)) : contextName.toUpperCase();
    }

    static {
        ICON_CLASSES_FOR_COMMON_CONTEXTS.put("chrome", "browser-chrome");
        ICON_CLASSES_FOR_COMMON_CONTEXTS.put("firefox", "browser-firefox");
        ICON_CLASSES_FOR_COMMON_CONTEXTS.put("safari", "browser-safari");
        ICON_CLASSES_FOR_COMMON_CONTEXTS.put("ie", "browser-edge");
        ICON_CLASSES_FOR_COMMON_CONTEXTS.put("edge", "browser-edge");
        ICON_CLASSES_FOR_COMMON_CONTEXTS.put("linux", "ubuntu");
        ICON_CLASSES_FOR_COMMON_CONTEXTS.put("mac", "apple");
        ICON_CLASSES_FOR_COMMON_CONTEXTS.put("windows", "windows");
        ICON_CLASSES_FOR_COMMON_CONTEXTS.put("android", "android");
        ICON_CLASSES_FOR_COMMON_CONTEXTS.put("iphone", "apple");
        ICON_CLASSES_FOR_COMMON_CONTEXTS.put("ios", "apple");
        CONTEXT_TITLES = new HashMap<String, String>();
        CONTEXT_TITLES.put("chrome", "Chrome");
        CONTEXT_TITLES.put("firefox", "Firefox");
        CONTEXT_TITLES.put("safari", "Safari or WebKit");
        CONTEXT_TITLES.put("ie", "Microsoft Internet Explorer");
        CONTEXT_TITLES.put("edge", "Microsoft Edge");
        CONTEXT_TITLES.put("mac", "Mac OS X");
        CONTEXT_TITLES.put("iphone", "iPhone");
        CONTEXT_TITLES.put("ios", "iOS");
    }
}

