/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.requirements;

import java.util.List;
import java.util.Optional;
import net.serenitybdd.core.collect.NewList;
import net.thucydides.core.environment.SystemEnvironmentVariables;
import net.thucydides.core.requirements.BaseRequirementsService;
import net.thucydides.core.requirements.FileSystemRequirementsTagProvider;
import net.thucydides.core.requirements.ReleaseProvider;
import net.thucydides.core.requirements.RequirementAncestry;
import net.thucydides.core.requirements.RequirementsService;
import net.thucydides.core.requirements.RequirementsTagProvider;
import net.thucydides.core.requirements.RequirementsTree;
import net.thucydides.core.requirements.model.Requirement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemRequirementsService
extends BaseRequirementsService
implements RequirementsService {
    private static final Logger LOGGER = LoggerFactory.getLogger(RequirementsTagProvider.class);
    private final RequirementsTagProvider fileSystemRequirementsTagProvider;

    public FileSystemRequirementsService(String rootPath) {
        super(SystemEnvironmentVariables.currentEnvironmentVariables());
        this.fileSystemRequirementsTagProvider = new FileSystemRequirementsTagProvider(this.environmentVariables, rootPath);
    }

    @Override
    public List<Requirement> getRequirements() {
        if (this.requirements == null) {
            this.requirements = this.fileSystemRequirementsTagProvider.getRequirements();
            RequirementAncestry.addParentsTo(this.requirements);
            this.indexRequirements();
            LOGGER.trace("\nREQUIREMENTS HIERARCHY LOADED FROM THE FILE SYSTEM:\n" + RequirementsTree.from(this.requirements));
        }
        return this.requirements;
    }

    public List<RequirementsTagProvider> getRequirementsTagProviders() {
        return NewList.of(this.fileSystemRequirementsTagProvider);
    }

    @Override
    public Optional<ReleaseProvider> getReleaseProvider() {
        return Optional.empty();
    }
}

