/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.requirements.tree;

import com.google.common.base.Objects;
import java.util.Arrays;
import java.util.List;

public class Node
implements Comparable<Node> {
    private final String text;
    private String type;
    private final String href;
    private final List<Node> nodes;
    private final boolean selectable = false;
    private final List<String> tags;

    public Node(String text, String type, String href, String result, String childCount, List<Node> nodes) {
        this.text = text;
        this.type = type;
        this.href = href;
        this.nodes = nodes;
        this.tags = Arrays.asList(result, childCount);
    }

    public String getText() {
        return this.text;
    }

    public String getHref() {
        return this.href;
    }

    public List<Node> getNodes() {
        return this.nodes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Node node = (Node)o;
        return Objects.equal((Object)this.text, (Object)node.text) && Objects.equal((Object)this.href, (Object)node.href);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.text, this.href});
    }

    @Override
    public int compareTo(Node otherNode) {
        return this.text.compareTo(otherNode.text);
    }
}

