/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.requirements.model;

import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Optional;
import net.serenitybdd.core.collect.NewList;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.requirements.DefaultCapabilityTypes;
import net.thucydides.core.requirements.RootDirectory;
import net.thucydides.core.requirements.model.RequirementTypeAt;
import net.thucydides.core.util.EnvironmentVariables;

public class RequirementsConfiguration {
    public static final List<String> DEFAULT_CAPABILITY_TYPES = NewList.of("capability", "feature", "story");
    private static final String DEFAULT_ROOT_DIRECTORY = "stories";
    private final EnvironmentVariables environmentVariables;
    private Optional<Path> root;

    public RequirementsConfiguration(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
        this.root = RootDirectory.definedIn(environmentVariables).featuresOrStoriesRootDirectory();
    }

    public RequirementsConfiguration(EnvironmentVariables environmentVariables, String rootDirectory) {
        this.environmentVariables = environmentVariables;
        this.root = Optional.of(this.absolutePathOfDirectoryOnClasspath(rootDirectory));
    }

    private Path absolutePathOfDirectoryOnClasspath(String rootDirectory) {
        URL rootDirOnClasspath = this.getClass().getClassLoader().getResource(rootDirectory);
        Path absolutePath = Paths.get(rootDirectory, new String[0]);
        if (rootDirOnClasspath != null) {
            try {
                absolutePath = Paths.get(rootDirOnClasspath.toURI());
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("Fail to build absolute path of directory on classpath", e);
            }
        }
        return absolutePath;
    }

    public List<String> getRequirementTypes() {
        return DefaultCapabilityTypes.instance().getRequirementTypes(this.environmentVariables, this.root);
    }

    public String getDefaultRootDirectory() {
        if (ThucydidesSystemProperty.SERENITY_ANNOTATED_REQUIREMENTS_DIR.isDefinedIn(this.environmentVariables)) {
            return ThucydidesSystemProperty.SERENITY_ANNOTATED_REQUIREMENTS_DIR.from(this.environmentVariables);
        }
        return DEFAULT_ROOT_DIRECTORY;
    }

    public String getRequirementType(int level) {
        return RequirementTypeAt.level(level).in(this.getRequirementTypes());
    }

    public int startLevelForADepthOf(int requirementsDepth) {
        return Math.max(0, this.getRequirementTypes().size() - requirementsDepth);
    }
}

