/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.html;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import net.serenitybdd.core.time.Stopwatch;
import net.thucydides.core.reports.TestOutcomes;
import net.thucydides.core.reports.html.BaseReportingTask;
import net.thucydides.core.reports.html.FreemarkerContext;
import net.thucydides.core.reports.html.ReportNameProvider;
import net.thucydides.core.reports.html.ReportProperties;
import net.thucydides.core.reports.html.ReportingTask;
import net.thucydides.core.util.EnvironmentVariables;

public class TagTypeReportingTask
extends BaseReportingTask
implements ReportingTask {
    private static final String TAGTYPE_TEMPLATE_PATH = "freemarker/results-by-tagtype.ftl";
    private ReportNameProvider reportNameProvider;
    private final TestOutcomes testOutcomes;

    public TagTypeReportingTask(FreemarkerContext freemarker, EnvironmentVariables environmentVariables, File outputDirectory, ReportNameProvider reportNameProvider, TestOutcomes testOutcomes) {
        super(freemarker, environmentVariables, outputDirectory);
        this.reportNameProvider = reportNameProvider;
        this.testOutcomes = testOutcomes;
    }

    @Override
    public void generateReports() throws IOException {
        Stopwatch stopwatch = Stopwatch.started();
        this.generateTagTypeReportsFor(this.testOutcomes, this.reportNameProvider);
        for (String name : this.testOutcomes.getTagNames()) {
            this.generateTagTypeReportsFor(this.testOutcomes.withTag(name), new ReportNameProvider(name));
        }
        LOGGER.trace("Tag type reports generated: {} ms", (Object)stopwatch.stop());
    }

    private void generateTagTypeReportsFor(TestOutcomes testOutcomes, ReportNameProvider reportNameProvider) throws IOException {
        for (String tagType : testOutcomes.getTagTypes()) {
            this.generateTagTypeReport(testOutcomes, reportNameProvider, tagType);
        }
    }

    private void generateTagTypeReport(TestOutcomes testOutcomes, ReportNameProvider reportName, String tagType) throws IOException {
        TestOutcomes testOutcomesForTagType = testOutcomes.withTagType(tagType);
        Map<String, Object> context = this.freemarker.getBuildContext(testOutcomesForTagType, this.reportNameProvider, true);
        context.put("report", ReportProperties.forTagTypeResultsReport());
        context.put("tagType", tagType);
        String csvReport = reportName.forCSVFiles().forTagType(tagType);
        context.put("csvReport", csvReport);
        String report = reportName.forTagType(tagType);
        this.generateReportPage(context, TAGTYPE_TEMPLATE_PATH, report);
        this.generateCSVReportFor(testOutcomesForTagType, csvReport);
        System.out.println("TAG REPORT: " + report);
        System.out.println("TAG CSV REPORT: " + csvReport);
    }
}

