/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.html;

import com.google.common.base.Objects;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.serenitybdd.core.time.Stopwatch;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.model.ReportType;
import net.thucydides.core.model.Rule;
import net.thucydides.core.model.TestTag;
import net.thucydides.core.reports.ReportOptions;
import net.thucydides.core.reports.ScenarioOutcomeGroup;
import net.thucydides.core.reports.TestOutcomes;
import net.thucydides.core.reports.html.BaseReportingTask;
import net.thucydides.core.reports.html.Breadcrumbs;
import net.thucydides.core.reports.html.DuplicateRequirementNames;
import net.thucydides.core.reports.html.EvidenceData;
import net.thucydides.core.reports.html.FreemarkerContext;
import net.thucydides.core.reports.html.ReportNameProvider;
import net.thucydides.core.reports.html.ReportingTask;
import net.thucydides.core.reports.html.RequirementCounts;
import net.thucydides.core.reports.html.RequirementsFilter;
import net.thucydides.core.reports.html.ResultCounts;
import net.thucydides.core.reports.html.ScenarioResultCounts;
import net.thucydides.core.reports.html.TagFilter;
import net.thucydides.core.reports.html.TestOutcomeTimestamp;
import net.thucydides.core.reports.html.accessibility.ChartColorScheme;
import net.thucydides.core.requirements.JSONRequirementsTree;
import net.thucydides.core.requirements.RequirementsService;
import net.thucydides.core.requirements.model.Requirement;
import net.thucydides.core.requirements.reports.RequirementOutcome;
import net.thucydides.core.requirements.reports.RequirementsOutcomes;
import net.thucydides.core.requirements.reports.ScenarioOutcome;
import net.thucydides.core.requirements.reports.ScenarioOutcomes;
import net.thucydides.core.tags.BreadcrumbTagFilter;
import net.thucydides.core.tags.OutcomeTagFilter;
import net.thucydides.core.util.EnvironmentVariables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RequirementsOverviewReportingTask
extends BaseReportingTask
implements ReportingTask {
    private static final String DEFAULT_REQUIREMENTS_REPORT = "freemarker/requirements.ftl";
    private static final String REPORT_NAME = "capabilities.html";
    protected static final Logger LOGGER = LoggerFactory.getLogger(RequirementsOverviewReportingTask.class);
    private final ReportNameProvider reportNameProvider;
    private final RequirementsOutcomes requirementsOutcomes;
    private final RequirementsService requirementsService;
    private final TestOutcomes testOutcomes;
    private final String relativeLink;
    private final String reportName;
    private boolean asParentRequirement;
    private RequirementsFilter requirementsFilter;

    public RequirementsOverviewReportingTask(FreemarkerContext freemarker, EnvironmentVariables environmentVariables, File outputDirectory, ReportNameProvider reportNameProvider, RequirementsService requirementsService, RequirementsOutcomes requirementsOutcomes, String relativeLink, TestOutcomes testOutcomes) {
        super(freemarker, environmentVariables, outputDirectory);
        this.reportNameProvider = reportNameProvider;
        this.requirementsOutcomes = requirementsOutcomes;
        this.requirementsService = requirementsService;
        this.testOutcomes = testOutcomes;
        this.relativeLink = relativeLink;
        this.reportName = REPORT_NAME;
        this.asParentRequirement = true;
        this.requirementsFilter = new RequirementsFilter(environmentVariables);
    }

    public RequirementsOverviewReportingTask(FreemarkerContext freemarker, EnvironmentVariables environmentVariables, File outputDirectory, ReportNameProvider reportNameProvider, RequirementsService requirementsService, RequirementsOutcomes requirementsOutcomes, String relativeLink, TestOutcomes testOutcomes, String reportName) {
        super(freemarker, environmentVariables, outputDirectory);
        this.reportNameProvider = reportNameProvider;
        this.requirementsOutcomes = requirementsOutcomes;
        this.requirementsService = requirementsService;
        this.testOutcomes = testOutcomes;
        this.relativeLink = relativeLink;
        this.reportName = reportName;
        this.asParentRequirement = true;
        this.requirementsFilter = new RequirementsFilter(environmentVariables);
    }

    @Override
    public String reportName() {
        return this.reportName;
    }

    public RequirementsOverviewReportingTask asParentRequirement() {
        this.asParentRequirement = true;
        return this;
    }

    public RequirementsOverviewReportingTask asLeafRequirement() {
        this.asParentRequirement = false;
        return this;
    }

    @Override
    public void generateReports() throws IOException {
        List<Object> requirements;
        Stopwatch stopwatch = Stopwatch.started();
        Map<String, Object> context = this.freemarker.getBuildContext(this.requirementsOutcomes.getTestOutcomes(), this.reportNameProvider, true);
        String requirementsOverview = this.requirementsOutcomes.getOverview();
        OutcomeTagFilter outcomeFilter = new OutcomeTagFilter(this.environmentVariables);
        if (this.requirementsOutcomes.getParentRequirement().isPresent()) {
            requirements = Arrays.asList((Requirement)this.requirementsOutcomes.getParentRequirement().get());
            context.put("requirement", this.requirementsOutcomes.getParentRequirement().get());
            context.put("requirementTags", new TagFilter().removeHiddenTagsFrom((Collection)((Requirement)this.requirementsOutcomes.getParentRequirement().get()).getTags()));
        } else {
            requirements = this.requirementsOutcomes.getRequirementOutcomes().stream().map(RequirementOutcome::getRequirement).collect(Collectors.toList());
        }
        JSONRequirementsTree requirementsTree = JSONRequirementsTree.forRequirements((List)this.requirementsFilter.filteredByDisplayTag(requirements), (RequirementsOutcomes)this.requirementsOutcomes.filteredByDisplayTag());
        if (this.asParentRequirement) {
            requirementsTree = requirementsTree.asAParentRequirement();
        }
        RequirementsOutcomes filteredRequirementsOutcomes = this.requirementsOutcomes.filteredByDisplayTag();
        context.put("requirements", filteredRequirementsOutcomes);
        context.put("duplicateRequirementNamesPresent", DuplicateRequirementNames.presentIn(filteredRequirementsOutcomes));
        context.put("requirementsTree", requirementsTree.asString());
        context.put("requirementsOverview", requirementsOverview);
        context.put("prettyTables", ThucydidesSystemProperty.CUCUMBER_PRETTY_FORMAT_TABLES.booleanFrom(this.environmentVariables, Boolean.valueOf(false)));
        context.put("isLeafRequirement", requirementsTree.isALeafNode());
        context.put("requirementTypes", this.requirementsService.getRequirementTypes());
        TestOutcomes filteredTestOutcomes = this.requirementsOutcomes.getTestOutcomes().filteredByEnvironmentTags();
        context.put("colorScheme", ChartColorScheme.forEnvironment(this.environmentVariables));
        context.put("testOutcomes", filteredTestOutcomes);
        context.put("resultCounts", ResultCounts.forOutcomesIn((TestOutcomes)filteredTestOutcomes));
        context.put("requirementCounts", RequirementCounts.forOutcomesIn(this.requirementsOutcomes));
        context.put("allTestOutcomes", this.testOutcomes);
        context.put("timestamp", TestOutcomeTimestamp.from(filteredTestOutcomes));
        context.put("reportName", new ReportNameProvider(ReportNameProvider.NO_CONTEXT, ReportType.HTML, this.requirementsService));
        context.put("absoluteReportName", new ReportNameProvider(ReportNameProvider.NO_CONTEXT, ReportType.HTML, this.requirementsService));
        context.put("reportOptions", ReportOptions.forEnvironment((EnvironmentVariables)this.environmentVariables));
        context.put("relativeLink", this.relativeLink);
        context.put("evidence", EvidenceData.from(outcomeFilter.outcomesFilteredByTagIn(filteredTestOutcomes.getOutcomes())));
        this.requirementsOutcomes.getParentRequirement().map(parentRequirement -> context.put("currentTag", parentRequirement.asTag()));
        List scenarios = outcomeFilter.scenariosFilteredByTagIn(ScenarioOutcomes.from((RequirementsOutcomes)this.requirementsOutcomes));
        ArrayList<ScenarioOutcome> scenariosWithoutARule = new ArrayList<ScenarioOutcome>();
        HashMap scenarioOutcomeMap = new HashMap();
        for (ScenarioOutcome scenario : scenarios) {
            Rule rule = scenario.getRule();
            if (rule == null) {
                scenariosWithoutARule.add(scenario);
                continue;
            }
            if (!scenarioOutcomeMap.containsKey(rule)) {
                scenarioOutcomeMap.put(rule, new ArrayList());
            }
            ((List)scenarioOutcomeMap.get(rule)).add(scenario);
        }
        ArrayList<Object> scenarioGroups = new ArrayList<Object>();
        if (!scenariosWithoutARule.isEmpty()) {
            ScenarioOutcomeGroup scenarioGroup = new ScenarioOutcomeGroup(scenariosWithoutARule);
            requirements.stream().filter(requirement -> requirement.getBackground() != null).findFirst().ifPresent(requirement -> {
                scenarioGroup.setBackgroundTitle(requirement.getBackground().getTitle());
                scenarioGroup.setBackgroundDescription(requirement.getBackground().getDescription());
            });
            scenarioGroups.add(scenarioGroup);
        }
        for (Rule rule : scenarioOutcomeMap.keySet()) {
            scenarioGroups.add(new ScenarioOutcomeGroup(rule, (List)scenarioOutcomeMap.get(rule)));
        }
        List<ScenarioOutcome> executedScenarios = this.executedScenariosIn(scenarios);
        ScenarioResultCounts scenarioResultCounts = ScenarioResultCounts.forScenarios((List)scenarios);
        context.put("scenarioGroups", scenarioGroups);
        context.put("scenarioResults", scenarioResultCounts);
        context.put("requirementsResultData", scenarioResultCounts.byTypeFor(new String[]{"success", "pending", "ignored", "skipped", "aborted", "failure", "error", "compromised", "undefined"}));
        context.put("testCases", executedScenarios);
        context.put("automatedTestCases", this.automated(executedScenarios));
        context.put("manualTestCases", this.manual(executedScenarios));
        this.addBreadcrumbs(this.requirementsOutcomes, context, filteredTestOutcomes.getTags());
        this.generateReportPage(context, DEFAULT_REQUIREMENTS_REPORT, this.reportName);
        LOGGER.trace("Requirements report generated: {} in {} ms", (Object)this.reportName, (Object)stopwatch.stop());
    }

    private List<ScenarioOutcome> automated(List<ScenarioOutcome> executedScenariosIn) {
        return executedScenariosIn.stream().filter(scenarioOutcome -> scenarioOutcome.isManual() == false).collect(Collectors.toList());
    }

    private List<ScenarioOutcome> manual(List<ScenarioOutcome> executedScenariosIn) {
        return executedScenariosIn.stream().filter(ScenarioOutcome::isManual).collect(Collectors.toList());
    }

    private List<ScenarioOutcome> executedScenariosIn(List<ScenarioOutcome> scenarios) {
        return scenarios.stream().filter(scenarioOutcome -> !scenarioOutcome.isBackground()).filter(scenarioOutcome -> !scenarioOutcome.getName().isEmpty()).collect(Collectors.toList());
    }

    private List<ScenarioOutcome> backgroundScenariosIn(List<ScenarioOutcome> scenarios) {
        return scenarios.stream().filter(scenarioOutcome -> scenarioOutcome.isBackground()).filter(scenarioOutcome -> !scenarioOutcome.getName().isEmpty()).collect(Collectors.toList());
    }

    private void addBreadcrumbs(RequirementsOutcomes requirementsOutcomes, Map<String, Object> context, List<TestTag> allTags) {
        if (this.requirementsOutcomes.getParentRequirement().isPresent()) {
            context.put("breadcrumbs", Breadcrumbs.forRequirementsTag(((Requirement)this.requirementsOutcomes.getParentRequirement().get()).asTag()).fromTagsIn(allTags));
        } else {
            context.put("breadcrumbs", new BreadcrumbTagFilter().getRequirementBreadcrumbsFrom(requirementsOutcomes));
        }
    }

    public String toString() {
        return "Requirements report " + this.reportName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RequirementsOverviewReportingTask that = (RequirementsOverviewReportingTask)o;
        return Objects.equal((Object)this.reportName, (Object)that.reportName);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.reportName});
    }
}

