/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay;

import net.serenitybdd.core.eventbus.Broadcaster;
import net.serenitybdd.screenplay.Actor;
import net.serenitybdd.screenplay.BaseConsequence;
import net.serenitybdd.screenplay.Complaint;
import net.serenitybdd.screenplay.Question;
import net.serenitybdd.screenplay.QuestionDiagnostics;
import net.serenitybdd.screenplay.QuestionSubject;
import net.serenitybdd.screenplay.events.ActorAsksQuestion;
import net.thucydides.core.steps.StepEventBus;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;

public class BooleanQuestionConsequence<T>
extends BaseConsequence<T> {
    private final Question<Boolean> question;
    private final String subject;

    public BooleanQuestionConsequence(Question<Boolean> actual) {
        this.question = actual;
        this.subject = QuestionSubject.fromClass(actual.getClass()).andQuestion(actual).subject();
    }

    @Override
    public void evaluateFor(Actor actor) {
        if (this.thisStepShouldBeIgnored() && !StepEventBus.getEventBus().softAssertsActive()) {
            return;
        }
        Broadcaster.getEventBus().post((Object)new ActorAsksQuestion(this.question));
        try {
            MatcherAssert.assertThat((String)this.reason(), (Object)this.question.answeredBy(actor), (Matcher)Matchers.is((Object)true));
        }
        catch (Throwable actualError) {
            this.throwComplaintTypeErrorIfSpecified(this.errorFrom(actualError));
            this.throwDiagosticErrorIfProvided(this.errorFrom(actualError));
            throw actualError;
        }
    }

    private String reason() {
        return "Expected " + QuestionSubject.fromClass(this.question.getClass());
    }

    private void throwDiagosticErrorIfProvided(Error actualError) {
        if (this.question instanceof QuestionDiagnostics) {
            throw Complaint.from(((QuestionDiagnostics)((Object)this.question)).onError(), actualError);
        }
    }

    public String toString() {
        return String.format("Then %s", this.subject);
    }
}

