/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay;

import net.serenitybdd.core.eventbus.Broadcaster;
import net.serenitybdd.screenplay.Actor;
import net.serenitybdd.screenplay.BaseConsequence;
import net.serenitybdd.screenplay.Complaint;
import net.serenitybdd.screenplay.Question;
import net.serenitybdd.screenplay.QuestionDiagnostics;
import net.serenitybdd.screenplay.QuestionSubject;
import net.serenitybdd.screenplay.events.ActorAsksQuestion;
import net.serenitybdd.screenplay.formatting.StripRedundantTerms;
import net.thucydides.core.steps.StepEventBus;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;

public class QuestionConsequence<T>
extends BaseConsequence<T> {
    private final Question<T> question;
    private final Matcher<T> expected;
    private final String subject;

    public QuestionConsequence(Question<T> actual, Matcher<T> expected) {
        this.question = actual;
        this.expected = expected;
        this.subject = QuestionSubject.fromClass(actual.getClass()).andQuestion(actual).subject();
    }

    @Override
    public void evaluateFor(Actor actor) {
        if (this.thisStepShouldBeIgnored() && !StepEventBus.getEventBus().softAssertsActive()) {
            return;
        }
        Broadcaster.getEventBus().post((Object)new ActorAsksQuestion(this.question));
        try {
            MatcherAssert.assertThat(this.question.answeredBy(actor), this.expected);
        }
        catch (Throwable actualError) {
            this.throwComplaintTypeErrorIfSpecified(this.errorFrom(actualError));
            this.throwDiagosticErrorIfProvided(this.errorFrom(actualError));
            throw actualError;
        }
    }

    private void throwDiagosticErrorIfProvided(Error actualError) {
        if (this.question instanceof QuestionDiagnostics) {
            throw Complaint.from(((QuestionDiagnostics)((Object)this.question)).onError(), actualError);
        }
    }

    public String toString() {
        String expectedExpression = StripRedundantTerms.from(this.expected.toString());
        return String.format("Then %s should be %s", this.subject, expectedExpression);
    }
}

