/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.serenitybdd.core.PendingStepException;
import net.serenitybdd.core.Serenity;
import net.serenitybdd.core.SkipNested;
import net.serenitybdd.core.eventbus.Broadcaster;
import net.serenitybdd.screenplay.Ability;
import net.serenitybdd.screenplay.Consequence;
import net.serenitybdd.screenplay.ConsequenceCheckReporter;
import net.serenitybdd.screenplay.ConsequenceListener;
import net.serenitybdd.screenplay.ErrorTally;
import net.serenitybdd.screenplay.EventBusInterface;
import net.serenitybdd.screenplay.Performable;
import net.serenitybdd.screenplay.PerformedTaskTally;
import net.serenitybdd.screenplay.PerformsTasks;
import net.serenitybdd.screenplay.Question;
import net.serenitybdd.screenplay.RefersToActor;
import net.serenitybdd.screenplay.events.ActorBeginsConsequenceCheckEvent;
import net.serenitybdd.screenplay.events.ActorBeginsPerformanceEvent;
import net.serenitybdd.screenplay.events.ActorEndsConsequenceCheckEvent;
import net.serenitybdd.screenplay.events.ActorEndsPerformanceEvent;
import net.serenitybdd.screenplay.events.ActorPerforms;
import net.serenitybdd.screenplay.exceptions.IgnoreStepException;
import net.serenitybdd.screenplay.facts.Fact;
import net.serenitybdd.screenplay.facts.FactLifecycleListener;
import net.thucydides.core.annotations.Pending;
import net.thucydides.core.steps.ExecutedStepDescription;
import net.thucydides.core.steps.StepEventBus;
import net.thucydides.core.steps.StepListener;

public class Actor
implements PerformsTasks,
SkipNested {
    private final String name;
    private final PerformedTaskTally taskTally = new PerformedTaskTally();
    private EventBusInterface eventBusInterface = new EventBusInterface();
    private ConsequenceListener consequenceListener = new ConsequenceListener(this.eventBusInterface);
    private String description;
    private Map<String, Object> notepad = new HashMap<String, Object>();
    private Map<Class, Ability> abilities = new HashMap<Class, Ability>();
    private String preferredPronoun;

    public Actor(String name) {
        this.name = name;
    }

    public String toString() {
        return this.getNameOrPronoun();
    }

    public static Actor named(String name) {
        EventBusInterface.castActor(name);
        return new Actor(name);
    }

    public Actor describedAs(String description) {
        this.description = description;
        this.assignDescriptionToActor(description);
        return this;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getNameOrPronoun() {
        return this.preferredPronoun != null ? this.preferredPronoun : this.name;
    }

    public <T extends Ability> Actor can(T doSomething) {
        if (doSomething instanceof RefersToActor) {
            ((RefersToActor)((Object)doSomething)).asActor(this);
        }
        this.abilities.put(doSomething.getClass(), doSomething);
        this.eventBusInterface.assignAbilityToActor(this, doSomething.toString());
        return this;
    }

    public <T extends Ability> Actor whoCan(T doSomething) {
        return this.can(doSomething);
    }

    public <T extends Ability> T abilityTo(Class<? extends T> doSomething) {
        return (T)this.abilities.get(doSomething);
    }

    public <T extends Ability> T usingAbilityTo(Class<? extends T> doSomething) {
        return this.abilityTo(doSomething);
    }

    public final void entersTheScene() {
    }

    public final void has(Performable ... todos) {
        this.attemptsTo(todos);
    }

    public final void has(Fact ... facts) {
        Arrays.stream(facts).forEach(fact -> {
            fact.setup(this);
            this.eventBusInterface.assignFactToActor(this, fact.toString());
            StepEventBus.getEventBus().registerListener((StepListener)new FactLifecycleListener(this, (Fact)fact));
        });
    }

    public final void wasAbleTo(Performable ... todos) {
        this.attemptsTo(todos);
    }

    public final void attemptsTo(Performable ... tasks) {
        this.beginPerformance();
        for (Performable task : tasks) {
            this.perform(task);
        }
        this.endPerformance();
    }

    @Override
    public <ANSWER> ANSWER asksFor(Question<ANSWER> question) {
        return question.answeredBy(this);
    }

    private <T extends Performable> void perform(T todo) {
        if (this.isPending(todo)) {
            StepEventBus.getEventBus().stepPending();
        }
        try {
            this.notifyPerformanceOf(todo);
            this.taskTally.newTask();
            this.performTask(todo);
            if (this.anOutOfStepErrorOccurred()) {
                this.eventBusInterface.mergePreviousStep();
            }
        }
        catch (Throwable exception) {
            if (!this.pendingOrIgnore(exception)) {
                this.eventBusInterface.reportStepFailureFor(todo, exception);
            }
            if (Serenity.shouldThrowErrorsImmediately() || this.isAnAssumptionFailure(exception)) {
                throw exception;
            }
        }
        finally {
            this.eventBusInterface.updateOverallResult();
        }
    }

    private <T extends Performable> void performTask(T todo) {
        if (!StepEventBus.getEventBus().currentTestIsSuspended()) {
            todo.performAs((Actor)this);
        }
    }

    private <T extends Performable> void notifyPerformanceOf(T todo) {
        Broadcaster.getEventBus().post((Object)new ActorPerforms(todo));
    }

    private <T extends Performable> boolean isPending(T todo) {
        Method performAs = this.getPerformAsForClass(todo.getClass().getSuperclass()).orElse(this.getPerformAsForClass(todo.getClass()).orElse(null));
        return performAs != null && performAs.getAnnotation(Pending.class) != null;
    }

    private Optional<Method> getPerformAsForClass(Class taskClass) {
        try {
            return Optional.of(taskClass.getMethod("performAs", Actor.class));
        }
        catch (NoSuchMethodException e) {
            return Optional.empty();
        }
    }

    private boolean pendingOrIgnore(Throwable exception) {
        return exception instanceof IgnoreStepException || exception instanceof PendingStepException;
    }

    private boolean isAnAssumptionFailure(Throwable e) {
        return e.getClass().getSimpleName().contains("Assumption");
    }

    public final void can(Consequence ... consequences) {
        this.should(consequences);
    }

    public final void should(String groupStepName, Consequence ... consequences) {
        try {
            String groupTitle = this.injectActorInto(groupStepName);
            StepEventBus.getEventBus().stepStarted(ExecutedStepDescription.withTitle((String)groupTitle));
            this.should(consequences);
        }
        catch (Throwable error) {
            throw error;
        }
        finally {
            StepEventBus.getEventBus().stepFinished();
        }
    }

    private String injectActorInto(String groupStepName) {
        return groupStepName.replaceAll("\\{0\\}", this.toString());
    }

    public final void should(Consequence ... consequences) {
        ErrorTally errorTally = new ErrorTally(this.eventBusInterface);
        this.startConsequenceCheck();
        for (Consequence consequence : consequences) {
            this.check(consequence, errorTally);
        }
        this.endConsequenceCheck();
        errorTally.reportAnyErrors();
    }

    private boolean anOutOfStepErrorOccurred() {
        if (this.eventBusInterface.aStepHasFailedInTheCurrentExample()) {
            return this.eventBusInterface.getRunningStepCount() > this.taskTally.getPerformedTaskCount();
        }
        return false;
    }

    private <T> void check(Consequence<T> consequence, ErrorTally errorTally) {
        ConsequenceCheckReporter reporter = new ConsequenceCheckReporter(this.eventBusInterface, consequence);
        try {
            reporter.startQuestion();
            if (this.eventBusInterface.shouldIgnoreConsequences()) {
                reporter.reportStepIgnored();
            } else {
                consequence.evaluateFor(this);
                reporter.reportStepFinished();
            }
        }
        catch (IgnoreStepException e) {
            reporter.reportStepIgnored();
        }
        catch (Throwable e) {
            errorTally.recordError(consequence, e);
        }
    }

    public <ANSWER> void remember(String key, Question<ANSWER> question) {
        ANSWER answer = this.asksFor(question);
        this.notepad.put(key, answer);
    }

    public void remember(String key, Object value) {
        this.notepad.put(key, value);
    }

    public <T> T recall(String key) {
        return (T)this.notepad.get(key);
    }

    public <T> T sawAsThe(String key) {
        return this.recall(key);
    }

    public <T> T gaveAsThe(String key) {
        return this.recall(key);
    }

    private void beginPerformance() {
        Broadcaster.getEventBus().post((Object)new ActorBeginsPerformanceEvent(this.name));
    }

    private void endPerformance() {
        Broadcaster.getEventBus().post((Object)new ActorEndsPerformanceEvent(this.name));
    }

    private void startConsequenceCheck() {
        this.consequenceListener.beginConsequenceCheck();
        Broadcaster.getEventBus().post((Object)new ActorBeginsConsequenceCheckEvent(this.name));
    }

    private void endConsequenceCheck() {
        this.consequenceListener.endConsequenceCheck();
        Broadcaster.getEventBus().post((Object)new ActorEndsConsequenceCheckEvent(this.name));
    }

    public Actor usingPronoun(String pronoun) {
        this.preferredPronoun = pronoun;
        return this;
    }

    public Actor withNoPronoun() {
        this.preferredPronoun = null;
        return this;
    }

    public void assignDescriptionToActor(String description) {
        StepEventBus.getEventBus().getBaseStepListener().latestTestOutcome().ifPresent(testOutcome -> testOutcome.assignDescriptionToActor(this.getName(), description));
    }
}

