/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay;

import com.rits.cloning.Cloner;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Optional;
import net.serenitybdd.core.steps.Instrumented;
import net.serenitybdd.screenplay.Performable;
import net.serenitybdd.screenplay.TaskInstantiationException;
import net.thucydides.core.annotations.Step;

public class InstrumentedTask {
    public static <T extends Performable> T of(T task) {
        if (InstrumentedTask.isInstrumented(task) || !InstrumentedTask.shouldInstrument(task)) {
            return task;
        }
        return (T)InstrumentedTask.instrumentedCopyOf(task, task.getClass());
    }

    private static <T extends Performable> boolean shouldInstrument(T task) {
        Optional<Method> performAs = Arrays.stream(task.getClass().getMethods()).filter(method -> method.getName().equals("performAs")).findFirst();
        return performAs.isPresent() && performAs.get().getAnnotation(Step.class) != null;
    }

    private static Performable instrumentedCopyOf(Performable task, Class taskClass) {
        Performable instrumentedTask = null;
        try {
            instrumentedTask = (Performable)Instrumented.instanceOf((Class)taskClass).newInstance();
        }
        catch (IllegalArgumentException missingDefaultConstructor) {
            throw new TaskInstantiationException("Could not instantiate " + taskClass + ". If you are not instrumenting a Task class explicitly you need to give the class a default constructor.");
        }
        Cloner cloner = new Cloner();
        cloner.copyPropertiesOfInheritedClass((Object)task, (Object)instrumentedTask);
        return instrumentedTask;
    }

    private static boolean isInstrumented(Performable task) {
        return task.getClass().getSimpleName().contains("EnhancerByCGLIB");
    }
}

