/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.distribution.jgroups;

import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.Status;
import net.sf.ehcache.distribution.CacheManagerPeerProvider;
import net.sf.ehcache.distribution.CachePeer;
import net.sf.ehcache.distribution.jgroups.JGroupEventMessage;
import net.sf.ehcache.distribution.jgroups.JGroupSerializable;
import org.jgroups.Address;
import org.jgroups.blocks.NotificationBus;
import org.jgroups.stack.IpAddress;

public class JGroupManager
implements NotificationBus.Consumer,
CachePeer,
CacheManagerPeerProvider {
    private static final Logger LOG = Logger.getLogger(JGroupManager.class.getName());
    private static final int CHUNK_SIZE = 100;
    private NotificationBus notificationBus;
    private CacheManager cacheManager;

    public JGroupManager(CacheManager cacheManager, String connect) {
        try {
            this.cacheManager = cacheManager;
            this.notificationBus = new NotificationBus("EH_CACHE", connect);
            this.notificationBus.start();
            this.notificationBus.getChannel().setOpt(3, (Object)Boolean.FALSE);
            this.notificationBus.setConsumer((NotificationBus.Consumer)this);
            LOG.info("JGroupManager started. address is " + this.notificationBus.getLocalAddress());
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public Serializable getCache() {
        return null;
    }

    private void handleJGroupNotification(JGroupSerializable e) {
        Cache cache = this.cacheManager.getCache(e.getCacheName());
        if (cache != null) {
            if (e.getEvent() == 1 && cache.getQuiet(e.getKey()) != null) {
                cache.remove(e.getKey(), true);
            } else if (e.getEvent() == 0) {
                cache.put(new Element(e.getKey(), e.getValue()), true);
            } else if (e.getEvent() == 11) {
                LOG.fine("received bootstrap reply: cache=" + e.getCacheName() + ", key=" + e.getKey());
                cache.put(new Element(e.getKey(), e.getValue()), true);
            } else if (e.getEvent() == 3) {
                LOG.fine("remove all");
                cache.removeAll(true);
            } else if (e.getEvent() == 10) {
                this.sendBootstrapResponse(e, cache);
            }
        }
    }

    private void sendBootstrapResponse(JGroupSerializable e, Cache cache) {
        IpAddress requestAddress = (IpAddress)e.getKey();
        LOG.fine("received bootstrap request from " + requestAddress + ", cache=" + e.getCacheName());
        List keys = cache.getKeys();
        if (keys != null && keys.size() > 0) {
            ArrayList<JGroupEventMessage> messageList = new ArrayList<JGroupEventMessage>();
            for (Object key : keys) {
                Element element = cache.get(key);
                JGroupEventMessage jGroupEventMessage = new JGroupEventMessage(11, (Serializable)key, element, (Ehcache)cache, cache.getName());
                messageList.add(jGroupEventMessage);
                if (messageList.size() != 100) continue;
                this.sendResponseChunk(cache, requestAddress, messageList);
                messageList = new ArrayList();
            }
            if (messageList.size() > 0) {
                this.sendResponseChunk(cache, requestAddress, messageList);
            }
        } else {
            LOG.log(Level.FINE, "no keys to reply to " + requestAddress + " to boot cache " + cache.getName());
        }
    }

    private void sendResponseChunk(Cache cache, IpAddress requestAddress, List events) {
        LOG.fine("reply " + events.size() + " elements to " + requestAddress + " to boot cache " + cache.getName());
        try {
            this.send((Address)requestAddress, events);
        }
        catch (RemoteException e1) {
            LOG.log(Level.SEVERE, "error repling to " + requestAddress, e1);
        }
    }

    public void handleNotification(Serializable arg0) {
        if (arg0 instanceof JGroupSerializable) {
            this.handleJGroupNotification((JGroupSerializable)arg0);
        } else if (arg0 instanceof List) {
            List l = (List)((Object)arg0);
            for (int i = 0; i < l.size(); ++i) {
                Object obj = l.get(i);
                if (!(obj instanceof JGroupSerializable)) continue;
                this.handleJGroupNotification((JGroupSerializable)obj);
            }
        }
    }

    public void memberJoined(Address arg0) {
        LOG.fine("joined:" + arg0);
    }

    public void memberLeft(Address arg0) {
        LOG.fine("left:" + arg0);
    }

    public List getElements(List keys) throws RemoteException {
        return null;
    }

    public String getGuid() throws RemoteException {
        return null;
    }

    public List getKeys() throws RemoteException {
        return null;
    }

    public String getName() throws RemoteException {
        return null;
    }

    public Element getQuiet(Serializable key) throws RemoteException {
        return null;
    }

    public String getUrl() throws RemoteException {
        return null;
    }

    public String getUrlBase() throws RemoteException {
        return null;
    }

    public void put(Element element) throws IllegalArgumentException, IllegalStateException, RemoteException {
    }

    public boolean remove(Serializable key) throws IllegalStateException, RemoteException {
        return false;
    }

    public void removeAll() throws RemoteException, IllegalStateException {
    }

    private JGroupSerializable wrapMessage(JGroupEventMessage msg) {
        Serializable value = msg.getElement() == null ? null : msg.getElement().getValue();
        return new JGroupSerializable(msg.getEvent(), msg.getSerializableKey(), value, msg.getCacheName());
    }

    public void send(List eventMessages) throws RemoteException {
        this.send(null, eventMessages);
    }

    public void send(Address address, List eventMessages) throws RemoteException {
        if (eventMessages.size() == 1) {
            this.notificationBus.sendNotification((Serializable)this.wrapMessage((JGroupEventMessage)((Object)eventMessages.get(0))));
            return;
        }
        ArrayList<JGroupSerializable> msg = new ArrayList<JGroupSerializable>();
        for (JGroupEventMessage m : eventMessages) {
            msg.add(this.wrapMessage(m));
        }
        try {
            this.notificationBus.sendNotification(address, msg);
        }
        catch (Throwable t) {
            throw new RemoteException(t.getMessage());
        }
    }

    public Status getStatus() {
        if (this.notificationBus == null) {
            return Status.STATUS_UNINITIALISED;
        }
        if (this.notificationBus.getChannel() == null) {
            return Status.STATUS_SHUTDOWN;
        }
        return Status.STATUS_ALIVE;
    }

    public void dispose() throws CacheException {
        if (this.notificationBus != null) {
            try {
                this.notificationBus.stop();
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "Error occured while closing Manager:", e);
            }
        }
    }

    public long getTimeForClusterToForm() {
        return 0L;
    }

    public String getScheme() {
        return "JGroups";
    }

    public void init() {
    }

    public List listRemoteCachePeers(Ehcache cache) throws CacheException {
        ArrayList<JGroupManager> a = new ArrayList<JGroupManager>();
        a.add(this);
        return a;
    }

    public void registerPeer(String rmiUrl) {
    }

    public void unregisterPeer(String rmiUrl) {
    }

    public List getBusMembership() {
        return this.notificationBus.getMembership();
    }

    public Address getBusLocalAddress() {
        return this.notificationBus.getLocalAddress();
    }
}

