/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.distribution.jgroups;

import java.util.Properties;
import java.util.logging.Logger;
import net.sf.ehcache.bootstrap.BootstrapCacheLoader;
import net.sf.ehcache.bootstrap.BootstrapCacheLoaderFactory;
import net.sf.ehcache.distribution.jgroups.JGroupsBootstrapCacheLoader;
import net.sf.ehcache.util.PropertyUtil;

public class JGroupsBootstrapCacheLoaderFactory
extends BootstrapCacheLoaderFactory {
    public static final String BOOTSTRAP_ASYNCHRONOUSLY = "bootstrapAsynchronously";
    public static final String MAXIMUM_CHUNK_SIZE_BYTES = "maximumChunkSizeBytes";
    protected static final int DEFAULT_MAXIMUM_CHUNK_SIZE_BYTES = 5000000;
    protected static final int ONE_HUNDRED_MB = 100000000;
    protected static final int FIVE_KB = 5000;
    private static final Logger LOG = Logger.getLogger(JGroupsBootstrapCacheLoaderFactory.class.getName());

    public BootstrapCacheLoader createBootstrapCacheLoader(Properties properties) {
        boolean bootstrapAsynchronously = this.extractAndValidateBootstrapAsynchronously(properties);
        int maximumChunkSizeBytes = this.extractMaximumChunkSizeBytes(properties);
        return new JGroupsBootstrapCacheLoader(bootstrapAsynchronously, maximumChunkSizeBytes);
    }

    protected int extractMaximumChunkSizeBytes(Properties properties) {
        int maximumChunkSizeBytes;
        block5: {
            maximumChunkSizeBytes = 0;
            String maximumChunkSizeBytesString = PropertyUtil.extractAndLogProperty((String)MAXIMUM_CHUNK_SIZE_BYTES, (Properties)properties);
            if (maximumChunkSizeBytesString != null) {
                try {
                    int maximumChunkSizeBytesCandidate = Integer.parseInt(maximumChunkSizeBytesString);
                    if (maximumChunkSizeBytesCandidate < 5000 || maximumChunkSizeBytesCandidate > 100000000) {
                        LOG.warning("Trying to set the chunk size to an unreasonable number. Using the default instead.");
                        maximumChunkSizeBytes = 5000000;
                        break block5;
                    }
                    maximumChunkSizeBytes = maximumChunkSizeBytesCandidate;
                }
                catch (NumberFormatException e) {
                    LOG.warning("Number format exception trying to set chunk size. Using the default instead.");
                    maximumChunkSizeBytes = 5000000;
                }
            } else {
                maximumChunkSizeBytes = 5000000;
            }
        }
        return maximumChunkSizeBytes;
    }

    protected boolean extractAndValidateBootstrapAsynchronously(Properties properties) {
        String bootstrapAsynchronouslyString = PropertyUtil.extractAndLogProperty((String)BOOTSTRAP_ASYNCHRONOUSLY, (Properties)properties);
        boolean bootstrapAsynchronously = bootstrapAsynchronouslyString != null ? PropertyUtil.parseBoolean((String)bootstrapAsynchronouslyString) : true;
        if (!bootstrapAsynchronously) {
            throw new UnsupportedOperationException("JGroups bootstrap does not support synchronous bootstrap.");
        }
        return bootstrapAsynchronously;
    }
}

