/*
 * Decompiled with CFR 0.152.
 */
package gnu.hylafax.util;

import gnu.hylafax.Client;
import gnu.hylafax.HylaFAXClient;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HylaFAXClientTest
extends HylaFAXClient {
    private static final Log log = LogFactory.getLog((Class)Client.class);

    public static void main(String[] Arguments) {
        HylaFAXClient c = new HylaFAXClient();
        try {
            int counter;
            int counter2;
            c.open("localhost");
            c.noop();
            c.setPassive(true);
            c.user("fax");
            c.type('I');
            System.out.println("current directory is: " + c.pwd());
            c.cwd("docq");
            System.out.println("current directory is: " + c.pwd());
            c.cdup();
            System.out.println("current directory is: " + c.pwd());
            System.out.println("idle timer set to " + c.idle() + " seconds.");
            c.idle(1800L);
            System.out.println("idle timer set to " + c.idle() + " seconds.");
            System.out.println("job format: " + c.jobfmt());
            c.jobfmt("%-4j");
            System.out.println("job format: " + c.jobfmt());
            c.stru('F');
            c.stru('T');
            c.stru('F');
            String filename = "test.ps";
            FileInputStream file = new FileInputStream(filename);
            String f = c.putTemporary((InputStream)file);
            System.out.println("filename= " + f);
            long local_size = new RandomAccessFile(filename, "r").length();
            long remote_size = c.size(f);
            System.out.println(filename + " local size is " + local_size);
            System.out.println(f + " remote size is " + remote_size);
            FileOutputStream out_file = new FileOutputStream(filename + ".retr");
            c.get(f, (OutputStream)out_file);
            local_size = new RandomAccessFile(filename + ".retr", "r").length();
            System.out.println(filename + ".retr size is " + local_size);
            FileOutputStream zip_file = new FileOutputStream(filename + ".gz");
            c.mode('Z');
            c.get(f, (OutputStream)zip_file);
            local_size = new RandomAccessFile(filename + ".gz", "r").length();
            System.out.println(filename + ".gz size is " + local_size);
            c.mode('S');
            Vector files = c.getList();
            for (counter2 = 0; counter2 < files.size(); ++counter2) {
                System.out.println((String)files.elementAt(counter2));
            }
            files = c.getList("/tmp");
            for (counter2 = 0; counter2 < files.size(); ++counter2) {
                System.out.println((String)files.elementAt(counter2));
            }
            c.mode('Z');
            files = c.getList("/tmp");
            for (counter2 = 0; counter2 < files.size(); ++counter2) {
                System.out.println((String)files.elementAt(counter2));
            }
            c.mode('S');
            try {
                c.getList("/joey-joe-joe-jr.shabba-do");
                System.out.println("ERROR: file not found was expected");
            }
            catch (FileNotFoundException fnfe) {
                System.out.println("GOOD: file not found, as expected");
            }
            files = c.getList();
            for (counter2 = 0; counter2 < files.size(); ++counter2) {
                System.out.println((String)files.elementAt(counter2));
            }
            files = c.getNameList("/tmp");
            for (counter2 = 0; counter2 < files.size(); ++counter2) {
                System.out.println((String)files.elementAt(counter2));
            }
            files = c.getNameList("/tmp");
            for (counter2 = 0; counter2 < files.size(); ++counter2) {
                System.out.println((String)files.elementAt(counter2));
            }
            c.mode('Z');
            files = c.getNameList("/tmp");
            for (counter2 = 0; counter2 < files.size(); ++counter2) {
                System.out.println((String)files.elementAt(counter2));
            }
            c.mode('S');
            files = c.getNameList();
            for (counter2 = 0; counter2 < files.size(); ++counter2) {
                System.out.println((String)files.elementAt(counter2));
            }
            String system = c.syst();
            System.out.println("system type: " + system + ".");
            c.noop();
            Vector status = c.stat();
            for (counter = 0; counter < status.size(); ++counter) {
                System.out.println(status.elementAt(counter));
            }
            status = c.stat("docq");
            for (counter = 0; counter < status.size(); ++counter) {
                System.out.println(status.elementAt(counter));
            }
            try {
                status = c.stat("joey-joe-joe-junior-shabba-do");
                for (counter = 0; counter < status.size(); ++counter) {
                    System.out.println(status.elementAt(counter));
                }
            }
            catch (FileNotFoundException fnfe) {
                System.out.println("GOOD: file not found.  this is what we expected");
            }
            c.noop();
            c.quit();
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        System.out.println("main: end");
    }
}

