/*
 * Decompiled with CFR 0.152.
 */
package gnu.hylafax.util;

import gnu.getopt.Getopt;
import gnu.hylafax.job.ReceiveEvent;
import gnu.hylafax.job.ReceiveListener;
import gnu.hylafax.job.SendAndReceiveNotifier;
import gnu.hylafax.job.SendEvent;
import gnu.hylafax.job.SendListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Properties;

public class Notifier
extends SendAndReceiveNotifier {
    public static final boolean OP_SEND = true;
    public static final boolean OP_RECEIVE = false;
    public static final String KEY_PROPERTIES = "notifier.properties";

    public static void main(String[] arguments) throws ClassNotFoundException, InstantiationException, IllegalAccessException, FileNotFoundException, IOException {
        char opt;
        String file = null;
        String reason = null;
        String time = null;
        String nextAttempt = null;
        Class<?> klass = null;
        long jobid = -1L;
        String commid = null;
        String message = null;
        String modem = null;
        String cidname = null;
        String cidnumber = null;
        boolean OP = true;
        Getopt g = new Getopt("Notifier", arguments, "SRf:r:t:n:c:j:M:m:i:I:N");
        block15: while ((short)(opt = (char)g.getopt()) != -1) {
            switch (opt) {
                case 'f': {
                    file = g.getOptarg();
                    continue block15;
                }
                case 'r': {
                    reason = g.getOptarg();
                    continue block15;
                }
                case 't': {
                    time = g.getOptarg();
                    continue block15;
                }
                case 'n': {
                    nextAttempt = g.getOptarg();
                    continue block15;
                }
                case 'c': {
                    klass = Class.forName(g.getOptarg());
                    continue block15;
                }
                case 'j': {
                    jobid = Long.parseLong(g.getOptarg());
                    continue block15;
                }
                case 'm': {
                    modem = g.getOptarg();
                    continue block15;
                }
                case 'M': {
                    message = g.getOptarg();
                    continue block15;
                }
                case 'i': {
                    commid = g.getOptarg();
                    continue block15;
                }
                case 'N': {
                    cidname = g.getOptarg();
                    continue block15;
                }
                case 'I': {
                    cidnumber = g.getOptarg();
                    continue block15;
                }
                case 'R': {
                    OP = false;
                    continue block15;
                }
                case 'S': {
                    OP = true;
                    continue block15;
                }
            }
            Notifier.usage(System.err);
            System.exit(-1);
        }
        File props = new File(System.getProperty(KEY_PROPERTIES));
        if (props.exists() && props.canRead()) {
            Properties p = new Properties(System.getProperties());
            p.load(new FileInputStream(props));
            System.setProperties(p);
        }
        if (OP) {
            Notifier.notifySendListeners(klass, jobid, file, reason, time, nextAttempt);
        } else {
            Notifier.notifyReceiveListeners(klass, file, modem, commid, message, cidnumber, cidname);
        }
    }

    public static void notifySendListeners(Class klass, long jobid, String file, String reason, String time, String nextAttempt) throws InstantiationException, IllegalAccessException {
        if (file == null || "".equals(file)) {
            Notifier.usage(System.err);
            System.exit(-1);
        }
        if (reason == null || "".equals(reason)) {
            Notifier.usage(System.err);
            System.exit(-1);
        }
        if (time == null || "".equals(time)) {
            Notifier.usage(System.err);
            System.exit(-1);
        }
        if (reason.equals("requeued") && (nextAttempt == null || "".equals(nextAttempt))) {
            Notifier.usage(System.err);
            System.exit(-1);
        }
        if (klass == null) {
            Notifier.usage(System.err);
            System.exit(-1);
        }
        if (jobid < 0L) {
            Notifier.usage(System.err);
            System.exit(-1);
        }
        SendEvent event = new SendEvent();
        event.setReason(reason);
        event.setFilename(file);
        event.setElapsedTime(time);
        event.setNextAttempt(nextAttempt);
        event.setJobId(jobid);
        SendListener l = (SendListener)klass.newInstance();
        Notifier n = new Notifier();
        n.addSendListener(l);
        n.notifySendListeners(event);
    }

    public static void notifyReceiveListeners(Class klass, String file, String modem, String commid, String message, String cidnumber, String cidname) throws InstantiationException, IllegalAccessException {
        if (file == null || "".equals(file)) {
            Notifier.usage(System.err);
            System.exit(-1);
        }
        if (modem == null || "".equals(modem)) {
            Notifier.usage(System.err);
            System.exit(-1);
        }
        if (commid == null || "".equals(commid)) {
            Notifier.usage(System.err);
            System.exit(-1);
        }
        if (klass == null) {
            Notifier.usage(System.err);
            System.exit(-1);
        }
        ReceiveEvent event = new ReceiveEvent();
        event.setFilename(file);
        event.setModem(modem);
        event.setCommunicationIdentifier(commid);
        event.setMessage(message);
        event.setCidNumber(cidnumber);
        event.setCidName(cidname);
        ReceiveListener l = (ReceiveListener)klass.newInstance();
        Notifier n = new Notifier();
        n.addReceiveListener(l);
        n.notifyReceiveListeners(event);
    }

    public static void usage(PrintStream out) {
        String msg = "usage: Notifier -f <qfile> -r <reason> -t <time> -c <id> [ -n <next-attempt> ]\nNotify listeners of Job state changes.\n\nOptions:\n\t-f <file>\tQueue filename\n\t-r <reason>\tReason for state change, see notify(8C)\n\t-t <time>\tJob elapsed time\n\t-c <class>\tJava class name of Listener to notify\n\t-j <jobid>\tThe HylaFAX JOBID\n\t-n <next-attempt>\tETA for next attempt (if <reason> is 'requeued')\n\n";
        out.print(msg);
    }
}

