/*
 * Decompiled with CFR 0.152.
 */
package gnu.hylafax.util;

import gnu.getopt.Getopt;
import gnu.hylafax.HylaFAXClient;
import gnu.hylafax.Job;
import gnu.hylafax.Pagesize;
import java.awt.Dimension;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SendFax {
    private static final Log log = LogFactory.getLog((Class)SendFax.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void main(String[] arguments) {
        block34: {
            int i;
            char opt;
            String user = "fax";
            String host = "localhost";
            String destination = null;
            String from = user;
            String killtime = "000259";
            int maxdials = 12;
            int maxtries = 3;
            int priority = 127;
            String notifyaddr = user;
            int resolution = 98;
            String notify = "none";
            String pagechop = "default";
            int chopthreshold = 3;
            Vector<String> documents = new Vector<String>();
            boolean verbose = false;
            boolean from_is_set = false;
            Pagesize pagesize = Pagesize.LETTER;
            Getopt g = new Getopt("SendFax", arguments, "k:t:T:DRNP:d:vf:h:lms:u:");
            block26: while ((short)(opt = (char)g.getopt()) != -1) {
                switch (opt) {
                    case 'd': {
                        destination = g.getOptarg();
                        continue block26;
                    }
                    case 'f': {
                        from_is_set = true;
                        from = g.getOptarg();
                        continue block26;
                    }
                    case 'k': {
                        killtime = g.getOptarg();
                        continue block26;
                    }
                    case 'h': {
                        host = g.getOptarg();
                        continue block26;
                    }
                    case 'l': {
                        resolution = 98;
                        continue block26;
                    }
                    case 'm': {
                        resolution = 196;
                        continue block26;
                    }
                    case 't': {
                        maxtries = Integer.parseInt(g.getOptarg());
                        continue block26;
                    }
                    case 'T': {
                        maxdials = Integer.parseInt(g.getOptarg());
                        continue block26;
                    }
                    case 'D': {
                        notify = "DONE";
                        continue block26;
                    }
                    case 'R': {
                        notify = "REQUEUE";
                        continue block26;
                    }
                    case 'N': {
                        notify = "NONE";
                        continue block26;
                    }
                    case 'P': {
                        priority = Integer.parseInt(g.getOptarg());
                        continue block26;
                    }
                    case 's': {
                        pagesize = Pagesize.getPagesize((String)g.getOptarg());
                        if (pagesize != null) continue block26;
                        System.err.println("'" + g.getOptarg() + "' is not a valid pagesize value");
                        SendFax.usage(System.err);
                        System.exit(-1);
                        continue block26;
                    }
                    case 'u': {
                        user = g.getOptarg();
                        continue block26;
                    }
                    case 'v': {
                        verbose = true;
                        continue block26;
                    }
                    case '?': {
                        SendFax.usage(System.err);
                        System.exit(-1);
                        continue block26;
                    }
                }
                SendFax.usage(System.err);
                System.exit(-1);
            }
            if (!from_is_set) {
                from = user;
            }
            if (destination == null) {
                SendFax.usage(System.err);
                System.exit(-1);
            }
            int count = 0;
            for (i = g.getOptind(); i < arguments.length; ++i) {
                ++count;
            }
            if (count < 1) {
                SendFax.usage(System.err);
                System.exit(-1);
            }
            HylaFAXClient c = new HylaFAXClient();
            c.open(host);
            if (c.user(user)) {
                System.out.print("Password:");
                BufferedReader input = new BufferedReader(new InputStreamReader(System.in));
                String password = input.readLine();
                c.pass(password);
            }
            c.noop();
            c.tzone("LOCAL");
            for (i = g.getOptind(); i < arguments.length; ++i) {
                FileInputStream file = new FileInputStream(arguments[i]);
                String remote_filename = c.putTemporary((InputStream)file);
                documents.addElement(remote_filename);
            }
            Job job = c.createJob();
            job.setFromUser(from);
            job.setNotifyAddress(from);
            job.setKilltime(killtime);
            job.setMaximumDials(maxdials);
            job.setMaximumTries(maxtries);
            job.setPriority(priority);
            job.setDialstring(destination);
            job.setVerticalResolution(resolution);
            job.setPageDimension((Dimension)pagesize);
            job.setNotifyType(notify);
            job.setChopThreshold(chopthreshold);
            for (i = 0; i < documents.size(); ++i) {
                String document = (String)documents.elementAt(i);
                job.addDocument(document);
            }
            c.submit(job);
            Object var26_26 = null;
            try {
                c.quit();
            }
            catch (Exception e2) {
                log.error((Object)e2.getMessage(), (Throwable)e2);
            }
            break block34;
            {
                catch (Exception e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                    Object var26_27 = null;
                    try {
                        c.quit();
                    }
                    catch (Exception e2) {
                        log.error((Object)e2.getMessage(), (Throwable)e2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var26_28 = null;
                try {
                    c.quit();
                }
                catch (Exception e2) {
                    log.error((Object)e2.getMessage(), (Throwable)e2);
                }
                throw throwable;
            }
        }
    }

    public static void usage(PrintStream out) {
        out.println("usage:\n\tSendFax <options> file1 ...\n");
        out.println("where <options> can be:\n\t-h <host>    specifiy server hostname\n\t-u <user>    user to login to the server with\n\t-v           verbose mode\n\t-d <number>  specify a destination FAX <number>\n\t-f <sender>  user <sender> as the identity of the FAX sender\n\t-k <time>    kill the job if it doesn't complete after the\n\t             indicated <time> (default: \"000259\", 2 hours, 59 minutes)\n\t-t <tries>   make no more than <tries> attempts to deliver the FAX\n\t-T <dials>   maximum number of <dials> to attempt for each job\n\t-D           enable delivery notification\n\t-R           enable delivery and retry notification\n\t-N           disable delivery and retry notification\n\t-P <pri>     assign the <pri> priority to the job (default: 127)\n\t-l           use low resolution (98 lines/inch)\n\t-m           use medium resolution (196 lines/inch)\n\t-s <size>    specify the symbolic page <size>\n\t             (legal, us-let, a3, a4, etc.)\n\nFiles queued must be formats that the HylaFAX server can\n handle natively (PS, TIFF, etc.) as no client-side\n conversions are performed.");
    }
}

