/*
 * Decompiled with CFR 0.152.
 */
package net.java.hulp.measure.internal;

import java.lang.reflect.Method;
import java.util.List;
import java.util.regex.Pattern;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import net.java.hulp.measure.Probe;
import net.java.hulp.measure.internal.FactoryV2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DelegatorFactory
implements FactoryV2 {
    private Object mDelegate;
    private Method mCreate;
    private Method mEnd;
    private Method mSetSubtopic;
    private Method mSetTopic;
    private Method mGetData;
    private Method mClearData;

    public DelegatorFactory(Object delegate) throws Exception {
        this.mDelegate = delegate;
        Class<?> c = delegate.getClass();
        this.mCreate = c.getMethod("createV2", Integer.TYPE, Class.class, String.class, String.class);
        this.mGetData = c.getMethod("getData", List.class);
        this.mClearData = c.getMethod("clearData", List.class);
        c = c.getClassLoader().loadClass(Probe.class.getName());
        this.mEnd = c.getMethod("end", new Class[0]);
        this.mSetSubtopic = c.getMethod("setSubtopic", String.class);
        this.mSetTopic = c.getMethod("setTopic", String.class);
    }

    @Override
    public Probe createV2(int level, Class source, String topic, String subtopic) {
        try {
            Object target = this.mCreate.invoke(this.mDelegate, level, source, topic, subtopic);
            return new M(target);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public TabularData getData(List<Pattern[]> criteria) {
        try {
            return (TabularDataSupport)this.mGetData.invoke(this.mDelegate, criteria);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void clearData(List<Pattern[]> criteria) {
        try {
            this.mClearData.invoke(this.mDelegate, criteria);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private class M
    extends Probe {
        private Object mRealMeasurement;

        public M(Object delegate) {
            this.mRealMeasurement = delegate;
        }

        public void end() {
            try {
                DelegatorFactory.this.mEnd.invoke(this.mRealMeasurement, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public void setSubtopic(String subTopic) {
            try {
                DelegatorFactory.this.mSetSubtopic.invoke(this.mRealMeasurement, subTopic);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public void setTopic(String topic) {
            try {
                DelegatorFactory.this.mSetTopic.invoke(this.mRealMeasurement, topic);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

