/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.jcharts.nonAxisChart;

import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.geom.Arc2D;
import java.awt.geom.Line2D;
import java.io.Serializable;
import org.krysalis.jcharts.Chart;
import org.krysalis.jcharts.chartData.interfaces.IPieChartDataSet;
import org.krysalis.jcharts.chartData.processors.PieChartDataProcessor;
import org.krysalis.jcharts.imageMap.CircleMapArea;
import org.krysalis.jcharts.imageMap.ImageMap;
import org.krysalis.jcharts.imageMap.ImageMapArea;
import org.krysalis.jcharts.imageMap.PolyMapArea;
import org.krysalis.jcharts.nonAxisChart.PieLabels;
import org.krysalis.jcharts.properties.ChartProperties;
import org.krysalis.jcharts.properties.LegendProperties;
import org.krysalis.jcharts.properties.PieChart3DProperties;
import org.krysalis.jcharts.test.HTMLChartTestable;
import org.krysalis.jcharts.test.HTMLGenerator;
import org.krysalis.jcharts.types.PieLabelType;

public class PieChart3D
extends Chart
implements HTMLChartTestable {
    private float pieX;
    private float pieY;
    private float pie3dWidth;
    private float pie3dHeight;
    private static final float RATIO = 0.5f;
    private float diameter = 0.0f;
    private IPieChartDataSet iPieChartDataSet;
    private PieChartDataProcessor pieChartDataProcessor;
    private PieLabels pieLabels;

    public PieChart3D(IPieChartDataSet iPieChartDataSet, LegendProperties legendProperties, ChartProperties chartProperties, int n, int n2) {
        super(legendProperties, chartProperties, n, n2);
        this.iPieChartDataSet = iPieChartDataSet;
    }

    protected void renderChart() {
        float f;
        PieChart3DProperties pieChart3DProperties = (PieChart3DProperties)this.iPieChartDataSet.getChartTypeProperties();
        FontRenderContext fontRenderContext = super.getGraphics2D().getFontRenderContext();
        this.pieChartDataProcessor = new PieChartDataProcessor(this.iPieChartDataSet);
        this.pieChartDataProcessor.processData();
        float f2 = super.getChartProperties().getEdgePadding() * 2.0f;
        float f3 = super.getImageWidth() / 2;
        float f4 = super.getImageHeight() / 2;
        float f5 = super.renderChartTitle(this.iPieChartDataSet.getChartTitle(), fontRenderContext);
        float f6 = (float)super.getImageWidth() - f2;
        float f7 = (float)super.getImageHeight() - f2;
        f7 -= f5;
        f7 -= (float)pieChart3DProperties.getDepth();
        if (!pieChart3DProperties.getPieLabelType().equals(PieLabelType.NO_LABELS)) {
            this.pieLabels = new PieLabels(pieChart3DProperties, this.iPieChartDataSet, fontRenderContext);
            if (this.iPieChartDataSet.getNumberOfDataItems() != 1) {
                f6 -= this.pieLabels.getWidestLabelTimesTwo();
                f6 -= pieChart3DProperties.getTickLength() * 2.0f;
            }
            f7 -= this.pieLabels.getTallestLabelTimesTwo();
            f7 -= pieChart3DProperties.getTickLength() * 2.0f;
        }
        if (this.getLegend() != null) {
            f = 0.0f;
            float f8 = 0.0f;
            this.getLegend().calculateDrawingValues(this.iPieChartDataSet);
            if (this.getLegend().getLegendProperties().getPlacement() == 1 || this.getLegend().getLegendProperties().getPlacement() == 2) {
                f6 -= this.getLegend().getWidth();
                this.diameter = Math.max(f6 -= (float)this.getLegend().getLegendProperties().getChartPadding(), 1.0f);
                this.pie3dWidth = this.diameter = Math.min(this.diameter, f7);
                this.pie3dHeight = this.pie3dWidth * 0.5f;
                float f9 = this.diameter;
                f9 += this.getLegend().getWidth();
                f9 += (float)this.getLegend().getLegendProperties().getChartPadding();
                if (this.pieLabels != null) {
                    f9 += this.pieLabels.getWidestLabel() * 2.0f;
                    f9 += pieChart3DProperties.getTickLength() * 2.0f;
                }
                if (this.getLegend().getLegendProperties().getPlacement() == 1) {
                    this.pieX = f3 - f9 / 2.0f;
                    if (this.pieLabels != null) {
                        this.pieX += this.pieLabels.getWidestLabel();
                        this.pieX += pieChart3DProperties.getTickLength();
                        f += this.pieLabels.getWidestLabel();
                        f += pieChart3DProperties.getTickLength();
                    }
                    f += this.pieX + this.diameter;
                    f += (float)this.getLegend().getLegendProperties().getChartPadding();
                } else {
                    f = f3 - f9 / 2.0f;
                    if (this.pieLabels != null) {
                        this.pieX = f;
                        this.pieX += this.getLegend().getWidth();
                        this.pieX += (float)this.getLegend().getLegendProperties().getChartPadding();
                        this.pieX += this.pieLabels.getWidestLabel();
                        this.pieX += pieChart3DProperties.getTickLength();
                    }
                }
                f8 = f4 - (float)(this.getLegend().getHeight() / 2);
                this.pieY = f4 - (this.pie3dHeight + (float)pieChart3DProperties.getDepth()) / 2.0f;
            } else {
                f7 -= (float)this.getLegend().getHeight();
                this.diameter = Math.max(f7 -= (float)this.getLegend().getLegendProperties().getChartPadding(), 1.0f);
                this.pie3dWidth = this.diameter = Math.min(this.diameter, f6);
                this.pie3dHeight = this.pie3dWidth * 0.5f;
                if (this.getLegend().getLegendProperties().getPlacement() == 0) {
                    this.pieY = super.getChartProperties().getEdgePadding();
                    this.pieY += f5;
                    if (this.pieLabels != null) {
                        this.pieY += this.pieLabels.getTallestLabel();
                        this.pieY += pieChart3DProperties.getTickLength();
                        f8 += this.pieLabels.getTallestLabel();
                        f8 += pieChart3DProperties.getTickLength();
                    }
                    f8 += this.pieY;
                    f8 += this.pie3dHeight;
                    f8 += (float)this.getLegend().getLegendProperties().getChartPadding();
                    f8 += (float)pieChart3DProperties.getDepth();
                } else {
                    f8 = super.getChartProperties().getEdgePadding();
                    this.pieY = f8 += f5;
                    this.pieY += (float)this.getLegend().getHeight();
                    this.pieY += (float)this.getLegend().getLegendProperties().getChartPadding();
                    if (this.pieLabels != null) {
                        this.pieY += this.pieLabels.getTallestLabel();
                        this.pieY += pieChart3DProperties.getTickLength();
                    }
                }
                f = f3 - this.getLegend().getWidth() / 2.0f;
                this.pieX = f3 - this.diameter / 2.0f;
            }
            super.getLegend().setX(f);
            super.getLegend().setY(f8);
            super.getLegend().render();
        } else {
            this.diameter = Math.max(f6, 1.0f);
            this.pie3dWidth = this.diameter = Math.min(this.diameter, f7);
            this.pie3dHeight = this.pie3dWidth * 0.5f;
            f = (this.diameter + (float)pieChart3DProperties.getDepth()) / 2.0f;
            this.pieX = f3 - f;
            this.pieY = f4 - (this.pie3dHeight + (float)pieChart3DProperties.getDepth()) / 2.0f;
        }
        if (super.getGenerateImageMapFlag()) {
            ImageMap imageMap = new ImageMap(this.iPieChartDataSet.getNumberOfDataItems());
            super.setImageMap(imageMap);
        }
        PieChart3D.render(this);
    }

    static void render(PieChart3D pieChart3D) {
        Graphics2D graphics2D = pieChart3D.getGraphics2D();
        PieChart3DProperties pieChart3DProperties = (PieChart3DProperties)pieChart3D.iPieChartDataSet.getChartTypeProperties();
        int n = 3;
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float[][] fArray = null;
        if (pieChart3D.getImageMap() != null) {
            f = (float)((double)pieChart3D.diameter / 2.0);
            f2 = f + pieChart3D.pieX;
            f3 = f + pieChart3D.pieY;
            fArray = new float[pieChart3D.iPieChartDataSet.getNumberOfDataItems() * (n + 1)][2];
        }
        float f4 = pieChart3DProperties.getZeroDegreeOffset();
        double d = 0.0;
        if (pieChart3D.iPieChartDataSet.getNumberOfDataItems() == 1) {
            Arc2D.Double double_ = new Arc2D.Double(pieChart3D.pieX, pieChart3D.pieY + (float)pieChart3DProperties.getDepth(), pieChart3D.diameter, pieChart3D.diameter, f4, 360.0, 0);
            for (int i = pieChart3DProperties.getDepth(); i >= 0; --i) {
                graphics2D.setPaint(pieChart3D.iPieChartDataSet.getPaint(0));
                graphics2D.fill(double_);
                if (i == pieChart3DProperties.getDepth() || i == 0) {
                    pieChart3DProperties.getBorderChartStroke().draw(graphics2D, double_);
                }
                double_.y -= 1.0;
            }
            if (pieChart3D.getImageMap() != null) {
                CircleMapArea circleMapArea = new CircleMapArea(f2, f3, pieChart3D.iPieChartDataSet.getValue(0), null, pieChart3D.iPieChartDataSet.getLegendLabel(0));
                circleMapArea.setRadius((int)pieChart3D.diameter);
                pieChart3D.getImageMap().addImageMapArea(circleMapArea);
            }
            float f5 = pieChart3D.pieX + pieChart3D.diameter / 2.0f - pieChart3D.pieLabels.getTextTag(0).getWidth() / 2.0f;
            float f6 = pieChart3D.pieY - pieChart3DProperties.getTickLength();
            pieChart3DProperties.getValueLabelFont().setupGraphics2D(graphics2D);
            graphics2D.drawString(pieChart3D.pieLabels.getTextTag(0).getText(), f5, f6);
        } else {
            Arc2D.Double double_ = new Arc2D.Double(pieChart3D.pieX, pieChart3D.pieY + (float)pieChart3DProperties.getDepth(), pieChart3D.pie3dWidth, pieChart3D.pie3dHeight, f4, 360.0, 2);
            Line2D.Float float_ = new Line2D.Float();
            float_.x1 = pieChart3D.pieX + pieChart3D.pie3dWidth / 2.0f;
            float_.y1 = pieChart3D.pieY + pieChart3D.pie3dHeight / 2.0f;
            float_.x2 = float_.x1;
            float_.y2 = float_.y1 + (float)pieChart3DProperties.getDepth();
            pieChart3DProperties.getBorderChartStroke().draw(graphics2D, float_);
            for (int i = pieChart3DProperties.getDepth(); i >= 0; --i) {
                Serializable serializable;
                int n2;
                f4 = pieChart3DProperties.getZeroDegreeOffset();
                int n3 = 0;
                for (n2 = 0; n2 < pieChart3D.iPieChartDataSet.getNumberOfDataItems(); ++n2) {
                    double d2;
                    d = pieChart3D.pieChartDataProcessor.getPercentageOfPie(n2);
                    double_.setAngleStart(f4);
                    double_.setAngleExtent(d);
                    graphics2D.setPaint(pieChart3D.iPieChartDataSet.getPaint(n2));
                    graphics2D.fill(double_);
                    PieChart3D.drawFraming(i, pieChart3DProperties, graphics2D, double_, f4);
                    if (pieChart3D.pieLabels != null && i == 0) {
                        d2 = (double)f4 + d / 2.0;
                        if (d2 > 360.0) {
                            d2 -= 360.0;
                        }
                        f2 = (float)double_.x + pieChart3D.pie3dWidth / 2.0f;
                        f3 = (float)double_.y + pieChart3D.pie3dHeight / 2.0f;
                        serializable = new Arc2D.Double(pieChart3D.pieX, pieChart3D.pieY, pieChart3D.pie3dWidth, pieChart3D.pie3dHeight, f4, d / 2.0, 2);
                        Arc2D.Double double_2 = new Arc2D.Double(pieChart3D.pieX - pieChart3DProperties.getTickLength(), pieChart3D.pieY - pieChart3DProperties.getTickLength(), pieChart3D.pie3dWidth + pieChart3DProperties.getTickLength() * 2.0f, pieChart3D.pie3dHeight + pieChart3DProperties.getTickLength() * 2.0f, f4, d / 2.0, 2);
                        pieChart3DProperties.getBorderChartStroke().draw(graphics2D, new Line2D.Float(((Arc2D)((Object)serializable)).getEndPoint(), double_2.getEndPoint()));
                        float f7 = (float)double_2.getEndPoint().getX();
                        float f8 = (float)double_2.getEndPoint().getY();
                        pieChart3DProperties.getValueLabelFont().setupGraphics2D(graphics2D);
                        float f9 = f8;
                        if (d2 > 60.0 && d2 < 120.0) {
                            f9 -= pieChart3D.pieLabels.getTextTag(n2).getFontDescent();
                        } else if (d2 > 240.0 && d2 < 300.0) {
                            f9 += pieChart3D.pieLabels.getTextTag(n2).getFontAscent();
                        }
                        if (d2 > 180.0 && d2 < 360.0) {
                            f9 += (float)pieChart3DProperties.getDepth();
                        }
                        if (d2 > 90.0 && d2 < 270.0) {
                            graphics2D.drawString(pieChart3D.pieLabels.getTextTag(n2).getText(), f7 - pieChart3D.pieLabels.getTextTag(n2).getWidth() - pieChart3DProperties.getTickLength(), f9);
                        } else {
                            graphics2D.drawString(pieChart3D.pieLabels.getTextTag(n2).getText(), f7 + pieChart3DProperties.getTickLength(), f9);
                        }
                    }
                    if (pieChart3D.getImageMap() != null) {
                        d2 = f4;
                        double d3 = d / (double)n;
                        for (int j = 0; j <= n; ++j) {
                            double d4 = Math.cos(Math.toRadians(d2));
                            double d5 = Math.sin(Math.toRadians(d2));
                            fArray[n3][0] = f2 + (float)(d4 * (double)f);
                            fArray[n3][1] = f3 + (float)(-(d5 * (double)f));
                            ++n3;
                            d2 += d3;
                        }
                    }
                    f4 = (float)((double)f4 + d);
                }
                if (pieChart3D.getImageMap() != null) {
                    n2 = 0;
                    for (int j = 0; j < pieChart3D.iPieChartDataSet.getNumberOfDataItems(); ++j) {
                        int n4 = 0;
                        serializable = new PolyMapArea(3 + n, pieChart3D.iPieChartDataSet.getValue(j), null, pieChart3D.iPieChartDataSet.getLegendLabel(j));
                        ((PolyMapArea)serializable).addCoordinate(n4++, f2, f3);
                        for (int k = 0; k <= n; ++k) {
                            ((PolyMapArea)serializable).addCoordinate(n4++, fArray[n2][0], fArray[n2][1]);
                            ++n2;
                        }
                        if (j + 1 == pieChart3D.iPieChartDataSet.getNumberOfDataItems()) {
                            ((PolyMapArea)serializable).addCoordinate(n4, fArray[0][0], fArray[0][1]);
                        } else {
                            ((PolyMapArea)serializable).addCoordinate(n4, fArray[n2][0], fArray[n2][1]);
                        }
                        pieChart3D.getImageMap().addImageMapArea((ImageMapArea)serializable);
                    }
                }
                double_.y -= 1.0;
            }
        }
    }

    private static void drawFraming(int n, PieChart3DProperties pieChart3DProperties, Graphics2D graphics2D, Arc2D.Double double_, float f) {
        if (n == pieChart3DProperties.getDepth() || n == 0) {
            pieChart3DProperties.getBorderChartStroke().draw(graphics2D, double_);
            if (n == pieChart3DProperties.getDepth()) {
                if (f > 0.0f && f < 180.0f) {
                    pieChart3DProperties.getBorderChartStroke().draw(graphics2D, new Line2D.Double(double_.getStartPoint().getX(), double_.getStartPoint().getY(), double_.getStartPoint().getX(), double_.getStartPoint().getY() - (double)pieChart3DProperties.getDepth()));
                }
            } else if (n == 0 && (f == 0.0f || f >= 180.0f && f < 360.0f)) {
                pieChart3DProperties.getBorderChartStroke().draw(graphics2D, new Line2D.Double(double_.getStartPoint().getX(), double_.getStartPoint().getY(), double_.getStartPoint().getX(), double_.getStartPoint().getY() + (double)pieChart3DProperties.getDepth()));
            }
        }
    }

    public void toHTML(HTMLGenerator hTMLGenerator, String string) {
        if (this.getLegend() != null) {
            hTMLGenerator.chartTableRowStart();
            this.getLegend().toHTML(hTMLGenerator);
            hTMLGenerator.chartTableRowEnd();
        }
        hTMLGenerator.chartTableEnd();
    }
}

