/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsptest.compiler.jsp20;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServlet;
import javax.servlet.jsp.jstl.core.LoopTag;
import javax.servlet.jsp.tagext.JspTag;
import javax.servlet.jsp.tagext.TagInfo;
import net.sf.jsptest.compiler.JspCompilationInfo;
import net.sf.jsptest.compiler.java.CommandLineJavac;
import net.sf.jsptest.compiler.java.Java6Compiler;
import net.sf.jsptest.compiler.java.JavaCompiler;
import net.sf.jsptest.compiler.java.SunJavaC;
import net.sf.jsptest.compiler.jsp20.mock.MockOptions;
import net.sf.jsptest.compiler.jsp20.mock.MockServletConfig;
import net.sf.jsptest.compiler.jsp20.mock.MockTagInfo;
import net.sf.jsptest.utils.Path;
import net.sf.jsptest.utils.Strings;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jasper.EmbeddedServletOptions;
import org.apache.jasper.JasperException;
import org.apache.jasper.JspC;
import org.apache.jasper.JspCompilationContext;
import org.apache.jasper.Options;
import org.apache.jasper.compiler.AntCompiler;
import org.apache.jasper.compiler.Compiler;
import org.apache.jasper.compiler.JspRuntimeContext;
import org.apache.jasper.compiler.ServletWriter;
import org.apache.jasper.runtime.HttpJspBase;
import org.apache.jasper.servlet.JspCServletContext;
import org.apache.jasper.servlet.JspServletWrapper;
import org.apache.taglibs.standard.Version;

public class JasperCompiler {
    private static final Log log = LogFactory.getLog((Class)JasperCompiler.class);
    private static JavaCompiler COMPILER = JasperCompiler.determineJavaCompiler();
    private String webRoot = ".";
    private String classOutputBaseDir = ".";
    private String jspPackageName;

    public void setWebRoot(String webRoot) {
        this.webRoot = webRoot;
    }

    public void setClassOutputBaseDir(String directory) {
        this.classOutputBaseDir = directory;
    }

    public JspCompilationInfo compile(String path, Map mockTaglibs) throws Exception {
        JspCompilationInfo info = this.createJspCompilationInfo(path, mockTaglibs);
        if (info.jspCompilationRequired()) {
            this.compileJsp(info);
            this.compileJavaToBytecode(info);
        } else {
            log.debug((Object)("  No compilation needed for " + info.getJspSource()));
        }
        return info;
    }

    public void setJspPackageName(String packageName) {
        this.jspPackageName = packageName;
    }

    private String getJspPackageName() {
        if (this.jspPackageName != null) {
            return this.jspPackageName;
        }
        return "jsp";
    }

    private JspCompilationInfo createJspCompilationInfo(String jsp, Map mockTaglibs) {
        JspCompilationInfo info = new JspCompilationInfo();
        info.setJspPath(jsp);
        info.setClassOutputDir(this.classOutputBaseDir);
        info.setJspSource(this.resolveJspSourceFile(jsp));
        info.setWebRoot(this.getWebRoot());
        info.setTaglibs(mockTaglibs);
        this.resolveJavaSourceFile(info);
        this.resolveClassFileLocation(info);
        this.resolveClassName(info);
        return info;
    }

    private String getWebRoot() {
        File root = new File(this.webRoot);
        if (root.exists() && root.isDirectory()) {
            return root.getAbsolutePath();
        }
        return this.resolveWebRootFromClassPath();
    }

    private String resolveWebRootFromClassPath() {
        URL url;
        String path = this.webRoot;
        if (path.startsWith("./")) {
            path = path.substring(2);
        }
        if ((url = this.getClass().getClassLoader().getResource(path)) == null) {
            return this.webRoot;
        }
        if (!url.toExternalForm().startsWith("file:")) {
            log.info((Object)("Web root referenced a non-filesystem resource: " + url));
            return this.webRoot;
        }
        return new File(url.toExternalForm().substring("file:".length())).getAbsolutePath();
    }

    private void compileJsp(JspCompilationInfo info) throws Exception {
        JasperCompiler.assertTrue("Source file " + new File(info.getJspSource()).getAbsolutePath() + " does not exist", new File(info.getJspSource()).exists());
        PrintWriter logWriter = new PrintWriter(new StringWriter());
        URL baseUrl = new File(info.getWebRoot()).toURL();
        JspCServletContext sContext = new JspCServletContext(logWriter, baseUrl);
        MockServletConfig sConfig = new MockServletConfig((ServletContext)sContext);
        Options options = this.createOptions((ServletContext)sContext, sConfig, info);
        JspRuntimeContext rtContext = new JspRuntimeContext((ServletContext)sContext, options);
        JspServletWrapper sWrapper = this.makeWrapper((ServletContext)sContext, options, rtContext);
        JspCompilationContext cContext = this.createJspCompilationContext(info, (ServletContext)sContext, options, rtContext, sWrapper, new StringWriter());
        this.logCompilation(info.getJspSource(), info.getClassOutputDir());
        this.compileJspToJava(sWrapper, cContext);
        File javaFile = new File(info.getJavaSource());
        JasperCompiler.assertTrue("Failed to generate .java source code to " + javaFile.getAbsolutePath(), javaFile.exists());
        info.compilationWasSuccessful();
    }

    private void compileJspToJava(JspServletWrapper jspServletWrapper, JspCompilationContext jspCompilationContext) throws FileNotFoundException, JasperException, Exception {
        AntCompiler compiler = new AntCompiler();
        compiler.init(jspCompilationContext, jspServletWrapper);
        compiler.compile();
    }

    private JspCompilationContext createJspCompilationContext(JspCompilationInfo info, ServletContext servletContext, Options options, JspRuntimeContext jspRuntimeContext, JspServletWrapper jspServletWrapper, StringWriter stringWriter) {
        boolean isErrorPage = false;
        JspCompilationContext cContext = new JspCompilationContext(info.getJspPath(), isErrorPage, options, servletContext, jspServletWrapper, jspRuntimeContext);
        cContext.getOutputDir();
        cContext.setServletJavaFileName(info.getJavaSource());
        cContext.setServletPackageName(this.getJspPackageName());
        cContext.setWriter(new ServletWriter(new PrintWriter(stringWriter)));
        this.createPathToGeneratedJavaSource(info);
        return cContext;
    }

    private void createPathToGeneratedJavaSource(JspCompilationInfo info) {
        new File(info.getJavaSource()).getParentFile().mkdirs();
    }

    private JspServletWrapper makeWrapper(ServletContext servletContext, Options options, JspRuntimeContext jspRuntimeContext) throws MalformedURLException, JasperException {
        MockTagInfo tagInfo = new MockTagInfo();
        String tagFilePath = "/";
        URL tagFileJarUrl = new File(".").toURL();
        JspServletWrapper wrapper = new JspServletWrapper(servletContext, options, tagFilePath, (TagInfo)tagInfo, jspRuntimeContext, tagFileJarUrl);
        return wrapper;
    }

    private Options createOptions(ServletContext ctx, ServletConfig cfg, JspCompilationInfo info) {
        EmbeddedServletOptions options = new EmbeddedServletOptions(cfg, ctx);
        return new MockOptions((Options)options, ctx, info);
    }

    private void resolveJavaSourceFile(JspCompilationInfo info) {
        File dir = new File(info.getClassOutputDir());
        if (this.getJspPackageName().length() > 0) {
            dir = new File(dir, this.getJspPackageName().replace('.', '/'));
        }
        dir.mkdirs();
        String name = this.resolveJavaSourceFileName(info.getJspPath());
        info.setJavaSource(new File(dir, name).getPath());
    }

    private String resolveJavaSourceFileName(String jspPath) {
        String name = this.encodeSpecialCharacters(jspPath);
        if (name.startsWith("/")) {
            name = name.substring(1);
        }
        return name + ".java";
    }

    private String encodeSpecialCharacters(String name) {
        StringBuffer result = new StringBuffer();
        char[] chars = name.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] == '-') {
                result.append("_002d");
                continue;
            }
            if (chars[i] == '_') {
                result.append("_005f");
                continue;
            }
            if (chars[i] == '.') {
                result.append("_");
                continue;
            }
            result.append(chars[i]);
        }
        return result.toString();
    }

    private String resolveJspSourceFile(String jsp) {
        if (jsp.startsWith("/")) {
            jsp = jsp.substring(1);
        }
        return new File(this.getWebRoot(), jsp).getPath();
    }

    private void resolveClassName(JspCompilationInfo info) {
        String baseName = new File(info.getJavaSource()).getName();
        baseName = baseName.substring(0, baseName.indexOf("."));
        String packageName = this.getPackagePrefix() + this.getSubDirPackagePrefix(info);
        info.setClassName(packageName + baseName);
    }

    private String getPackagePrefix() {
        String packagePrefix = this.getJspPackageName();
        if (packagePrefix != null && packagePrefix.length() > 0) {
            packagePrefix = packagePrefix + ".";
        }
        return packagePrefix;
    }

    private String getSubDirPackagePrefix(JspCompilationInfo info) {
        int lastSlashIndex;
        String dirPrefix = info.getJspPath();
        if (dirPrefix.startsWith("/")) {
            dirPrefix = dirPrefix.substring(1);
        }
        if ((lastSlashIndex = dirPrefix.lastIndexOf("/")) != -1) {
            dirPrefix = dirPrefix.substring(0, lastSlashIndex);
            dirPrefix = this.encodeSpecialCharacters(dirPrefix);
            dirPrefix = dirPrefix.replace('/', '.') + ".";
        } else {
            dirPrefix = "";
        }
        return dirPrefix;
    }

    private void compileJavaToBytecode(JspCompilationInfo info) throws Exception {
        File classFile = new File(info.getClassFile());
        classFile.delete();
        this.logCompilation(info.getJavaSource(), info.getClassOutputDir());
        boolean ok = JasperCompiler.javac().compile(info.getJavaSource(), info.getClassOutputDir(), this.getClassPath());
        JasperCompiler.assertTrue("javac failed", ok);
        JasperCompiler.assertTrue("Failed to compile .java file to " + classFile.getAbsolutePath(), classFile.exists());
    }

    private String[] getClassPath() {
        Path cp = new Path();
        cp.addSystemProperty("java.class.path");
        cp.addContainer(JspTag.class);
        cp.addContainer(LoopTag.class);
        cp.addContainer(HttpServlet.class);
        cp.addContainer(Version.class);
        cp.addContainer(JspC.class);
        cp.addContainer(Compiler.class);
        cp.addContainer(HttpJspBase.class);
        cp.add((Object)new File("target", "test-classes").getAbsolutePath());
        cp.add((Object)new File("target", "classes").getAbsolutePath());
        return cp.toStringArray();
    }

    private void resolveClassFileLocation(JspCompilationInfo info) {
        String file = Strings.replace((String)info.getJavaSource(), (String)".java", (String)".class");
        info.setClassFile(file);
    }

    private static void assertTrue(String errorMessage, boolean condition) {
        if (!condition) {
            throw new RuntimeException(errorMessage);
        }
    }

    private static JavaCompiler determineJavaCompiler() {
        ArrayList<Object> compilers = new ArrayList<Object>();
        compilers.add(new Java6Compiler());
        compilers.add(new SunJavaC());
        compilers.add(new CommandLineJavac());
        Iterator i = compilers.iterator();
        while (i.hasNext()) {
            JavaCompiler compiler = (JavaCompiler)i.next();
            if (!compiler.isAvailable()) continue;
            log.debug((Object)("Using JavaCompiler: " + compiler.getClass().getName()));
            return compiler;
        }
        throw new RuntimeException("No JavaCompiler implementation available on the system");
    }

    private static JavaCompiler javac() {
        return COMPILER;
    }

    private void logCompilation(String src, String dst) {
        log.debug((Object)("  Compiling " + src + " to " + dst));
    }
}

