/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsptest.compiler.jsp20;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspFactory;
import junit.framework.TestCase;
import net.sf.jsptest.compiler.JspCompilationInfo;
import net.sf.jsptest.compiler.jsp20.JasperCompiler;
import net.sf.jsptest.compiler.jsp20.mock.MockHttpServletRequest;
import net.sf.jsptest.compiler.jsp20.mock.MockHttpServletResponse;
import net.sf.jsptest.compiler.jsp20.mock.MockHttpSession;
import net.sf.jsptest.compiler.jsp20.mock.MockJspFactory;
import net.sf.jsptest.compiler.jsp20.mock.MockJspWriter;
import net.sf.jsptest.compiler.jsp20.mock.MockPageContext;
import net.sf.jsptest.compiler.jsp20.mock.MockServletConfig;
import net.sf.jsptest.compiler.jsp20.mock.MockServletContext;
import net.sf.jsptest.utils.CustomClassLoader;
import net.sf.jsptest.utils.IO;

public abstract class JasperExecution
extends TestCase {
    private static Map mockTaglibs = new HashMap();
    private static JasperCompiler compiler = new JasperCompiler();
    private MockPageContext pageContext;
    private File responseFile;
    protected Map sessionAttributes = new HashMap();
    protected Map requestAttributes = new HashMap();

    public JasperExecution() {
        mockTaglibs.clear();
        this.responseFile = null;
    }

    protected File getRenderedResponse() {
        return this.responseFile;
    }

    protected String getWebRoot() {
        return ".";
    }

    protected String getClassOutputBaseDir() {
        File home = new File(System.getProperty("user.home"));
        File jspClassDir = new File(home, ".jsptest/compiled/" + this.createUniqueIdentifierForWorkspace());
        jspClassDir.mkdirs();
        return jspClassDir.getAbsolutePath();
    }

    private String createUniqueIdentifierForWorkspace() {
        return "workspace-" + new File(".").getAbsolutePath().hashCode();
    }

    protected void get(String path) throws Exception {
        this.request(path, "GET");
    }

    protected void post(String path) throws Exception {
        this.request(path, "POST");
    }

    protected void request(String path, String httpMethod) throws Exception {
        this.require(path.startsWith("/"), "JSP paths must start with a slash ('/')");
        Class jspClass = this.compileToClass(path);
        this.responseFile = File.createTempFile("jsptest-response", ".txt");
        this.invokeServlet(httpMethod, jspClass);
    }

    private void require(boolean condition, String message) {
        if (!condition) {
            throw new IllegalArgumentException(message);
        }
    }

    protected void invokeServlet(String httpMethod, Class jspClass) throws InstantiationException, IllegalAccessException, ServletException, IOException {
        MockServletContext servletContext = new MockServletContext();
        MockServletConfig servletConfig = new MockServletConfig(servletContext);
        MockHttpSession httpSession = new MockHttpSession();
        httpSession.setAttributes(this.sessionAttributes);
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setSession(httpSession);
        request.setMethod(httpMethod);
        request.setAttributes(this.requestAttributes);
        MockHttpServletResponse response = new MockHttpServletResponse(this.getRenderedResponse());
        MockJspWriter jspWriter = this.configureJspFactory(servletContext, request, httpSession);
        this.initializeAndInvokeJsp(jspClass, servletConfig, request, response);
        this.writeOutputToTempFile(jspWriter.getContents());
    }

    protected MockJspWriter configureJspFactory(ServletContext httpContext, HttpServletRequest httpRequest, HttpSession httpSession) {
        this.pageContext = new MockPageContext();
        this.pageContext.setRequest((ServletRequest)httpRequest);
        this.pageContext.setServletContext(httpContext);
        this.pageContext.setSession(httpSession);
        MockJspWriter jspWriter = new MockJspWriter();
        this.pageContext.setJspWriter(jspWriter);
        JspFactory.setDefaultFactory((JspFactory)new MockJspFactory(this.pageContext));
        return jspWriter;
    }

    protected void initializeAndInvokeJsp(Class jspClass, ServletConfig servletConfig, HttpServletRequest request, HttpServletResponse response) throws InstantiationException, IllegalAccessException, ServletException, IOException {
        HttpServlet servlet = (HttpServlet)jspClass.newInstance();
        servlet.init(servletConfig);
        servlet.service((ServletRequest)request, (ServletResponse)response);
        if (this.pageContext.getException() != null) {
            throw new RuntimeException(this.pageContext.getException());
        }
    }

    private Class compileToClass(String path) throws Exception, ClassNotFoundException {
        JspCompilationInfo compilation = this.getCompiler().compile(path, mockTaglibs);
        return this.loadJspClass(compilation.getClassName());
    }

    private JasperCompiler getCompiler() {
        compiler.setWebRoot(this.getWebRoot());
        compiler.setClassOutputBaseDir(this.getClassOutputBaseDir());
        return compiler;
    }

    private Class loadJspClass(String jspClassName) throws ClassNotFoundException {
        CustomClassLoader cl = new CustomClassLoader(this.getClassOutputBaseDir());
        return cl.loadClass(jspClassName);
    }

    protected File writeOutputToTempFile(String output) throws IOException {
        File temp = File.createTempFile("generated_html_", ".html");
        IO.write((String)output, (File)temp);
        return temp;
    }

    protected void substituteTaglib(String namespace, Class klass) {
        mockTaglibs.put(namespace, klass);
    }
}

