/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsptest.compiler.jsp20;

import java.io.File;
import java.util.Map;
import net.sf.jsptest.compiler.JspCompilationInfo;
import net.sf.jsptest.compiler.api.Jsp;
import net.sf.jsptest.compiler.api.JspCompiler;
import net.sf.jsptest.compiler.jsp20.JasperCompiler;
import net.sf.jsptest.compiler.jsp20.JspImpl;
import net.sf.jsptest.utils.CustomClassLoader;

public class JspCompilerImpl
implements JspCompiler {
    private String outputDirectory = new File(System.getProperty("java.io.tmpdir"), "jsptest-classes").getAbsolutePath();
    private String webRoot;

    public void setOutputDirectory(String directory) {
        this.outputDirectory = directory;
    }

    protected String getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setWebRoot(String directory) {
        this.webRoot = directory;
    }

    protected String getWebRoot() {
        return this.webRoot;
    }

    public Jsp compile(String jspPath, Map taglibs) {
        try {
            JasperCompiler compiler = new JasperCompiler();
            compiler.setWebRoot(this.getWebRoot());
            compiler.setClassOutputBaseDir(this.getOutputDirectory());
            JspCompilationInfo info = compiler.compile(jspPath, taglibs);
            Class servletClass = this.compileToClass(info);
            return new JspImpl(servletClass);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Class compileToClass(JspCompilationInfo compilation) throws Exception, ClassNotFoundException {
        return this.loadJspClass(compilation.getClassName());
    }

    private Class loadJspClass(String jspClassName) throws ClassNotFoundException {
        CustomClassLoader cl = new CustomClassLoader(this.getOutputDirectory());
        return cl.loadClass(jspClassName);
    }
}

