/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsptest.compiler.jsp20;

import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspFactory;
import net.sf.jsptest.compiler.api.Jsp;
import net.sf.jsptest.compiler.api.JspExecution;
import net.sf.jsptest.compiler.jsp20.JspExecutionImpl;
import net.sf.jsptest.compiler.jsp20.mock.MockHttpServletRequest;
import net.sf.jsptest.compiler.jsp20.mock.MockHttpServletResponse;
import net.sf.jsptest.compiler.jsp20.mock.MockHttpSession;
import net.sf.jsptest.compiler.jsp20.mock.MockJspFactory;
import net.sf.jsptest.compiler.jsp20.mock.MockJspWriter;
import net.sf.jsptest.compiler.jsp20.mock.MockPageContext;
import net.sf.jsptest.compiler.jsp20.mock.MockServletConfig;
import net.sf.jsptest.compiler.jsp20.mock.MockServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JspImpl
implements Jsp {
    private static final Log log = LogFactory.getLog((Class)JspImpl.class);
    private final Class servletClass;
    private MockPageContext pageContext;

    public JspImpl(Class servletClass) {
        this.servletClass = servletClass;
    }

    public JspExecution request(String httpMethod, Map requestAttributes, Map sessionAttributes) {
        MockServletContext servletContext = new MockServletContext();
        MockServletConfig servletConfig = new MockServletConfig(servletContext);
        MockHttpSession httpSession = new MockHttpSession();
        httpSession.setAttributes(sessionAttributes);
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setSession(httpSession);
        request.setMethod(httpMethod);
        request.setAttributes(requestAttributes);
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockJspWriter jspWriter = this.configureJspFactory(servletContext, request, httpSession);
        this.initializeAndInvokeJsp(this.servletClass, servletConfig, request, response);
        return this.createExecutionResult(jspWriter.getContents());
    }

    protected MockJspWriter configureJspFactory(ServletContext httpContext, HttpServletRequest httpRequest, HttpSession httpSession) {
        this.pageContext = new MockPageContext();
        this.pageContext.setRequest((ServletRequest)httpRequest);
        this.pageContext.setServletContext(httpContext);
        this.pageContext.setSession(httpSession);
        MockJspWriter jspWriter = new MockJspWriter();
        this.pageContext.setJspWriter(jspWriter);
        JspFactory.setDefaultFactory((JspFactory)new MockJspFactory(this.pageContext));
        return jspWriter;
    }

    protected void initializeAndInvokeJsp(Class jspClass, ServletConfig servletConfig, HttpServletRequest request, HttpServletResponse response) {
        try {
            log.debug((Object)("Instantiating Servlet: " + jspClass.getName()));
            HttpServlet servlet = (HttpServlet)jspClass.newInstance();
            log.debug((Object)("Initializing Servlet: " + jspClass.getName()));
            servlet.init(servletConfig);
            log.debug((Object)("Invoking Servlet: " + jspClass.getName()));
            servlet.service((ServletRequest)request, (ServletResponse)response);
            if (this.pageContext.getException() != null) {
                log.debug((Object)"An exception was stored into PageContext. Rethrowing it...");
                throw new RuntimeException(this.pageContext.getException());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected JspExecution createExecutionResult(String output) {
        return new JspExecutionImpl(output);
    }
}

