/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsptest.compiler.jsp20.mock;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.security.Principal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import net.sf.jsptest.compiler.jsp20.mock.MockHttpSession;
import net.sf.jsptest.compiler.jsp20.mock.MockServletInputStream;

public class MockHttpServletRequest
implements HttpServletRequest {
    private Map headers = new HashMap();
    private Map parameters = new HashMap();
    private Map attributes = new HashMap();
    private MockHttpSession httpSession = null;
    private byte[] body;
    private String httpMethod;
    private String characterEncoding;

    public MockHttpServletRequest() {
        this((MockHttpSession)null);
    }

    public MockHttpServletRequest(MockHttpSession httpSession) {
        this.setSession(httpSession);
    }

    public MockHttpServletRequest(byte[] body) {
        this.body = body;
        this.characterEncoding = "UTF-8";
        this.headers.put("Content-type", "multipart/form-data; boundary=XXXBOUNDARYXXX");
    }

    public String getAuthType() {
        return null;
    }

    public Cookie[] getCookies() {
        return new Cookie[0];
    }

    public long getDateHeader(String s) {
        try {
            return new SimpleDateFormat().parse((String)this.headers.get(s)).getTime();
        }
        catch (ParseException e) {
            return 0L;
        }
    }

    public String getHeader(String reference) {
        return (String)this.headers.get(reference);
    }

    public Enumeration getHeaders(String s) {
        return new Vector().elements();
    }

    public Enumeration getHeaderNames() {
        return new Vector(this.headers.keySet()).elements();
    }

    public int getIntHeader(String s) {
        return Integer.parseInt(this.getHeader(s));
    }

    public void setMethod(String httpMethod) {
        this.httpMethod = httpMethod;
    }

    public String getMethod() {
        return this.httpMethod;
    }

    public String getPathInfo() {
        return "/";
    }

    public String getPathTranslated() {
        return "/";
    }

    public String getContextPath() {
        return "/";
    }

    public String getQueryString() {
        return null;
    }

    public String getRemoteUser() {
        return null;
    }

    public boolean isUserInRole(String s) {
        return false;
    }

    public Principal getUserPrincipal() {
        return null;
    }

    public String getRequestedSessionId() {
        return "JSPTESTSESSIONID";
    }

    public String getRequestURI() {
        return "/";
    }

    public StringBuffer getRequestURL() {
        return new StringBuffer("/");
    }

    public String getServletPath() {
        return "/";
    }

    public HttpSession getSession(boolean flag) {
        if (flag && this.httpSession == null) {
            this.httpSession = new MockHttpSession();
        }
        return this.httpSession;
    }

    public HttpSession getSession() {
        return this.httpSession;
    }

    public boolean isRequestedSessionIdValid() {
        return true;
    }

    public boolean isRequestedSessionIdFromCookie() {
        return true;
    }

    public boolean isRequestedSessionIdFromURL() {
        return false;
    }

    public boolean isRequestedSessionIdFromUrl() {
        return false;
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Enumeration getAttributeNames() {
        return new Vector(this.attributes.keySet()).elements();
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public void setCharacterEncoding(String env) {
        this.characterEncoding = env;
    }

    public int getContentLength() {
        return this.body.length;
    }

    public String getContentType() {
        return "multipart/form-data; boundary=xxx";
    }

    public ServletInputStream getInputStream() throws IOException {
        return new MockServletInputStream(this.body);
    }

    public String getParameter(String name) {
        String[] values = (String[])this.parameters.get(name);
        if (values != null) {
            return values[0];
        }
        return null;
    }

    public Map getParameterMap() {
        return this.parameters;
    }

    public String getProtocol() {
        return "http";
    }

    public String getScheme() {
        return "http://";
    }

    public String getServerName() {
        return "servername";
    }

    public int getServerPort() {
        return 8080;
    }

    public BufferedReader getReader() throws IOException {
        return null;
    }

    public String getRemoteAddr() {
        return null;
    }

    public String getRemoteHost() {
        return null;
    }

    public void setAttributes(Map attributes) {
        this.attributes.putAll(attributes);
    }

    public void setAttribute(String name, Object o) {
        this.attributes.put(name, o);
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public Locale getLocale() {
        return Locale.getDefault();
    }

    public Enumeration getLocales() {
        return new Vector<Locale>(Arrays.asList(Locale.getAvailableLocales())).elements();
    }

    public boolean isSecure() {
        return false;
    }

    public RequestDispatcher getRequestDispatcher(String s) {
        return new RequestDispatcher(){

            public void forward(ServletRequest request, ServletResponse response) throws ServletException, IOException {
            }

            public void include(ServletRequest request, ServletResponse response) throws ServletException, IOException {
            }
        };
    }

    public String getRealPath(String s) {
        File tmpDir = new File(System.getProperty("java.io.tmpdir"));
        File jsptestTmpDir = new File(tmpDir, "jsptest");
        return new File(jsptestTmpDir, s).getAbsolutePath();
    }

    public int getRemotePort() {
        return 11111;
    }

    public String getLocalName() {
        return null;
    }

    public String getLocalAddr() {
        return null;
    }

    public int getLocalPort() {
        return 22222;
    }

    public void addParameter(String name, String[] values) {
        this.parameters.put(name, values);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getClass().getName()).append("{");
        Enumeration enumeration = this.getParameterNames();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            String[] values = this.getParameterValues(key);
            buffer.append("parameter:");
            buffer.append(key);
            buffer.append("=[");
            for (int i = 0; i < values.length; ++i) {
                String value = values[i];
                buffer.append(value);
                if (i >= values.length - 1) continue;
                buffer.append(",");
            }
            buffer.append("]\n");
        }
        buffer.append("}");
        return buffer.toString();
    }

    public Enumeration getParameterNames() {
        return new Vector(this.parameters.keySet()).elements();
    }

    public String[] getParameterValues(String name) {
        return (String[])this.parameters.get(name);
    }

    public void setSession(MockHttpSession session) {
        this.httpSession = session;
    }
}

