/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsptest.compiler.jsp20.mock;

import java.io.IOException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.el.ExpressionEvaluator;
import javax.servlet.jsp.el.VariableResolver;
import net.sf.jsptest.compiler.jsp20.mock.MockHttpServletRequest;
import net.sf.jsptest.compiler.jsp20.mock.MockHttpServletResponse;
import net.sf.jsptest.compiler.jsp20.mock.MockHttpSession;
import net.sf.jsptest.compiler.jsp20.mock.MockJspWriter;
import net.sf.jsptest.compiler.jsp20.mock.MockServletConfig;
import net.sf.jsptest.compiler.jsp20.mock.MockServletContext;
import org.apache.commons.el.ExpressionEvaluatorImpl;
import org.apache.commons.el.VariableResolverImpl;

public class MockPageContext
extends PageContext {
    private static final String VALID_SCOPES_DESCRIPTION = "Valid scopes are PageContext.PAGE_SCOPE, PageContext.REQUEST_SCOPE, PageContext.SESSION_SCOPE and PageContext.APPLICATION_SCOPE";
    private JspWriter out = new MockJspWriter();
    private HttpSession session;
    private ServletContext servletContext;
    private ServletRequest request;
    private ServletResponse response;
    private ServletConfig servletConfig;
    private Map pageScopeAttributes;
    private Map applicationScopeAttributes;
    private Object page;
    private ExpressionEvaluator expressionEvaluator;

    public MockPageContext() {
        this((ServletRequest)new MockHttpServletRequest());
    }

    public MockPageContext(ServletRequest servletRequest) {
        this.request = servletRequest;
        this.response = new MockHttpServletResponse();
        this.session = new MockHttpSession();
        this.pageScopeAttributes = new HashMap();
        this.applicationScopeAttributes = new HashMap();
        this.servletContext = new MockServletContext();
        this.servletConfig = new MockServletConfig(this.servletContext);
        this.expressionEvaluator = new ExpressionEvaluatorImpl();
    }

    public Object findAttribute(String name) {
        Object value = null;
        value = this.getAttribute(name, 1);
        if (value == null) {
            value = this.getAttribute(name, 2);
        }
        if (value == null) {
            value = this.getAttribute(name, 3);
        }
        if (value == null) {
            value = this.getAttribute(name, 4);
        }
        return value;
    }

    public Object getAttribute(String name) {
        return this.getAttribute(name, 1);
    }

    public Object getAttribute(String name, int scope) {
        switch (scope) {
            case 1: {
                return this.pageScopeAttributes.get(name);
            }
            case 2: {
                return this.getRequest().getAttribute(name);
            }
            case 3: {
                return this.getSession().getAttribute(name);
            }
            case 4: {
                return this.applicationScopeAttributes.get(name);
            }
        }
        throw this.invalidScope(scope);
    }

    private RuntimeException invalidScope(int scope) {
        throw new RuntimeException(VALID_SCOPES_DESCRIPTION);
    }

    public Enumeration getAttributeNamesInScope(int scope) {
        switch (scope) {
            case 1: {
                return this.asEnumeration(this.pageScopeAttributes.keySet());
            }
            case 2: {
                return this.getRequest().getAttributeNames();
            }
            case 3: {
                return this.getSession().getAttributeNames();
            }
            case 4: {
                return this.asEnumeration(this.applicationScopeAttributes.keySet());
            }
        }
        throw this.invalidScope(scope);
    }

    private Enumeration asEnumeration(Collection collection) {
        return new Vector(collection).elements();
    }

    public int getAttributesScope(String name) {
        if (name == null) {
            throw new NullPointerException("getAttributesScope(String) doesn't accept null input");
        }
        if (this.getAttribute(name, 1) != null) {
            return 1;
        }
        if (this.getAttribute(name, 2) != null) {
            return 2;
        }
        if (this.getAttribute(name, 3) != null) {
            return 3;
        }
        if (this.getAttribute(name, 4) != null) {
            return 4;
        }
        return 0;
    }

    public Exception getException() {
        return null;
    }

    public JspWriter getOut() {
        return this.out;
    }

    public Object getPage() {
        return this.page;
    }

    public ServletRequest getRequest() {
        return this.request;
    }

    public ServletResponse getResponse() {
        return this.response;
    }

    public ServletConfig getServletConfig() {
        return this.servletConfig;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public HttpSession getSession() {
        return this.session;
    }

    public void handlePageException(Exception e) {
        this.logPageException(e);
        throw new RuntimeException(e);
    }

    public void handlePageException(Throwable e) {
        this.logPageException(e);
        throw new RuntimeException(e);
    }

    private void logPageException(Throwable e) {
        System.err.println("PAGE EXCEPTION:");
        e.printStackTrace();
    }

    public void forward(String path) throws ServletException, IOException {
        throw new RuntimeException("Unsupported operation: forward(String)");
    }

    public void include(String path) throws ServletException, IOException {
        throw new RuntimeException("Unsupported operation: include(String)");
    }

    public void include(String reference, boolean b) throws ServletException, IOException {
        throw new RuntimeException("Unsupported operation: include(String, boolean)");
    }

    public void initialize(Servlet servlet, ServletRequest request, ServletResponse response, String errorPageURL, boolean needsSession, int bufferSize, boolean autoFlush) throws IOException, IllegalStateException, IllegalArgumentException {
        this.page = servlet;
        this.request = request;
        this.response = response;
    }

    public void release() {
        this.applicationScopeAttributes.clear();
        this.pageScopeAttributes.clear();
    }

    public void removeAttribute(String name) {
        this.removeAttribute(name, 2);
    }

    public void removeAttribute(String name, int scope) {
        switch (scope) {
            case 2: {
                this.getRequest().removeAttribute(name);
                break;
            }
            case 3: {
                this.getSession().removeAttribute(name);
                break;
            }
            case 1: {
                this.pageScopeAttributes.remove(name);
                break;
            }
            case 4: {
                this.applicationScopeAttributes.remove(name);
                break;
            }
            default: {
                throw this.invalidScope(scope);
            }
        }
    }

    public void setAttribute(String name, Object value) {
        this.setAttribute(name, value, 2);
    }

    public void setAttribute(String name, Object value, int scope) {
        switch (scope) {
            case 2: {
                this.getRequest().setAttribute(name, value);
                break;
            }
            case 3: {
                this.getSession().setAttribute(name, value);
                break;
            }
            case 1: {
                this.pageScopeAttributes.put(name, value);
                break;
            }
            case 4: {
                this.applicationScopeAttributes.put(name, value);
                break;
            }
            default: {
                throw this.invalidScope(scope);
            }
        }
    }

    public ExpressionEvaluator getExpressionEvaluator() {
        return this.expressionEvaluator;
    }

    public VariableResolver getVariableResolver() {
        return new VariableResolverImpl((PageContext)this);
    }

    public void setRequest(ServletRequest servletRequest) {
        this.request = servletRequest;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public void setSession(HttpSession httpSession) {
        this.session = httpSession;
    }

    public void setJspWriter(MockJspWriter jspWriter) {
        this.out = jspWriter;
    }
}

