/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsptest.compiler.jsp20.mock.taglibs;

import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletContext;
import net.sf.jsptest.compiler.jsp20.mock.taglibs.ClasspathTldLocator;
import net.sf.jsptest.compiler.jsp20.mock.taglibs.ExplodedTldLocator;
import net.sf.jsptest.compiler.jsp20.mock.taglibs.TldLocation;
import net.sf.jsptest.compiler.jsp20.mock.taglibs.TldLocator;
import net.sf.jsptest.compiler.jsp20.mock.taglibs.TldUriMappings;
import net.sf.jsptest.compiler.jsp20.mock.taglibs.WebInfLibTldLocator;
import org.apache.jasper.JasperException;
import org.apache.jasper.compiler.TldLocationsCache;

public class MockTldLocationsCache
extends TldLocationsCache {
    private TldUriMappings standardTlds;
    private TldLocationsCache realCache;
    private String webRoot;
    private TldLocator[] locators;

    public MockTldLocationsCache(TldLocationsCache delegate, ServletContext ctx) {
        this(delegate, ctx, true);
    }

    public MockTldLocationsCache(TldLocationsCache delegate, ServletContext ctx, boolean redeployMode) {
        super(ctx, redeployMode);
        this.realCache = delegate;
        this.webRoot = ctx.getRealPath("/");
        this.standardTlds = new TldUriMappings();
        this.locators = new TldLocator[]{new WebInfLibTldLocator(this.webRoot), new ExplodedTldLocator(this.webRoot), new ClasspathTldLocator()};
    }

    public String[] getLocation(String uri) throws JasperException {
        if (this.standardTlds.contains(uri)) {
            List tldFileNames = this.standardTlds.get(uri);
            Iterator it = tldFileNames.iterator();
            while (it.hasNext()) {
                String tldFileName = (String)it.next();
                for (int i = 0; i < this.locators.length; ++i) {
                    TldLocation location = this.locators[i].find(tldFileName);
                    if (!location.wasFound()) continue;
                    return location.toArray();
                }
            }
        }
        return this.realCache.getLocation(uri);
    }
}

