/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsptest.compiler.jsp20.mock.taglibs;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import net.sf.jsptest.compiler.jsp20.mock.taglibs.TldLocation;
import net.sf.jsptest.compiler.jsp20.mock.taglibs.TldLocator;

public class WebInfLibTldLocator
implements TldLocator {
    private final String webRoot;

    public WebInfLibTldLocator(String webRoot) {
        this.webRoot = webRoot;
    }

    public TldLocation find(String filename) {
        File webInfLib = new File(new File(this.webRoot, "WEB-INF"), "lib");
        if (webInfLib.exists()) {
            File[] archives = this.findArchivesFrom(webInfLib);
            return this.findTldFromArchives(filename, archives);
        }
        return TldLocation.notFound();
    }

    private TldLocation findTldFromArchives(String filename, File[] archives) {
        for (int i = 0; i < archives.length; ++i) {
            try {
                JarFile archive = new JarFile(archives[i]);
                JarEntry entry = archive.getJarEntry("META-INF/" + filename);
                if (entry == null) continue;
                return TldLocation.foundFromClassPath(archives[i].toURL().toString(), "META-INF/" + filename);
            }
            catch (IOException ignored) {
                // empty catch block
            }
        }
        return TldLocation.notFound();
    }

    private File[] findArchivesFrom(File dir) {
        return dir.listFiles(new FilenameFilter(){

            public boolean accept(File directory, String name) {
                return name.endsWith(".jar");
            }
        });
    }
}

