/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.jsp.tagext.TagInfo;
import net.sf.jsptest.TagKey;
import org.apache.jasper.JasperException;
import org.apache.jasper.compiler.ErrorDispatcher;
import org.apache.jasper.compiler.Node;
import org.apache.jasper.compiler.PageInfo;
import org.apache.jasper.compiler.TagPluginManager;

public class MockTagPluginManager
extends TagPluginManager {
    protected Map mockTaglibs;

    public MockTagPluginManager(ServletContext ctx, TagPluginManager manager, Map taglibs) {
        super(ctx);
        this.mockTaglibs = new HashMap(taglibs);
    }

    public void apply(Node.Nodes nodes, ErrorDispatcher errorDispatcher, PageInfo pageInfo) throws JasperException {
        this.invokePrivateInitWith(errorDispatcher);
        this.assignToPrivateField("pageInfo", pageInfo);
        this.substituteMocksFor(nodes);
    }

    private void substituteMocksFor(Node.Nodes nodes) throws JasperException {
        nodes.visit((Node.Visitor)new TagSubstitutor(this.mockTaglibs));
    }

    private void assignToPrivateField(String fieldName, Object value) {
        try {
            Field field = ((Object)((Object)this)).getClass().getSuperclass().getDeclaredField(fieldName);
            field.setAccessible(true);
            field.set((Object)this, value);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void invokePrivateInitWith(ErrorDispatcher errorDispatcher) {
        try {
            Method init = ((Object)((Object)this)).getClass().getSuperclass().getDeclaredMethod("init", ErrorDispatcher.class);
            init.setAccessible(true);
            init.invoke((Object)this, errorDispatcher);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static class TagSubstitutor
    extends Node.Visitor {
        private final Map mocks;

        public TagSubstitutor(Map mockTaglibs) {
            this.mocks = mockTaglibs;
        }

        public void visit(Node.CustomTag n) throws JasperException {
            Class mockClass = this.substitute(n.getTagInfo());
            if (mockClass != null) {
                n.setTagHandlerClass(mockClass);
            }
            super.visit(n);
        }

        private Class substitute(TagInfo tagInfo) {
            String prefix = tagInfo.getTagLibrary().getPrefixString();
            String name = tagInfo.getTagName();
            TagKey[] matchingOrder = new TagKey[]{new TagKey(prefix, name), new TagKey(prefix)};
            return this.firstMatch(this.mocks, matchingOrder);
        }

        private Class firstMatch(Map map, TagKey[] keys) {
            for (int i = 0; i < keys.length; ++i) {
                if (!map.containsKey(keys[i])) continue;
                return (Class)this.mocks.get(keys[i]);
            }
            return null;
        }
    }
}

